/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.imp.FileResourceImportJob;
import kd.isc.iscb.platform.core.imp.FileResourceParseJob;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.imp.WhiteListImportJob;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.permission.ImportController;
import kd.isc.iscb.platform.core.solution.ResourceCenterDeployJob;
import kd.isc.iscb.platform.core.solution.SolutionResourceDeployJob;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.script.Script;

public class FileResourceImportFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
UploadListener {
    public static final String BTN_REF_RES_DIFF_COMP = "btn_ref_res_diff_comp";
    public static final String BTN_REF_RES_STACKTRACE = "btn_ref_res_stacktrace";
    public static final String BTN_MAIN_RES_DIFF_COMP = "btn_main_res_diff_comp";
    public static final String BTN_MAIN_RES_STACKTRACE = "btn_main_res_stacktrace";
    public static final String PROGRESS = "progress";
    public static final String PARSED = "PARSED";
    public static final String IMPORTING = "IMPORTING";
    public static final String IMPORTED = "IMPORTED";
    public static final String PARSING = "PARSING";
    public static final String READY = "READY";
    public static final String BILLNO = "billno";
    public static final String RES_TYPE = "res_type";
    public static final String MAIN_RESOURCES = "main_resources";
    public static final String REF_RESOURCES = "ref_resources";
    public static final String IMPORT = "import";
    public static final String IMPORT_TYPE = "import_type";
    public static final String BTN_MAIN_OMITTED_MSG = "btn_main_omitted_msg";
    public static final String BTN_REF_OMITTED_MSG = "btn_ref_omitted_msg";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getPageCache().put(IMPORT_TYPE, this.isSolution() ? ResManager.loadKDString((String)"\u90e8\u7f72", (String)"FileResourceImportFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bfc\u5165", (String)"FileResourceImportFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setResType();
        this.setBillNo();
        String progress = D.s((Object)this.getModel().getValue(PROGRESS));
        this.setButtonParse(progress);
        this.setButtonImport(progress);
        this.setVisibleByState(progress);
        this.setSaveByResIsEmpty();
        this.getModel().setDataChanged(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_REF_RES_STACKTRACE, BTN_MAIN_RES_STACKTRACE, BTN_MAIN_OMITTED_MSG, BTN_REF_OMITTED_MSG, "btn_main_force_cover"});
        this.setStateColor();
    }

    private boolean isSolution() {
        Object entity = this.getView().getFormShowParameter().getCustomParam("entity");
        return "isc_solution_center".equals(entity) || "isc_solution_center_m".equals(entity);
    }

    private void setVisibleByState(String progress) {
        this.getView().setVisible(Boolean.valueOf(PARSED.equals(progress) || IMPORTING.equals(progress) || IMPORTED.equals(progress)), new String[]{BTN_REF_RES_DIFF_COMP, BTN_MAIN_RES_DIFF_COMP});
        this.getView().setVisible(Boolean.valueOf(!IMPORTING.equals(progress) && !IMPORTED.equals(progress)), new String[]{"item_append", "item_cover"});
    }

    private void setSaveByResIsEmpty() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List list = attachmentPanel.getAttachmentData();
        this.getView().setEnable(Boolean.valueOf(!list.isEmpty()), new String[]{"bar_save"});
    }

    public void afterUpload(UploadEvent evt) {
        this.setSaveByResIsEmpty();
    }

    public void afterRemove(UploadEvent evt) {
        this.setSaveByResIsEmpty();
    }

    private void setButtonImport(String progress) {
        boolean isImportable = PARSED.equals(progress) || IMPORTING.equals(progress);
        boolean isMainResEmpty = this.getModel().getEntryEntity(MAIN_RESOURCES).isEmpty();
        this.getView().setEnable(Boolean.valueOf(isImportable && !isMainResEmpty), new String[]{"btn_import"});
        if (isImportable && !isMainResEmpty) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8d44\u6e90\u6587\u4ef6\u6570\u636e\uff0c\u786e\u8ba4\u540e\u518d\u70b9\u51fb\u201c%s\u201d\u3002", (String)"FileResourceImportFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getPageCache().get(IMPORT_TYPE)), Integer.valueOf(3000));
        }
    }

    private void setButtonParse(String progress) {
        boolean isParseable = PARSING.equals(progress) || PARSED.equals(progress) || READY.equals(progress);
        this.getView().setEnable(Boolean.valueOf(isParseable), new String[]{"btn_parse"});
    }

    private void setBillNo() {
        String billno = D.s((Object)this.getModel().getValue(BILLNO));
        if (billno == null) {
            this.getModel().setValue(BILLNO, (Object)Hash.mur32((Object[])new Object[]{UUID.randomUUID().toString()}));
        }
    }

    private void setResType() {
        if (D.s((Object)this.getModel().getValue(RES_TYPE)) == null) {
            String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
            if (entity == null) {
                entity = "isc_metadata_schema";
            }
            this.getModel().setValue(RES_TYPE, (Object)FileResourceUtil.getEntityTitle((String)entity));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey())) {
            this.startParsingFiles();
        } else if ("parse".equals(e.getOperateKey())) {
            this.startParsingFiles();
        } else if (IMPORT.equals(e.getOperateKey())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(IMPORT, (IFormPlugin)this);
            this.getView().showConfirm(this.getConfirmTips(), MessageBoxOptions.YesNo, confirmCallBacks);
        } else if ("view_main_res_error".equals(e.getOperateKey())) {
            this.showStackTrace(MAIN_RESOURCES, "t_iscb_dts_imp_mrs2");
        } else if ("view_ref_res_error".equals(e.getOperateKey())) {
            this.showStackTrace(REF_RESOURCES, "t_iscb_dts_imp_rrs2");
        } else if ("main_res_diff_comp".equals(e.getOperateKey())) {
            this.showDiffComp(MAIN_RESOURCES, "t_iscb_dts_imp_mrs2");
        } else if ("ref_res_diff_comp".equals(e.getOperateKey())) {
            this.showDiffComp(REF_RESOURCES, "t_iscb_dts_imp_rrs2");
        } else if ("ref_res_mode_update".equals(e.getOperateKey())) {
            this.setResMode("UPDATE", ResManager.loadKDString((String)"\u8986\u76d6", (String)"FileResourceImportFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("ref_res_mode_insert".equals(e.getOperateKey())) {
            this.setResMode("INSERT", ResManager.loadKDString((String)"\u5173\u8054", (String)"FileResourceImportFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("view_main_res_omit".equals(e.getOperateKey())) {
            this.showOmitMessage(MAIN_RESOURCES, "main_importing_operation", "main_res_type", "main_res_pk", "main_res_trace");
        } else if ("view_ref_res_omit".equals(e.getOperateKey())) {
            this.showOmitMessage(REF_RESOURCES, "ref_importing_operation", "ref_res_type", "ref_res_pk", "ref_res_trace");
        } else if ("btn_main_force_cover".equals(e.getOperateKey())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("force_import", (IFormPlugin)this);
            this.getView().showConfirm(this.getConfirmTips(), MessageBoxOptions.YesNo, confirmCallBacks);
        } else if ("refresh".equals(e.getOperateKey())) {
            this.setStateColor();
        }
    }

    private void setLocalTimeColor(String entryKey, String localTimeKey, String resTimeKey) {
        DynamicObjectCollection resources = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(resources.size());
        for (int i = 0; i < resources.size(); ++i) {
            DynamicObject entry = (DynamicObject)resources.get(i);
            Timestamp localTime = D.t((Object)entry.get(localTimeKey));
            Timestamp resTime = D.t((Object)entry.get(resTimeKey));
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey(localTimeKey);
            if (localTime != null && !localTime.equals(resTime)) {
                cellStyle.setForeColor("#ee812a");
            } else {
                cellStyle.setForeColor("black");
            }
            styles.add(cellStyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        grid.setCellStyle(styles);
    }

    private void setStateColor() {
        String state = D.s((Object)this.getModel().getValue("state"));
        if ("SUCCESS".equals(state) || "FAILED".equals(state)) {
            this.setStateColor(MAIN_RESOURCES, "main_state");
            this.setStateColor(REF_RESOURCES, "ref_state");
        } else if (READY.equals(state)) {
            this.setLocalTimeColor(MAIN_RESOURCES, "main_local_time", "main_res_time");
            this.setLocalTimeColor(REF_RESOURCES, "ref_local_time", "ref_res_time");
        }
    }

    private void setStateColor(String entryKey, String stateKey) {
        DynamicObjectCollection resources = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(resources.size());
        for (int i = 0; i < resources.size(); ++i) {
            DynamicObject entry = (DynamicObject)resources.get(i);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey(stateKey);
            Object o = entry.get(stateKey);
            if ("SUCCESS".equals(o)) {
                cellStyle.setForeColor("#1BA854");
            } else if ("FAILED".equals(o)) {
                cellStyle.setForeColor("#FB2323");
            } else if ("OMITTED".equals(o)) {
                cellStyle.setForeColor("#F08705");
            }
            styles.add(cellStyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        grid.setCellStyle(styles);
    }

    private void showOmitMessage(String entryKey, String operation, String type, String resId, String sourceTrace) {
        int row = D.i((Object)this.getPageCache().get(entryKey));
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entryKey, row);
        String entityTitle = D.s((Object)entryRowEntity.get(type));
        String entityName = FileResourceUtil.getEntityName((String)entityTitle);
        String pk = D.s((Object)entryRowEntity.get(resId));
        Object id = FileResourceUtil.parseResPK((String)pk, (String)entityName);
        String op = D.s((Object)entryRowEntity.get(operation));
        String importSourceTrace = D.s((Object)entryRowEntity.get(sourceTrace));
        String omittedMsg = ImportController.checkImportResource((String)op, (String)entityName, (Object)id, (String)importSourceTrace);
        if ("isc_white_list".equals(entityName)) {
            omittedMsg = ResManager.loadKDString((String)"\u6b64\u767d\u540d\u5355\u5728\u5f53\u524d\u73af\u5883\u4e2d\u8bb8\u53ef\u72b6\u6001\u4e3a\u6b63\u5e38\uff0c\u65e0\u9700\u5bfc\u5165", (String)"FileResourceImportFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        FormOpener.showMessage(this, ResManager.loadKDString((String)"\u5ffd\u7565\u539f\u56e0", (String)"FileResourceImportFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), omittedMsg);
    }

    private String getConfirmTips() {
        if (this.isSolution()) {
            return ResManager.loadKDString((String)"\u90e8\u7f72\u524d\uff0c\u8bf7\u786e\u8ba4\u4e0b\u5217\u5185\u5bb9\u5df2\u68c0\u67e5\u5b8c\u6bd5\uff1a", (String)"FileResourceImportFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"1\u3001\u68c0\u67e5\u8d44\u6e90\u5bfc\u5165\u65b9\u5f0f(\u907f\u514d\u8bef\u8986\u76d6\u5df2\u5b58\u5728\u5185\u5bb9)", (String)"FileResourceImportFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"2\u3001\u901a\u8fc7\u5dee\u5f02\u6bd4\u8f83\u5bf9\u6bd4\u4e0e\u7cfb\u7edf\u73b0\u6709\u8d44\u6e90\u7684\u5dee\u5f02", (String)"FileResourceImportFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"3\u3001\u82e5\u5b58\u5728\u4e3b\u8d44\u6e90\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u9519\u8bef\u4fe1\u606f", (String)"FileResourceImportFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5bfc\u5165\u524d\uff0c\u8bf7\u786e\u8ba4\u4e0b\u5217\u5185\u5bb9\u5df2\u68c0\u67e5\u5b8c\u6bd5\uff1a", (String)"FileResourceImportFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"1\u3001\u68c0\u67e5\u8d44\u6e90\u5bfc\u5165\u65b9\u5f0f\uff08\u4e3b\u8d44\u6e90\u4ec5\u652f\u6301\u8986\u76d6\uff09", (String)"FileResourceImportFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"2\u3001\u901a\u8fc7\u5dee\u5f02\u6bd4\u8f83\u5bf9\u6bd4\u4e0e\u7cfb\u7edf\u73b0\u6709\u8d44\u6e90\u7684\u5dee\u5f02", (String)"FileResourceImportFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"3\u3001\u82e5\u5b58\u5728\u4e3b\u8d44\u6e90\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u9519\u8bef\u4fe1\u606f", (String)"FileResourceImportFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if (IMPORT.equals(evt.getCallBackId())) {
            this.startImportingFiles();
        } else if ("force_import".equals(evt.getCallBackId())) {
            this.forceCover();
            this.getView().invokeOperation("refresh");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void forceCover() {
        void var7_10;
        EntryGrid entryGrid = (EntryGrid)this.getControl(MAIN_RESOURCES);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length > 10) {
            String tip = ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e910\u6761", (String)"FileResourceImportFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
            return;
        }
        DynamicObjectCollection mainResources = this.getModel().getEntryEntity(MAIN_RESOURCES);
        ArrayList<Object> entryid = new ArrayList<Object>(selectRows.length);
        int[] nArray = selectRows;
        int n = nArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            int idx = nArray[var7_10];
            entryid.add(((DynamicObject)mainResources.get(idx)).getLong("id"));
            ++var7_10;
        }
        List<String> contents = this.loadRes(entryid);
        ImportDynamicObject.innerImport(contents);
        for (Object e : entryid) {
            FileResourceUtil.setEntryState((String)"T_ISCB_DTS_IMP_MRS2", (long)D.l(e), (String)"SUCCESS", null);
        }
        String tip = ResManager.loadKDString((String)"\u8986\u76d6\u6210\u529f", (String)"FileResourceImportFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(tip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadRes(List<Object> entryids) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        ArrayList<String> placeholdList = new ArrayList<String>(entryids.size());
        ArrayList<Integer> types = new ArrayList<Integer>(entryids.size());
        for (int i = 0; i < entryids.size(); ++i) {
            placeholdList.add("?");
            types.add(-5);
        }
        String placehold = String.join((CharSequence)",", placeholdList);
        try {
            String sql = "SELECT fcontent FROM T_ISCB_DTS_IMP_MRS2 WHERE FENTRYID in (" + placehold + ") ORDER BY fseq";
            List rows = DbUtil.executeList((Connection)cn, (String)sql, entryids, types);
            ArrayList<String> contents = new ArrayList<String>(rows.size());
            for (DataRow row : rows) {
                contents.add(D.s((Object)row.get((Object)"fcontent")));
            }
            ArrayList<String> arrayList = contents;
            return arrayList;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void startImportingFiles() {
        IDataModel m = this.getModel();
        long id = D.l((Object)m.getValue("id"));
        List jobs = JobEngine.getJobsWithOwnerId((long)id);
        if (jobs.isEmpty()) {
            Object resType = this.getModel().getValue(RES_TYPE);
            Object job = resType != null && resType.toString().contains("isc_solution_center") ? new SolutionResourceDeployJob(id, String.format(ResManager.loadKDString((String)"\u65b9\u6848\u90e8\u7f72\uff0c\u6279\u53f7\uff1a%s", (String)"FileResourceImportFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), m.getValue(BILLNO))) : (resType != null && resType.toString().contains("isc_resouce_center") ? new ResourceCenterDeployJob(id, String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u90e8\u7f72\uff0c\u6279\u53f7\uff1a%s", (String)"FileResourceImportFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), m.getValue(BILLNO))) : (resType != null && resType.toString().contains("isc_white_list") ? new WhiteListImportJob(id, String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u5bfc\u5165\uff0c\u6279\u53f7\uff1a%s", (String)"FileResourceImportFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), m.getValue(BILLNO))) : new FileResourceImportJob(id, String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u5bfc\u5165\uff0c\u6279\u53f7\uff1a%s", (String)"FileResourceImportFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), m.getValue(BILLNO)))));
            FormOpener.startJob(this, (Job)job, "imported");
        } else {
            JobInfo jobInfo = (JobInfo)jobs.get(0);
            FormOpener.reopenJob(this, jobInfo.getId(), jobInfo.getTitle(), "imported");
        }
    }

    private void startParsingFiles() {
        IDataModel m = this.getModel();
        long id = D.l((Object)m.getValue("id"));
        List jobs = JobEngine.getJobsWithOwnerId((long)id);
        if (jobs.isEmpty()) {
            FileResourceParseJob job = new FileResourceParseJob(id, String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u89e3\u6790\uff0c\u6279\u53f7\uff1a%s", (String)"FileResourceImportFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), m.getValue(BILLNO)));
            FormOpener.startJob(this, (Job)job, "parsed");
        } else {
            JobInfo jobInfo = (JobInfo)jobs.get(0);
            FormOpener.reopenJob(this, jobInfo.getId(), jobInfo.getTitle(), "parsed");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("parsed".equals(action) || "imported".equals(action)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((EntryGrid)this.getView().getControl(MAIN_RESOURCES)).addRowClickListener((RowClickEventListener)this);
        ((EntryGrid)this.getView().getControl(REF_RESOURCES)).addRowClickListener((RowClickEventListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void entryRowClick(RowClickEvent e) {
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        int row = e.getRow();
        String entryKey = entryGrid.getKey();
        this.getPageCache().put(entryKey, String.valueOf(row));
        this.getView().setVisible(Boolean.valueOf(this.isFailed(entryKey, row)), new String[]{this.getBtnStackTrace(entryKey)});
        this.getView().setVisible(this.hasLocalTime(entryKey, row), new String[]{this.getBtnDiffComp(entryKey)});
        this.getView().setVisible(Boolean.valueOf(this.isOmitted(entryKey, row)), this.getBtnOmittedStackTrace(entryKey));
    }

    private String[] getBtnOmittedStackTrace(String entryKey) {
        if (MAIN_RESOURCES.equals(entryKey)) {
            return new String[]{BTN_MAIN_OMITTED_MSG, "btn_main_force_cover"};
        }
        return new String[]{BTN_REF_OMITTED_MSG};
    }

    private boolean isOmitted(String entryKey, int row) {
        if (MAIN_RESOURCES.equals(entryKey)) {
            return "OMITTED".equals(this.getModel().getValue("main_state", row));
        }
        return "OMITTED".equals(this.getModel().getValue("ref_state", row));
    }

    private void setResMode(String mode, String title) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(REF_RESOURCES);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d8\u66f4\u5bfc\u5165\u65b9\u5f0f\u7684\u4f9d\u8d56\u8d44\u6e90\u3002", (String)"FileResourceImportFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>(rows.length);
            for (int row : rows) {
                this.getModel().setValue("ref_importing_operation", (Object)mode, row);
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(row);
                cellStyle.setFieldKey("ref_importing_operation");
                if ("UPDATE".equals(mode)) {
                    cellStyle.setForeColor("red");
                } else {
                    cellStyle.setForeColor("black");
                }
                styles.add(cellStyle);
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl(REF_RESOURCES);
            grid.setCellStyle(styles);
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u9009\u5b9a\u7684%1$s\u4e2a\u4f9d\u8d56\u8d44\u6e90\u5df2\u88ab\u8bbe\u7f6e\u4e3a\u201c%2$s\u201d\u5bfc\u5165\u65b9\u5f0f\u3002", (String)"FileResourceImportFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), rows.length, title));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDiffComp(String entryKey, String entryTable) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u8d44\u6e90\u4e0e\u5176\u5386\u53f2\u7248\u672c\u6bd4\u8f83\u3002", (String)"FileResourceImportFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        int row = D.i((Object)this.getPageCache().get(entryKey));
        long entryId = D.l((Object)this.getModel().getEntryRowEntity(entryKey, row).get("id"));
        String sql = "SELECT fcontent,ftype FROM " + entryTable + " WHERE fentryid = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            DataRow data = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(entryId), Collections.singletonList(-5));
            Map res = (Map)Script.parseJson((String)((String)data.get((Object)"fcontent")));
            String entity = FileResourceUtil.getEntityName((String)((String)data.get((Object)"ftype")));
            Object id = FileResourceUtil.parseResPK((String)D.s(res.get("id")), (String)entity);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)entity);
            Map local = DynamicObjectUtil.object2Map((DynamicObject)obj);
            FormOpener.showDiffComp(this, entity, local, ResManager.loadKDString((String)"\u672c\u5730\u5185\u5bb9\uff08\u65e7\uff09", (String)"FileResourceImportFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), res, ResManager.loadKDString((String)"\u8d44\u6e90\u5185\u5bb9\uff08\u65b0\uff09", (String)"FileResourceImportFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStackTrace(String entryKey, String entryTable) {
        int row = D.i((Object)this.getPageCache().get(entryKey));
        long entryId = D.l((Object)this.getModel().getEntryRowEntity(entryKey, row).get("id"));
        String sql = "SELECT fstack_trace FROM " + entryTable + " WHERE fentryid = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String stacktrace = (String)DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(entryId), Collections.singletonList(-5));
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u201c\u67e5\u770b\u8be6\u60c5\u201d\u67e5\u770b\u66f4\u591a\u4fe1\u606f", (String)"FileResourceImportFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), stacktrace);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private String getBtnDiffComp(String entryKey) {
        if (MAIN_RESOURCES.equals(entryKey)) {
            return BTN_MAIN_RES_DIFF_COMP;
        }
        return BTN_REF_RES_DIFF_COMP;
    }

    private Boolean hasLocalTime(String entryKey, int row) {
        if (row == -1) {
            return Boolean.TRUE;
        }
        if (MAIN_RESOURCES.equals(entryKey)) {
            return this.getModel().getValue("main_local_time", row) != null;
        }
        return this.getModel().getValue("ref_local_time", row) != null;
    }

    private String getBtnStackTrace(String entryKey) {
        if (MAIN_RESOURCES.equals(entryKey)) {
            return BTN_MAIN_RES_STACKTRACE;
        }
        return BTN_REF_RES_STACKTRACE;
    }

    private boolean isFailed(String entryKey, int row) {
        if (MAIN_RESOURCES.equals(entryKey)) {
            return "FAILED".equals(this.getModel().getValue("main_state", row));
        }
        return "FAILED".equals(this.getModel().getValue("ref_state", row));
    }
}

