/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.license.GrayFeatureUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class IscGrayFeatureApplyFormPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log LOGGER = LogFactory.getLog(IscGrayFeatureApplyFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Html html = (Html)this.getControl("htmlap");
        String s = ResManager.loadKDString((String)"1\u3001\u6b64\u7279\u6027\u4e3a\u7070\u5ea6\u53d1\u5e03\u65b0\u7279\u6027\uff0c\u5f53\u524d\u73af\u5883\u6ca1\u6709\u8bb8\u53ef\u6216\u5df2\u8fc7\u671f\uff0c\u8bf7\u8f93\u5165\u7070\u5ea6\u7279\u6027\u8bb8\u53ef\u5bc6\u94a5\u8fdb\u884c\u9a8c\u8bc1\u3002\u5982\u679c\u6ca1\u6709\u5bc6\u94a5\uff0c\u8bf7\u6309\u7167\u4e0b\u65b9\u7684\u7533\u8bf7\u65b9\u6cd5\u83b7\u53d6\u3002<br/>2\u3001\u7533\u8bf7\u6d41\u7a0b\uff1a<br/> \uff081\uff09\u516c\u6709\u4e91\u7528\u6237\uff0c\u70b9\u51fb\u3010\u7533\u8bf7\u5bc6\u94a5\u3011\u6309\u94ae\uff1b<br/> \uff082\uff09\u79c1\u6709\u4e91\u7528\u6237\uff0c\u8bf7\u5c06\u3010\u7279\u6027\u7f16\u7801\u3011\u3001\u3010\u73af\u5883\u7279\u5f81\u7801\u3011\u3001\u3010\u4f01\u4e1a\u540d\u79f0\u3011\u4ee5\u53ca\u60a8\u7684\u8054\u7cfb\u65b9\u5f0f\uff08\u624b\u673a\u53f7\uff09\u53d1\u9001\u5230hongchao_wu@kingdee.com\u90ae\u7bb1\u3002 <br/>3\u3001\u5176\u4ed6\u8bf4\u660e\uff1a\u7533\u8bf7\u7070\u5ea6\u7279\u6027\u8bb8\u53ef\u7684\u7528\u6237\uff0c\u9700\u9075\u5faa\u300a\u91d1\u8776\u539f\u578b\u5ba2\u6237\u7ba1\u7406\u529e\u6cd5\u300b\u76f8\u5173\u534f\u8bae\u548c\u6d41\u7a0b\u3002", (String)"IscGrayFeatureApplyFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        html.setConent(s);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"apply"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter params = this.getView().getFormShowParameter();
        String feature_number = (String)params.getCustomParam("feature_number");
        String feature_name = (String)params.getCustomParam("feature_name");
        this.getModel().setValue("feature_number", (Object)feature_number);
        this.getModel().setValue("feature_name", (Object)feature_name);
        this.getModel().setValue("env_sign", (Object)GrayFeatureUtil.generateEnvSign((String)feature_number));
        this.getView().setVisible(Boolean.FALSE, new String[]{"flex_success_tip", "flex_fail_tip"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("verify_license".equals(e.getOperateKey())) {
            String license_content = D.s((Object)this.getModel().getValue("license_content"));
            String feature_number = D.s((Object)this.getModel().getValue("feature_number"));
            Date deadLine = null;
            try {
                deadLine = GrayFeatureUtil.saveLicense((String)feature_number, (String)license_content);
                GrayFeatureUtil.checkLicenseState((String)feature_number);
                this.tipsDeadLine(deadLine);
            }
            catch (Throwable t) {
                LOGGER.error("\u8bb8\u53ef\u5bc6\u94a5\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff1a", t);
                if (t instanceof IscBizException) {
                    this.showFailTips(t.getMessage());
                }
                throw t;
            }
        }
    }

    private void tipsDeadLine(Date deadLine) {
        if (deadLine != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String s = ResManager.loadKDString((String)"\u6821\u9a8c\u6210\u529f\uff0c\u6b64\u5bc6\u94a5\u6709\u6548\u671f\u81f3\uff1a%s\u3002", (String)"IscGrayFeatureApplyFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            String message = String.format(s, sdf.format(deadLine));
            this.showSuccessTips(message);
        } else {
            String s = ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u5bc6\u94a5\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u6216\u91cd\u65b0\u7533\u8bf7\u5bc6\u94a5\u3002", (String)"IscGrayFeatureApplyFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.showFailTips(s);
        }
    }

    private void showFailTips(String message) {
        Label label = (Label)this.getControl("fail_text");
        label.setText(message);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flex_success_tip"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flex_fail_tip"});
        this.getView().updateView("flex_success_tip");
        this.getView().updateView("flex_fail_tip");
    }

    private void showSuccessTips(String message) {
        Label label = (Label)this.getControl("success_text");
        label.setText(message);
        this.getView().setVisible(Boolean.TRUE, new String[]{"flex_success_tip"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flex_fail_tip"});
        this.getView().updateView("flex_success_tip");
        this.getView().updateView("flex_fail_tip");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String clickKey = c.getKey().toLowerCase();
        if ("apply".equals(clickKey)) {
            String url = this.getApplyUrl();
            this.getView().openUrl(url);
        }
    }

    private String getApplyUrl() {
        String url = System.getProperty("isc_gray_feature_apply_url");
        String featureNumber = D.s((Object)this.getModel().getValue("feature_number"));
        String featureCode = D.s((Object)this.getModel().getValue("env_sign"));
        if (StringUtil.isEmpty((String)url)) {
            url = String.format("http://dev.kingdee.com/applysecretkey?featureNumber=%s&featureCode=%s", featureNumber, featureCode);
            return url;
        }
        url = url + String.format("?featureNumber=%s&featureCode=%s", featureNumber, featureCode);
        return url;
    }
}

