/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.license.IscResourceLicenseUtil;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.ReflectionUtil;

public class IscResourceLicenseListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("add_service_flow".equals(args.getOperateKey())) {
            FormOpener.showF7((AbstractFormPlugin)this, "isc_service_flow", "isc_service_flow", true);
        } else if ("add_metadata_schema".equals(args.getOperateKey())) {
            FormOpener.showF7((AbstractFormPlugin)this, "isc_metadata_schema", "isc_metadata_schema", true, true);
        } else if ("add_data_flow".equals(args.getOperateKey())) {
            QFilter[] filter = new QFilter[]{new QFilter("type", "=", (Object)"DataWeaver.DataFlow")};
            FormOpener.showF7((AbstractFormPlugin)this, "iscx_resource", filter, "iscx_resource.data_flow", true);
        } else if ("add_data_copy".equals(args.getOperateKey())) {
            FormOpener.showF7((AbstractFormPlugin)this, "isc_data_copy", "isc_data_copy", true);
        } else if ("add_apic_script".equals(args.getOperateKey())) {
            FormOpener.showF7((AbstractFormPlugin)this, "isc_apic_script", "isc_apic_script", true, true);
        } else if ("add_apic_webapi".equals(args.getOperateKey())) {
            FormOpener.showF7((AbstractFormPlugin)this, "isc_apic_webapi", "isc_apic_webapi", true, true);
        } else if ("add_external_api".equals(args.getOperateKey())) {
            FormOpener.showF7((AbstractFormPlugin)this, "isc_apic_for_external_api", "isc_apic_for_external_api", true);
        } else if ("sync_env".equals(args.getOperateKey())) {
            IscResourceLicenseUtil.syncLicenseState();
            IscResourceLicenseUtil.clearCache();
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returns = e.getReturnData();
        if (returns instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection c = (ListSelectedRowCollection)returns;
            String type = e.getActionId();
            int i = type.indexOf(46);
            String entity = i < 0 ? type : type.substring(0, i);
            boolean hasGroup = EntityMetadataCache.getDataEntityType((String)entity).getProperties().containsKey((Object)"group");
            DynamicObjectCollection resources = this.queryResources(c, entity, hasGroup);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            for (DynamicObject res : resources) {
                this.append(list, type, hasGroup, res);
            }
            if (list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u9009\u62e9\u7684\u8d44\u6e90\u90fd\u5df2\u5728\u65b9\u6848\u8bb8\u53ef\u5217\u8868\u4e2d\u3002", (String)"IscResourceLicenseListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                int resourceLicenseCount = LicenseCache.getTenant().getResourceLicenseCount();
                if (this.licensedResourceCount() + list.size() > resourceLicenseCount) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62df\u5df2\u5206\u914d\u65b9\u6848\u8bb8\u53ef\u7684\u8d44\u6e90\u6570\u8d85\u8fc7\u4e86\u65b9\u6848\u8bb8\u53ef\u603b\u6570\uff08%s\uff09\uff0c\u8bf7\u5220\u9664\u90e8\u5206\u8d44\u6e90\u540e\u518d\u6dfb\u52a0\u3002", (String)"IscResourceLicenseListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), resourceLicenseCount));
                } else {
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
                    this.getView().invokeOperation("refresh");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u65b9\u6848\u8bb8\u53ef\u540d\u5355\u786e\u5b9a\u540e\uff0c\u8bf7\u70b9\u51fb\u201c\u540c\u6b65\u8bb8\u53ef\u201d\u4f7f\u4e4b\u751f\u6548\u3002", (String)"IscResourceLicenseListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int licensedResourceCount() {
        String sql = "SELECT COUNT(*) AS C FROM t_isc_lic_resource";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            int n = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql));
            return n;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void append(List<DynamicObject> list, String type, boolean hasGroup, DynamicObject res) {
        Object id = res.get("id");
        QFilter[] filter = new QFilter[]{new QFilter("type", "=", (Object)type).and(new QFilter("resourceid", "=", id))};
        if (QueryServiceHelper.exists((String)"isc_lic_resource", (QFilter[])filter)) {
            return;
        }
        DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"isc_lic_resource");
        item.set("type", (Object)type);
        item.set("number", (Object)D.s((Object)res.get("number")));
        item.set("name", (Object)D.s((Object)res.get("name")));
        item.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        item.set("resourceid", id);
        item.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        if (hasGroup) {
            item.set("data_source", res.get("group"));
        }
        list.add(item);
    }

    private DynamicObjectCollection queryResources(ListSelectedRowCollection c, String entity, boolean hasGroup) {
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)c.getPrimaryKeyValues())};
        String properties = "id,number,name";
        if (hasGroup) {
            properties = properties + ",group";
        }
        DynamicObjectCollection resources = QueryServiceHelper.query((String)entity, (String)properties, (QFilter[])filter);
        return resources;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        ListSelectedRow row;
        e.setCancel(true);
        Object src = e.getHyperLinkClickEvent().getSource();
        if (src instanceof BillList && (row = ((BillList)src).getCurrentSelectedRowInfo()) != null) {
            Object id = row.getPrimaryKeyValue();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_lic_resource");
            String type = obj.getString("type");
            long pk = D.l((Object)obj.get("resourceid"));
            if (type.startsWith("iscx_resource.")) {
                this.showIscxResourceDetailsView(pk);
            } else {
                FormOpener.showView((AbstractFormPlugin)this, type, pk);
            }
        }
    }

    private void showIscxResourceDetailsView(long pk) {
        try {
            Method m = ReflectionUtil.getClass((String)"kd.isc.iscx.formplugin.res.ResourceEditorUtil").getMethod("openResourceViewer1", Long.TYPE, AbstractFormPlugin.class);
            m.invoke(null, new Object[]{pk, this});
        }
        catch (Exception err) {
            FormOpener.showView((AbstractFormPlugin)this, "iscx_resource", pk);
        }
    }
}

