/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.license.IscWhiteListUtil;
import kd.isc.iscb.platform.core.license.UpdateCloudWhiteListJob;
import kd.isc.iscb.util.misc.Json;

public class IscWhiteListListPlugin
extends AbstractListPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String role = System.getProperty("ISC_WHITE_LIST_ROLE");
        if ("admin".equals(role)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"menu_export"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"menu_export"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("sync_state".equals(e.getOperateKey())) {
            Object[] ids = e.getOperationResult().getSuccessPkIds().toArray();
            if (IscWhiteListUtil.refreshState((Object[])ids)) {
                CacheableObjectManager.clearCache();
                this.getView().invokeOperation("refresh");
            }
        } else if ("update_white_list".equals(e.getOperateKey())) {
            this.updateWhiteList();
        }
    }

    private void updateWhiteList() {
        UpdateCloudWhiteListJob updateJob = new UpdateCloudWhiteListJob(ResManager.loadKDString((String)"\u66f4\u65b0\u4e91\u7aef\u767d\u540d\u5355", (String)"IscWhiteListListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Json.toString(Collections.emptyMap()));
        List jobs = JobEngine.getJobsWithOwnerId((long)updateJob.getOwnerId());
        if (jobs.isEmpty()) {
            FormOpener.startJob((AbstractFormPlugin)this, (Job)updateJob, "update_white_list");
        } else {
            FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), updateJob.getTitle(), "update_white_list");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("update_white_list".equals(action)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicTextColumnDesc source;
        super.packageData(e);
        if (e.getSource() instanceof DynamicTextColumnDesc && "license_group".equals((source = (DynamicTextColumnDesc)e.getSource()).getKey())) {
            DynamicObject row = e.getRowData();
            e.setFormatValue((Object)this.getLicenseGroup(row));
        }
    }

    private String getLicenseGroup(DynamicObject row) {
        String sign = row.getString("sign");
        int j = sign.indexOf(59);
        if (j > 0) {
            return sign.substring(j + 1);
        }
        String hash = row.getString("hash");
        int i = hash.indexOf(47);
        if (i > 0) {
            return hash.substring(i + 1);
        }
        return "";
    }
}

