/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools.check;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.rc.Util;
import kd.isc.iscb.platform.core.rc.job.CheckHealthJob;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class CheckToolFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String ISC_HEALTH_CHECK = "ISC_HEALTH_CHECK";
    private static final List<String> KEYS = Arrays.asList("link_state", "link_licensestate", "link_message", "link_source", "datasource", "tps_control", "dc_params", "dc_trigger_params", "dc_triggermsg", "dc_execution", "dc_execlog", "serviceflow", "licenseinfo", "controlparams", "mq_license", "mq_serverstate", "apic_log", "meta_schema_api", "dc_schema_api", "dc_trigger_api", "by_vc_api", "by_sf_api", "apic_script");

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("textfield1", (Object)ResManager.loadKDString((String)"\u6700\u540e\u68c0\u6d4b\u65f6\u95f4\uff1a", (String)"CheckToolFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield3", (Object)ResManager.loadKDString((String)"\u6700\u540e\u64cd\u4f5c\u4eba\uff1a", (String)"CheckToolFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield4", (Object)ResManager.loadKDString((String)"\u6700\u65b0\u62a5\u544a\uff1a", (String)"CheckToolFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.bindLastRecord();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"select_all"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("check".equals(args.getOperateKey())) {
            this.execute();
        } else if ("refresh".equals(args.getOperateKey())) {
            this.bindLastRecord();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"CheckToolFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("showreport".equals(args.getOperateKey())) {
            if (Util.getCheckRecord().size() != 0) {
                FormOpener.showTabForm(this, "isc_health_report", ResManager.loadKDString((String)"\u68c0\u6d4b\u62a5\u544a", (String)"CheckToolFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), null, null);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u62a5\u544a\u6570\u636e,\u8bf7\u5148\u8fdb\u884c\u68c0\u6d4b", (String)"CheckToolFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void execute() {
        Map<String, String> map = this.getCheckItems();
        if (map.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u68c0\u6d4b\u6a21\u5757", (String)"CheckToolFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        CheckHealthJob job = new CheckHealthJob(Json.toString(map), ResManager.loadKDString((String)"\u5065\u5eb7\u5ea6\u68c0\u6d4b", (String)"CheckToolFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        List jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
        if (jobs.isEmpty()) {
            FormOpener.startJob(this, (Job)job, ISC_HEALTH_CHECK);
        } else {
            FormOpener.reopenJob(this, ((JobInfo)jobs.get(0)).getId(), job.getTitle(), ISC_HEALTH_CHECK);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if ("select_all".equals(prop)) {
            boolean checkboxall = D.x((Object)this.getModel().getValue("select_all"));
            this.setValue(KEYS, checkboxall);
        }
    }

    private Map<String, String> getCheckItems() {
        HashMap<String, String> params = new HashMap<String, String>(50);
        for (String key : KEYS) {
            if (!D.x((Object)this.getModel().getValue(key))) continue;
            params.put(key, key);
        }
        if (params.containsKey("link_message")) {
            params.put("link_message2", "link_message2");
        }
        if (params.containsKey("dc_triggermsg")) {
            params.put("dc_triggermsg2", "dc_triggermsg2");
        }
        return params;
    }

    private void setValue(List<String> keys, boolean isCheck) {
        for (String key : keys) {
            this.getModel().setValue(key, (Object)isCheck);
        }
    }

    private void bindLastRecord() {
        List listDr = Util.getCheckRecord();
        for (DataRow dr : listDr) {
            String key = D.s((Object)dr.getValue("fkey"));
            Object value = dr.getValue("fvalue");
            if ("checktime".equals(key)) {
                this.getView().getModel().setValue(key, (Object)D.t((Object)value));
                continue;
            }
            this.getView().getModel().setValue(key, value);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }
}

