/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.trace;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class Forest {
    private ArrayList<Node> rootList = new ArrayList();

    public boolean add(String id, String parentId, String state, String icon, String title) {
        if (StringUtil.isEmpty((String)id) || StringUtil.isEmpty((String)state)) {
            return false;
        }
        Node node = new Node(id, parentId, state, icon, title);
        if (this.rootList.isEmpty() || StringUtil.isEmpty((String)parentId) || !this.insert(node, this.rootList)) {
            this.rootList.add(node);
        }
        this.adjustNodes();
        return true;
    }

    public void adjustNodes() {
        Iterator<Node> iterator = this.rootList.iterator();
        while (iterator.hasNext()) {
            Node tmpNode = iterator.next();
            if (StringUtil.isEmpty((String)tmpNode.getParentId()) || !this.insert(tmpNode, this.rootList)) continue;
            iterator.remove();
        }
    }

    private boolean insert(Node node, ArrayList<Node> rootList) {
        for (Node rootNode : rootList) {
            if (rootNode.getId().equals(node.getParentId())) {
                node.setParent(rootNode);
                rootNode.getNodeList().add(node);
                return true;
            }
            if (!this.insert(node, rootNode.getNodeList())) continue;
            return true;
        }
        return false;
    }

    public Node search(String nodeId) {
        if (StringUtil.isEmpty((String)nodeId)) {
            return null;
        }
        Node node = this.searchNode(nodeId, this.rootList);
        if (node != null) {
            return node;
        }
        return null;
    }

    private Node searchNode(String nodeId, ArrayList<Node> rootList) {
        Node res = null;
        for (Node node : rootList) {
            if (nodeId.equals(node.getId())) {
                return node;
            }
            res = this.searchNode(nodeId, node.getNodeList());
            if (res == null) continue;
            return res;
        }
        return res;
    }

    public List<TreeNode> searchFilterItems(QFilter filter) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (Node node : this.rootList) {
            this.searchForest(result, node, filter);
        }
        if (result.isEmpty()) {
            result.add(new TreeNode("", "0", ResManager.loadKDString((String)"\u8ffd\u6eaf\u4fe1\u606f\u672a\u627e\u5230", (String)"Forest_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        }
        return result;
    }

    private void searchForest(List<TreeNode> result, Node node, QFilter filter) {
        ArrayList<Node> nodeList;
        boolean eval = this.doCheck(filter, node);
        if (eval) {
            this.searchParent(node, result);
        }
        if ((nodeList = node.getNodeList()).isEmpty()) {
            return;
        }
        for (Node node1 : nodeList) {
            this.searchForest(result, node1, filter);
        }
    }

    private void searchParent(Node node, List<TreeNode> result) {
        TreeNode treeNode = new TreeNode(node.getParentId(), node.getId(), node.getTitle());
        treeNode.setIcon(node.getIcon());
        Node parent = node.getParent();
        if (parent == null || result.contains(treeNode)) {
            return;
        }
        result.add(treeNode);
        this.searchParent(parent, result);
    }

    private boolean doCheck(QFilter filter, Node node) {
        if (filter == null) {
            return true;
        }
        Object value = filter.getValue();
        String val = D.s((Object)node.getState());
        return val.equals(value);
    }

    static class Node {
        private Node parent;
        private ArrayList<Node> nodeList = new ArrayList();
        private String id;
        private String parentId;
        private String state;
        private String icon;
        private String title;

        Node(String id, String parentId, String state, String icon, String title) {
            this.id = id;
            this.parentId = parentId;
            this.state = state;
            this.icon = icon;
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public String getState() {
            return this.state;
        }

        public String getIcon() {
            return this.icon;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public ArrayList<Node> getNodeList() {
            return this.nodeList;
        }

        public String getId() {
            return this.id;
        }

        public String getParentId() {
            return this.parentId;
        }
    }
}

