/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.util;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.ischub.triggerInfo.TriggerUtil;
import kd.isc.iscb.platform.core.util.ConnectionUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class EventLogUtil {
    public static void showEventLogList(AbstractFormPlugin form, String abstractTriggerType, Object triggerId) {
        if (triggerId != null) {
            long id = D.l((Object)triggerId);
            if (TriggerUtil.isEventSrcType((String)abstractTriggerType, (long)id)) {
                FormOpener.showList(form, "isc_res_evt_log", "trigger", id);
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>(2);
                if (QueryServiceHelper.exists((String)"isc_data_copy_trigger", (Object)id)) {
                    DynamicObject dblink = EventLogUtil.getDblinkByTriggerId(id);
                    params.put("dblink", dblink.getLong("id"));
                    params.put("name", dblink.getString("name"));
                }
                params.put("trigger_id", id);
                params.put("type", abstractTriggerType);
                FormOpener.showTabForm(form, "isc_con_evt_que", null, params, null);
            }
        }
    }

    private static DynamicObject getDblinkByTriggerId(long triggerId) {
        DynamicObject dataSource = ConnectionUtil.getDataSourceByTrigger((long)triggerId);
        return BusinessDataServiceHelper.loadSingle((Object)dataSource.get("dblink_id"), (String)"isc_database_link");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearEvtBind(long dblinkId, String serverURL, String adminPassword) {
        ConnectionManager.pushResLicense((boolean)true);
        ConnectionWrapper connection = null;
        try {
            connection = ConnectionManager.getConnection((long)dblinkId);
            String iscHub = ConnectorUtil.getIscHub((DynamicObject)connection.getConfig());
            connection.getFactory().undeploy(connection, iscHub, serverURL, adminPassword);
        }
        finally {
            ConnectionManager.popResLicense();
            ConnectorUtil.close((AutoCloseable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDeployState(long dblink, String deployState) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            String sql = "update t_isc_database_link set fdeploy_state = ?, fmodifytime = ? where fid = ?";
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(deployState, new Timestamp(System.currentTimeMillis()), dblink), Arrays.asList(12, 93, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }
}

