/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceTask;

public class FormOpener {
    private static final Log LOG = LogFactory.getLog(FormOpener.class);
    private static final String APP_MIAN_TAB = "appmiantab";
    private static final String CTRL_SUBMAINTAB = "_submaintab_";
    private static final String BOS_LIST = "bos_list";

    public static void startJob(AbstractFormPlugin form, Job job) {
        FormOpener.startJob(form, job, null);
    }

    public static void startJob(AbstractFormPlugin form, Job job, String callback) {
        FormOpener.startJob(form, job, callback, null);
    }

    public static void startJob(final AbstractFormPlugin form, final Job job, final String callback, final Map<String, Object> params) {
        TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

            public void run() {
                long jobId = JobEngine.submit((Job)job);
                String jobTitle = FormOpener.getJobTitle(job);
                FormOpener.reopenJob(form, jobId, jobTitle, callback, params);
            }
        });
    }

    public static void reopenJob(AbstractFormPlugin form, long jobId, String jobTitle) {
        FormOpener.reopenJob(form, jobId, jobTitle, null);
    }

    public static void reopenJob(AbstractFormPlugin form, long jobId, String jobTitle, String callback) {
        FormOpener.reopenJob(form, jobId, jobTitle, callback, null);
    }

    public static void reopenJob(AbstractFormPlugin form, long jobId, String jobTitle, String callback, Map<String, Object> params) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("jobId", jobId);
        if (params != null && !params.isEmpty()) {
            paramsMap.putAll(params);
        }
        FormOpener.showModalForm(form, "isc_job_executor", jobTitle, paramsMap, callback);
    }

    private static String getJobTitle(Job job) {
        String title = job.getTitle();
        if (title == null || "{none}".equals(title)) {
            title = ResManager.loadKDString((String)"\u6267\u884c\u4efb\u52a1", (String)"FormOpener_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        return title;
    }

    public static Object getSelectedId(AbstractFormPlugin form, AfterDoOperationEventArgs e) {
        List successPkIds = e.getOperationResult().getSuccessPkIds();
        switch (successPkIds.size()) {
            case 1: {
                return successPkIds.get(0);
            }
            case 0: {
                form.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u4e00\u884c\u3002", (String)"FormOpener_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return null;
            }
        }
        form.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"FormOpener_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        return null;
    }

    public static Pair<Object, Object> getSelectedTwins(AbstractFormPlugin form, AfterDoOperationEventArgs e) {
        List successPkIds = e.getOperationResult().getSuccessPkIds();
        switch (successPkIds.size()) {
            case 2: {
                return new Pair(successPkIds.get(0), successPkIds.get(1));
            }
            case 0: 
            case 1: {
                form.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u4e24\u884c\u3002", (String)"FormOpener_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return null;
            }
        }
        form.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e24\u884c\u3002", (String)"FormOpener_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        return null;
    }

    public static void showList(AbstractFormPlugin form, String entity, String field, AfterDoOperationEventArgs e) {
        Object id = FormOpener.getSelectedId(form, e);
        if (id != null) {
            FormOpener.showList(form, entity, field, id);
        }
    }

    public static void showListWithParam(AbstractFormPlugin form, String entity, String field, AfterDoOperationEventArgs e, Map<String, Object> params) {
        Object id = FormOpener.getSelectedId(form, e);
        if (id != null) {
            FormOpener.showListWithParam(form, entity, field, id, params);
        }
    }

    public static void showList(AbstractFormPlugin form, String entity, String field, Object id) {
        QFilter filter = new QFilter(field, "=", id);
        FormOpener.openBillList(form, entity, Collections.singletonList(filter));
    }

    public static void showListWithParam(AbstractFormPlugin form, String entity, String field, Object id, Map<String, Object> params) {
        QFilter filter = new QFilter(field, "=", id);
        FormOpener.openBillListWithParam(form, entity, Collections.singletonList(filter), null, params);
    }

    public static void showList(AbstractFormPlugin form, String entity, QFilter filter) {
        FormOpener.openBillList(form, entity, Collections.singletonList(filter));
    }

    public static void showList(AbstractFormPlugin form, String entity, String field, Object value, Map<String, Object> params) {
        QFilter filter = new QFilter(field, "=", value);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entity);
        showParameter.setFormId(BOS_LIST);
        Object caption = params.get("caption");
        if (caption != null) {
            showParameter.setCaption(String.valueOf(caption));
        }
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(filter));
        ShowType type = FormOpener.getShowType(params);
        showParameter.getOpenStyle().setShowType(type);
        form.getView().showForm((FormShowParameter)showParameter);
    }

    private static ShowType getShowType(Map<String, Object> params) {
        ShowType type;
        Object showType = params.get("showType");
        if (showType == null) {
            type = ShowType.MainNewTabPage;
        } else if (showType instanceof ShowType) {
            type = (ShowType)showType;
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684showType\u8d4b\u503c:%1$s,showType\u7c7b\u578b:%2$s", (String)"FormOpener_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), showType, showType.getClass()));
        }
        return type;
    }

    public static void openBillList(AbstractFormPlugin form, String entity, List<QFilter> filters) {
        FormOpener.openBillList(form, entity, filters, null);
    }

    public static void openBillList(AbstractFormPlugin form, String entity, List<QFilter> filters, String caption) {
        FormOpener.openBillListWithParam(form, entity, filters, caption, null);
    }

    public static void openBillListWithParam(AbstractFormPlugin form, String entity, List<QFilter> filters, String caption, Map<String, Object> params) {
        if (FormOpener.openTabIfExist(form, entity, filters)) {
            return;
        }
        ListShowParameter param = FormOpener.getListShowParameter(entity, filters, params);
        param.setCaption(caption);
        form.getView().showForm((FormShowParameter)param);
    }

    private static ListShowParameter getListShowParameter(String entity, List<QFilter> filters, Map<String, Object> params) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        param.setFormId(BOS_LIST);
        param.getListFilterParameter().setQFilters(filters);
        if (!CollectionUtils.isEmpty(params)) {
            param.setCustomParams(params);
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return param;
    }

    public static void openExistedBillList(AbstractFormPlugin form, String entity, List<QFilter> filters) {
        IFormView appView;
        Control control;
        IFormView view = form.getView();
        IFormView mainView = view.getMainView();
        if (mainView != null && !mainView.getPageId().equals(view.getPageId()) && (control = (appView = SessionManager.getCurrent().getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId())).getControl(CTRL_SUBMAINTAB)) instanceof Tab && FormOpener.isExistTabPage(entity, view, appView, (Tab)control)) {
            return;
        }
        ListShowParameter param = FormOpener.getListShowParameter(entity, filters, null);
        form.getView().showForm((FormShowParameter)param);
    }

    private static boolean isExistTabPage(String entity, IFormView view, IFormView appView, Tab control) {
        for (Object c : control.getItems()) {
            String billFormId;
            IFormView lv;
            TabPage tabPage = (TabPage)c;
            String tabPageKey = tabPage.getKey();
            if (APP_MIAN_TAB.equals(tabPageKey) || !((lv = appView.getViewNoPlugin(tabPageKey)) instanceof IListView) || !entity.equals(billFormId = ((ListShowParameter)lv.getFormShowParameter()).getBillFormId())) continue;
            control.activeTab(tabPageKey);
            lv.invokeOperation("refresh");
            view.sendFormAction(appView);
            return true;
        }
        return false;
    }

    private static boolean openTabIfExist(AbstractFormPlugin form, String entity, Map<String, Object> params) {
        try {
            IFormView appView;
            Control control;
            IFormView view = form.getView();
            IFormView mainView = view.getMainView();
            return mainView != null && !mainView.getPageId().equals(view.getPageId()) && (control = (appView = SessionManager.getCurrent().getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId())).getControl(CTRL_SUBMAINTAB)) instanceof Tab && FormOpener.existTabPage(entity, view, appView, (Tab)control, params);
        }
        catch (Exception e) {
            LOG.warn("\u5224\u65ad\u662f\u5426\u5b58\u5728\u65b0\u9875\u7b7e\u65f6\u5931\u8d25,\u539f\u56e0\u662f\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            return false;
        }
    }

    private static boolean existTabPage(String entity, IFormView view, IFormView appView, Tab control, Map<String, Object> params) {
        for (Object c : control.getItems()) {
            FormShowParameter formShowParameter;
            String formId;
            TabPage tabPage = (TabPage)c;
            String tabPageKey = tabPage.getKey();
            IFormView lv = appView.getViewNoPlugin(tabPageKey);
            if (lv == null || APP_MIAN_TAB.equals(tabPageKey) || !entity.equals(formId = (formShowParameter = lv.getFormShowParameter()) instanceof ListShowParameter ? ((ListShowParameter)formShowParameter).getBillFormId() : formShowParameter.getFormId())) continue;
            boolean flag = true;
            if (params != null && !params.isEmpty()) {
                Map customParams = formShowParameter.getCustomParams();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (Objects.equals(entry.getValue(), customParams.get(key))) continue;
                    flag = false;
                    break;
                }
            }
            if (!flag) continue;
            control.activeTab(tabPageKey);
            view.sendFormAction(appView);
            return true;
        }
        return false;
    }

    private static boolean openTabIfExist(AbstractFormPlugin form, String entity, List<QFilter> filters) {
        IFormView view = form.getView();
        IFormView mainView = view.getMainView();
        if (mainView != null && !mainView.getPageId().equals(view.getPageId())) {
            IFormView appView = SessionManager.getCurrent().getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId());
            if (appView == null) {
                return false;
            }
            Control control = appView.getControl(CTRL_SUBMAINTAB);
            return control instanceof Tab && FormOpener.existTabPage(entity, view, appView, (Tab)control, filters);
        }
        return false;
    }

    private static boolean existTabPage(String entity, IFormView view, IFormView appView, Tab control, List<QFilter> filters) {
        for (Object c : control.getItems()) {
            FormShowParameter formShowParameter;
            TabPage tabPage = (TabPage)c;
            String tabPageKey = tabPage.getKey();
            IFormView lv = appView.getViewNoPlugin(tabPageKey);
            if (lv == null || APP_MIAN_TAB.equals(tabPageKey) || !((formShowParameter = lv.getFormShowParameter()) instanceof ListShowParameter)) continue;
            ListShowParameter parameter = (ListShowParameter)formShowParameter;
            String formId = parameter.getBillFormId();
            if (filters == null || !entity.equals(formId)) continue;
            boolean flag = true;
            boolean flush = false;
            ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
            if (listFilterParameter == null) continue;
            List qFilters = listFilterParameter.getQFilters();
            if (filters.size() != qFilters.size()) continue;
            block1: for (int i = 0; i < qFilters.size(); ++i) {
                QFilter qFilter = (QFilter)qFilters.get(i);
                QFilter filter = filters.get(i);
                boolean property = qFilter.getProperty().equals(filter.getProperty());
                boolean cp = qFilter.getCP().equals(filter.getCP());
                if (property && cp) {
                    Object value = qFilter.getValue();
                    Object value1 = filter.getValue();
                    if (value instanceof List && value1 instanceof List) {
                        List val = (List)value;
                        List val1 = (List)value1;
                        for (int i1 = 0; i1 < val.size(); ++i1) {
                            if (val1.size() > 0 && val.get(i1).equals(val1.get(i1))) continue;
                            flag = false;
                            continue block1;
                        }
                        continue;
                    }
                    if (value instanceof Long && value1 instanceof Long) {
                        if (value.equals(value1)) continue;
                        flag = false;
                        break;
                    }
                    if (value instanceof String && value1 instanceof String) {
                        if (value.equals(value1)) continue;
                        flag = false;
                        break;
                    }
                    if (value instanceof Integer && value1 instanceof Integer) {
                        if (value.equals(value1)) continue;
                        flag = false;
                        break;
                    }
                    flag = false;
                    break;
                }
                flag = false;
                break;
            }
            if (!flag) continue;
            control.activeTab(tabPageKey);
            if (flush) {
                lv.invokeOperation("refresh");
            }
            view.sendFormAction(appView);
            return true;
        }
        return false;
    }

    public static void openBillListByModel(AbstractFormPlugin form, String entity, String field, AfterDoOperationEventArgs e) {
        Object id = FormOpener.getSelectedId(form, e);
        if (id != null) {
            QFilter filter = new QFilter(field, "=", id);
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId(entity);
            param.setFormId(BOS_LIST);
            param.getListFilterParameter().setQFilters(Collections.singletonList(filter));
            param.getOpenStyle().setShowType(ShowType.Modal);
            form.getView().showForm((FormShowParameter)param);
        }
    }

    public static void openBillList(AbstractFormPlugin form, String entity, String formId, String caption, List<QFilter> filters) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        param.setFormId(formId);
        if (caption != null) {
            param.setCaption(caption);
        }
        param.getListFilterParameter().getQFilters().addAll(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showView(AbstractFormPlugin form, String entity, Object id) {
        FormOpener.showView(form, entity, id, false);
    }

    public static void showView(AbstractFormPlugin form, String entity, Object id, Map<String, Object> params) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entity);
        param.setPkId(id);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setStatus(OperationStatus.VIEW);
        param.setCustomParams(params);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showView(AbstractFormPlugin form, String entity, Object id, boolean disable_view_trace) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entity);
        param.setPkId(id);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setStatus(OperationStatus.VIEW);
        param.setCustomParam("disable_view_trace", (Object)disable_view_trace);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showTabView(AbstractFormPlugin form, String entity, Object id) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entity);
        param.setPkId(id);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.VIEW);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showTabViewWithParams(AbstractFormPlugin form, String entity, Object id, Map<String, Object> params) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entity);
        param.setPkId(id);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.VIEW);
        param.setCustomParams(params);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showTabView(AbstractFormPlugin form, String entity, HyperLinkClickArgs args) {
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        FormOpener.showTabView(form, entity, selectedId);
    }

    public static void showAddNew(AbstractFormPlugin form, String entity, Map<String, Object> params) {
        BillShowParameter p = new BillShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.getOpenStyle().setShowType(ShowType.Modal);
        p.setStatus(OperationStatus.ADDNEW);
        form.getView().showForm((FormShowParameter)p);
    }

    public static void showAddNew(AbstractFormPlugin form, String entity, Map<String, Object> params, String callback) {
        BillShowParameter p = new BillShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.getOpenStyle().setShowType(ShowType.Modal);
        if (callback != null) {
            p.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        }
        p.setStatus(OperationStatus.ADDNEW);
        form.getView().showForm((FormShowParameter)p);
    }

    public static void openImportForm(IFormPlugin form, IFormView view, String entityName) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("isc_dts_imp");
        showParameter.setCustomParam("entity", (Object)entityName);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack(form, "importschema"));
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u5bfc\u5165 - %s", (String)"FormOpener_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), FileResourceUtil.getEntityTitle((String)entityName)));
        view.showForm((FormShowParameter)showParameter);
    }

    public static void openOldImportForm(IFormPlugin form, IFormView view, String entityName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("isc_schema_upload");
        showParameter.setCustomParam("entityName", (Object)entityName);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack(form, "importschema"));
        view.showForm(showParameter);
    }

    public static void showForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback, boolean showClose) {
        FormShowParameter p = FormOpener.getFormShowParameter(form, entity, caption, params, callback);
        p.setShowClose(showClose);
        p.getOpenStyle().setShowType(ShowType.Modal);
        form.getView().showForm(p);
    }

    public static void showFloatForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormShowParameter p = FormOpener.getFormShowParameter(form, entity, caption, params, callback);
        p.setShowClose(false);
        p.getOpenStyle().setShowType(ShowType.Floating);
        form.getView().showForm(p);
    }

    public static void showForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormOpener.showForm(form, entity, caption, params, callback, true);
    }

    public static void showForm(AbstractFormPlugin form, String entity, Map<String, Object> params) {
        FormShowParameter p = new FormShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.getOpenStyle().setShowType(ShowType.Modal);
        form.getView().showForm(p);
    }

    public static void showStatusForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, OperationStatus status, ShowType showType) {
        FormShowParameter p = new FormShowParameter();
        p.setFormId(entity);
        p.setCaption(caption);
        p.setCustomParams(params);
        p.setStatus(status);
        p.getOpenStyle().setShowType(showType);
        form.getView().showForm(p);
    }

    @Deprecated
    public static void showStatusBill(AbstractFormPlugin form, String entity, Object id, Map<String, Object> params, OperationStatus status, ShowType showType) {
        BillShowParameter p = new BillShowParameter();
        p.setFormId(entity);
        p.setPkId(id);
        p.setCustomParams(params);
        p.setStatus(status);
        p.getOpenStyle().setShowType(showType);
        form.getView().showForm((FormShowParameter)p);
    }

    public static void showDiffComp(AbstractFormPlugin form, String entity, Map<String, Object> versionA, String titleA, Map<String, Object> versionB, String titleB) {
        versionA.put("$version", titleA);
        versionB.put("$version", titleB);
        FormOpener.showDiffComp(form, entity, versionA, versionB);
    }

    public static void showDiffComp(AbstractFormPlugin form, String entity, Map<String, Object> versionA, Map<String, Object> versionB) {
        FormOpener.prehandleTimestamp(versionA);
        FormOpener.prehandleTimestamp(versionB);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("A", versionA);
        params.put("B", versionB);
        params.put("entity", entity);
        FormOpener.handleServiceFlowDiagram(versionA);
        FormOpener.handleServiceFlowDiagram(versionB);
        FormShowParameter p = new FormShowParameter();
        p.setFormId("isc_diff_comp");
        p.setCaption(String.format(ResManager.loadKDString((String)"\u5dee\u5f02\u6bd4\u8f83 - %s", (String)"FormOpener_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), FileResourceUtil.getEntityTitle((String)entity)));
        p.setCustomParams(params);
        p.getOpenStyle().setShowType(ShowType.Modal);
        form.getView().showForm(p);
    }

    private static void prehandleTimestamp(Map<String, Object> map) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Object value = e.getValue();
            if (value instanceof Timestamp) {
                e.setValue(sdf.format(value));
                continue;
            }
            if (!(value instanceof Collection)) continue;
            FormOpener.prehandleTimestamp((Collection)value);
        }
    }

    private static void prehandleTimestamp(Collection<?> list) {
        for (Object o : list) {
            if (!(o instanceof Map)) continue;
            FormOpener.prehandleTimestamp((Map)o);
        }
    }

    private static void handleServiceFlowDiagram(Map<String, Object> data) {
        String s = D.s((Object)data.get("define_json_tag"));
        if (s != null) {
            data.put("define_json_tag", Json.toObject((String)s));
        }
    }

    public static void showTabForm(AbstractFormPlugin form, String entity, Object id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pk_id", id);
        if (FormOpener.openTabIfExist(form, entity, params)) {
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId(entity);
        param.setCustomParam("pk_id", id);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.VIEW);
        form.getView().showForm(param);
    }

    public static void showTabForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        if (FormOpener.openTabIfExist(form, entity, params)) {
            return;
        }
        FormShowParameter p = FormOpener.getFormShowParameter(form, entity, caption, params, callback);
        p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm(p);
    }

    public static void showNewWindow(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormShowParameter p = FormOpener.getFormShowParameter(form, entity, caption, params, callback);
        p.getOpenStyle().setShowType(ShowType.NewWindow);
        form.getView().showForm(p);
    }

    private static FormShowParameter getFormShowParameter(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormShowParameter p = new FormShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.setCaption(caption);
        if (callback != null) {
            p.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        }
        return p;
    }

    public static void showTabBill(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        BillShowParameter p = FormOpener.setBillShowParameter(form, entity, caption, params, callback);
        p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm((FormShowParameter)p);
    }

    public static void addNewByParent(AbstractFormPlugin form, String entity, Map<String, Object> params, IFormView parentView) {
        BillShowParameter p = new BillShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        p.setStatus(OperationStatus.ADDNEW);
        parentView.showForm((FormShowParameter)p);
        form.getView().sendFormAction(parentView);
        form.getView().close();
    }

    public static void showModalBill(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        BillShowParameter p = FormOpener.setBillShowParameter(form, entity, caption, params, callback);
        p.getOpenStyle().setShowType(ShowType.Modal);
        form.getView().showForm((FormShowParameter)p);
    }

    public static void showModalForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormShowParameter p = FormOpener.getFormShowParameter(form, entity, caption, params, callback);
        p.getOpenStyle().setShowType(ShowType.Modal);
        form.getView().showForm(p);
    }

    public static BillShowParameter setBillShowParameter(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        BillShowParameter p = new BillShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.setCaption(caption);
        if (callback != null) {
            p.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        }
        p.setStatus(OperationStatus.EDIT);
        return p;
    }

    public static void showTreeForm(AbstractFormPlugin form, String formId, String billFormId, List<QFilter> filters) {
        ListShowParameter param = new ListShowParameter();
        param.setFormId(formId);
        param.setBillFormId(billFormId);
        param.getListFilterParameter().setQFilters(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showTabViewIfNotExist(AbstractFormPlugin form, String entity, Object id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("isc_service_flow".equals(entity) || "isc_data_copy_trigger".equals(entity) || "isc_data_copy".equals(entity) || "isc_solution_center".equals(entity) || "dbc_table_copy_log".equals(entity)) {
            map.put("MUTEX_OBJ_ID", String.valueOf(id));
        }
        if (FormOpener.openTabIfExist(form, entity, map)) {
            return;
        }
        FormOpener.innerEdit(form, entity, id, ShowType.MainNewTabPage, OperationStatus.VIEW);
    }

    public static void showMainEditIfNotExist(AbstractFormPlugin form, String entity, Object id) {
        if (FormOpener.openTabIfExist(form, entity, new HashMap<String, Object>())) {
            return;
        }
        FormOpener.innerEdit(form, entity, id, ShowType.MainNewTabPage, OperationStatus.EDIT);
    }

    public static void showEdit(AbstractFormPlugin form, String entity, Object id) {
        FormOpener.innerEdit(form, entity, id, ShowType.Modal, OperationStatus.EDIT);
    }

    public static void showTabEdit(AbstractFormPlugin form, String entity, Object id) {
        if ("isc_service_flow".equals(entity)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("MUTEX_OBJ_ID", String.valueOf(id));
            if (FormOpener.openTabIfExist(form, entity, map)) {
                return;
            }
        }
        FormOpener.innerEdit(form, entity, id, ShowType.MainNewTabPage, OperationStatus.EDIT);
    }

    private static void innerEdit(AbstractFormPlugin form, String entity, Object id, ShowType type, OperationStatus operationStatus) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entity);
        param.setPkId(id);
        param.getOpenStyle().setShowType(type);
        param.setCustomParam("MUTEX_OBJ_ID", (Object)String.valueOf(id));
        param.setStatus(operationStatus);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showErrorMessage(IFormView view, Throwable e) {
        String details = ShowStackTraceUtil.getErrorMsg(e);
        FormOpener.showErrorMessage(view, StringUtil.getCascadeMessage((Throwable)e), details);
    }

    public static void showErrorMessage(IFormView view, String title, String detail) {
        FormShowParameter p = new FormShowParameter();
        p.setFormId("isc_biz_message");
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("message", StringUtil.trim((String)title, (int)50));
        if (ShowStackTraceUtil.isShowStackTrace()) {
            params.put("detail", detail);
        } else if (FormOpener.isStackTrace(detail)) {
            int i = detail.indexOf(10);
            String shortDetail = i <= 0 ? title : detail.substring(0, i);
            params.put("detail", shortDetail + "\r\n\r\n" + ResManager.loadKDString((String)"\u975e\u5e38\u62b1\u6b49\uff0c\u5f53\u524d\u73af\u5883\u5df2\u88ab\u7ba1\u7406\u5458\u7981\u6b62\u67e5\u770b\u9519\u8bef\u5806\u6808\u4fe1\u606f\u3002", (String)"FormOpener_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            params.put("detail", detail);
        }
        p.setCustomParams(params);
        p.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(p);
    }

    public static boolean isStackTrace(String detail) {
        if (detail == null) {
            return false;
        }
        return detail.contains("\tat kd.isc.") || detail.contains("\tat kd.bos.") || detail.contains("\tat java.lang.");
    }

    public static void showInfo(IFormView view, String info, String caption) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("content", info);
        FormShowParameter p = new FormShowParameter();
        p.setFormId("isc_text_content_dialog");
        p.setCustomParams(params);
        p.setCaption(caption);
        p.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(p);
    }

    public static void showMessage(AbstractFormPlugin form, String title, String details) {
        form.getView().showMessage(title, details, MessageTypes.Default);
    }

    public static void showListForSelected(AbstractFormPlugin form, String entity, String caption, Object[] pks, Map<String, Object> params, String callback) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)entity, (boolean)false, (int)0);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        parameter.setSelectedRows(pks);
        parameter.setCaption(caption);
        parameter.setCustomParams(params);
        form.getView().showForm((FormShowParameter)parameter);
    }

    public static void showTreeFormAddAppId(AbstractFormPlugin form, String formId, String billFormId, String caption, List<QFilter> filters) {
        if (FormOpener.openTabIfExist(form, billFormId, filters)) {
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId(formId);
        param.setBillFormId(billFormId);
        param.getListFilterParameter().setQFilters(filters);
        param.setAppId("iscb");
        param.setCaption(caption);
        param.setCustomParam("appid", (Object)"iscb");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void openBillListAddAppId(AbstractFormPlugin form, String entity, String caption, List<QFilter> filters) {
        if (FormOpener.openTabIfExist(form, entity, filters)) {
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        param.setFormId(BOS_LIST);
        param.setAppId("iscb");
        param.setCaption(caption);
        param.setCustomParam("appid", (Object)"iscb");
        param.getListFilterParameter().setQFilters(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void openBillAddAppId(AbstractFormPlugin form, String entity, String caption, Object pk, ShowType type) {
        BaseShowParameter param = new BaseShowParameter();
        param.setBillStatus(BillOperationStatus.VIEW);
        param.setFormId(entity);
        param.setPkId(pk);
        param.setAppId("iscb");
        param.setCaption(caption);
        param.setCustomParam("appid", (Object)"iscb");
        param.getOpenStyle().setShowType(type);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showDatabaseLinkForm(AbstractFormPlugin form, Object id) {
        BillShowParameter param = new BillShowParameter();
        DynamicObject ds = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_database_link", (String)"database_type");
        param.setFormId(DatabaseType.getForm((String)ds.getString("database_type")));
        param.setPkId(id);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setStatus(OperationStatus.VIEW);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showFlowDiagramEditor(AbstractFormPlugin form, long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flow", id);
        params.put("ENTITY", "isc_service_flow");
        params.put("editable", Boolean.TRUE);
        FormOpener.showTabForm(form, "isc_service_flow_editor", ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe", (String)"FormOpener_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    public static void showF7(AbstractFormPlugin form, String entity, String callback, boolean multiSelect) {
        FormOpener.showF7(form, entity, null, callback, multiSelect);
    }

    public static void showF7(AbstractFormPlugin form, String entity, String callback, boolean multiSelect, boolean isTreeList) {
        FormOpener.showF7(form, entity, null, callback, multiSelect, isTreeList, false);
    }

    public static void showF7(AbstractFormPlugin form, String entity, QFilter[] filters, String callback, boolean multiSelect) {
        FormOpener.showF7(form, entity, filters, callback, multiSelect, false, false);
    }

    public static void showF7(AbstractFormPlugin form, String entity, QFilter[] filters, String callback, boolean multiSelect, boolean isTreeList, boolean isHasRight) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        if (isTreeList) {
            param.setFormId("bos_templatetreelistf7");
        } else {
            param.setFormId("bos_listf7");
        }
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        param.getOpenStyle().setInlineStyleCss(css);
        param.setLookUp(true);
        param.setShowTitle(false);
        param.setHasRight(isHasRight);
        param.setMultiSelect(multiSelect);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        if (filters != null && filters.length > 0) {
            param.getListFilterParameter().setQFilters(Arrays.asList(filters));
        }
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showSpecificSizeView(AbstractFormPlugin form, String entity, Object id, String width, String height) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entity);
        param.setPkId(id);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setStatus(OperationStatus.VIEW);
        param.setCustomParam("disable_view_trace", (Object)Boolean.FALSE);
        FormConfig fc = FormMetadataCache.getFormConfig((String)entity);
        fc.setWidth(new LocaleString(width));
        fc.setHeight(new LocaleString(height));
        param.setFormConfig(fc);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void showAppIdTabForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params) {
        FormOpener.showAppIdTabFormWithAppId(form, entity, caption, params, null);
    }

    public static void showAppIdTabFormWithAppId(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String appId) {
        if (FormOpener.openTabIfExist(form, entity, params)) {
            return;
        }
        FormShowParameter p = new FormShowParameter();
        p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        p.setFormId(entity);
        p.setCustomParams(params);
        p.setCaption(caption);
        if (appId != null) {
            p.setAppId(appId);
        }
        form.getView().showForm(p);
    }

    public static void showStackTraceForm(AbstractFormPlugin form, long id) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            LOG.warn(e.getMessage());
        }
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject dataEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_job_inst", (String)"remark_tag", (QFilter[])new QFilter[]{filter});
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (D.s((Object)dataEntity.getString("remark_tag")) == null) {
            params.put("content", ResManager.loadKDString((String)"\u5f53\u524d\u5806\u6808\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u5173\u95ed\u5f39\u7a97\u540e\u91cd\u65b0\u70b9\u51fb\u201c\u5f53\u524d\u8c03\u7528\u5806\u6808\u201d\u6309\u94ae\u5c1d\u8bd5\u83b7\u53d6\u5bf9\u5e94\u7684\u5806\u6808\u4fe1\u606f\u3002", (String)"FormOpener_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            params.put("content", dataEntity.getString("remark_tag"));
        }
        FormOpener.showForm(form, "isc_text_content_dialog", ResManager.loadKDString((String)"\u5806\u6808\u4fe1\u606f", (String)"FormOpener_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    public static void buildOpenFormParam(IFormView view, Map<String, Object> params, String ... paramKeys) {
        for (String s : paramKeys) {
            if (view.getFormShowParameter().getCustomParam(s) == null) continue;
            params.put(s, view.getFormShowParameter().getCustomParam(s));
        }
    }
}

