/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.util;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.constant.MessageType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class MsgUtil {
    private static final String NUM_SOURCES_STR = "0123456789";
    private static final String PREFIX = "PC-ISC-MSG-";
    private static final String REG = "\\s*|\t|\r|\n";
    private static final SecureRandom rd = new SecureRandom();

    private MsgUtil() {
    }

    public static String getMsgNumber() {
        StringBuilder sb = new StringBuilder(PREFIX);
        for (int i = 0; i < 21; ++i) {
            int num = rd.nextInt(9);
            sb.append(NUM_SOURCES_STR.charAt(num));
        }
        return sb.toString();
    }

    public static String getMsgNumber(String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        for (int i = 0; i < 21; ++i) {
            int num = rd.nextInt(9);
            sb.append(NUM_SOURCES_STR.charAt(num));
        }
        return sb.toString();
    }

    public static void setContent(IDataModel model, EntryGrid entryGrid, String key, Object returnData) {
        int index = entryGrid.getEntryState().getFocusRow();
        StringBuilder result = new StringBuilder();
        if (index > -1) {
            if (returnData instanceof String) {
                result.append(returnData);
            }
            model.setValue(key, (Object)result, index);
            model.updateCache();
        }
    }

    public static String replaceSymbol(String str) {
        String result = "";
        if (str != null) {
            Pattern p = Pattern.compile(REG);
            Matcher m = p.matcher(str);
            result = m.replaceAll("");
        }
        return result;
    }

    public static FormShowParameter getFormParam(String entityid, boolean isShowTitle, ShowType value, String key, Object content, CloseCallBack closeCallBack) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(entityid);
        fsp.setShowTitle(isShowTitle);
        fsp.getOpenStyle().setShowType(value);
        fsp.setCustomParam(key, content);
        fsp.setCloseCallBack(closeCallBack);
        return fsp;
    }

    public static void setEntryFromClosedCallBack(ListSelectedRowCollection lsrc, String formId, String colId, IDataModel modal) {
        if (lsrc == null || lsrc.isEmpty()) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        ArrayList<Long> selectedIds = new ArrayList<Long>();
        for (ListSelectedRow row : lsrc) {
            selectedIds.add((Long)row.getPrimaryKeyValue());
        }
        DynamicObject[] dos = BusinessDataServiceHelper.load((Object[])selectedIds.toArray(), (DynamicObjectType)type);
        if (dos == null || dos.length == 0) {
            return;
        }
        StringBuilder userName = new StringBuilder();
        for (int i = 0; i < dos.length; ++i) {
            if (i == dos.length - 1) {
                userName.append(dos[i].getString("name")).append('(').append(dos[i].getString("id")).append(')');
                continue;
            }
            userName.append(dos[i].getString("name")).append('(').append(dos[i].getString("id")).append("),");
        }
        if (StringUtils.isNotEmpty((String)userName.toString())) {
            modal.setValue(colId, (Object)userName);
        }
    }

    public static void setNoticeVar(Object returnData, IDataModel model) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            String key = D.s(data.get("key"));
            String value = D.s(data.get("full_number"));
            model.setValue(key, (Object)value);
        } else if (returnData instanceof List) {
            List list = (List)returnData;
            StringBuilder sb = new StringBuilder(list.size());
            String key = null;
            for (Object obj : list) {
                Map data = (Map)obj;
                key = D.s(data.get("key"));
                String value = D.s(data.get("full_number"));
                sb.append(value).append(';');
            }
            if (!StringUtil.isEmpty(key)) {
                model.setValue(key, (Object)sb.toString());
            }
        }
    }

    public static void setNoticeMethod(String targetSystem, IFormView view) {
        ComboEdit combo = (ComboEdit)view.getControl("notice_method");
        try {
            MessageType messageType = MessageType.valueOf((String)targetSystem.toUpperCase());
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(messageType.getTypes().size());
            for (Map.Entry e : messageType.getTypes().entrySet()) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(((MultiLangEnumBridge)e.getValue()).loadKDString()));
                item.setValue((String)e.getKey());
                items.add(item);
            }
            combo.setComboItems(items);
        }
        catch (Exception e) {
            combo.setComboItems(Collections.emptyList());
        }
    }
}

