/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk;

import com.kingdee.bos.webapi.entity.IdentifyInfo;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudMLStringSetter;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;

public class K3WebApiCache {
    private static final Log log = LogFactory.getLog(K3WebApiCache.class);
    private static final Map<Pair<String, Long>, IdentifyInfo> cache = new ReadLockFreeMap();

    public static IdentifyInfo getIdentifyInfo(DynamicObject cfg) {
        Long connectionId;
        String accountId = RequestContext.get().getAccountId();
        Pair key = new Pair((Object)accountId, (Object)(connectionId = Long.valueOf(D.l((Object)cfg.get("id")))));
        IdentifyInfo identify = cache.get(key);
        if (identify == null) {
            identify = new IdentifyInfo();
            String http = cfg.getString("http_protocal");
            String ip = D.s((Object)cfg.getString("server_ip"));
            String port = cfg.getString("server_port");
            String webApp = cfg.getString("web_app");
            if (ip != null) {
                identify.setServerUrl(http + "://" + ip + ":" + port + webApp);
            }
            identify.setUserName(cfg.getString("user"));
            identify.setAppId(cfg.getString("appid"));
            identify.setAppSecret(cfg.getString("appsecret_new"));
            identify.setdCID(cfg.getString("account"));
            identify.setlCID(K3CloudMLStringSetter.getMLkay((Object)cfg.get("icid")).intValue());
            identify.setOrgNum(null);
            cache.put((Pair<String, Long>)key, identify);
        }
        return identify;
    }

    public static void remove(DynamicObject cfg) {
        String accountId = RequestContext.get().getAccountId();
        Long connectionId = D.l((Object)cfg.get("id"));
        Pair key = new Pair((Object)accountId, (Object)connectionId);
        cache.remove(key);
    }
}

