/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.CheckResult;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyObjectReader;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiAction;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;

public class QueryCloudData {
    private static final String KEY_VALUE = "Value";
    private static final String KEY_RESULT = "Result";
    public static final char SINGLE_QUOTE = '\'';
    private static final Set<String> NO_QUOTATION_TYPE = new HashSet<String>(Arrays.asList("datetime", "date", "long", "integer", "decimal"));

    public static ObjectReader<Map<String, Object>> get(K3SkyWebApiContext ctx, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        List<Object> ids = QueryCloudData.getBillCode(ctx, filter, orderBy, entity);
        return new K3SkyObjectReader(ctx, requires, ids, entity);
    }

    public static DynamicObjectCollection getEntityMeta(K3SkyWebApiContext ctx, String entityName) {
        if (null == entityName || entityName.isEmpty()) {
            return new DynamicObjectCollection();
        }
        List<DynamicObject> dataSource = QueryCloudData.getDataSource(ctx);
        ArrayList<Long> dataSourceIds = new ArrayList<Long>(dataSource.size());
        for (DynamicObject source : dataSource) {
            dataSourceIds.add(source.getLong("id"));
        }
        DynamicObject dynamicObject = MetaDataSchema.getOne(dataSourceIds, (String)entityName, (String[])new String[]{"ENTITY"});
        if (dynamicObject == null) {
            String dataSourceName = QueryCloudData.getAllDataSourceName(dataSource);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728\u4ee5\u4e0b\u6570\u636e\u6e90\uff08%1$s\uff09\u627e\u4e0d\u5230\u5168\u540d\u4e3a\uff08%2$s\uff09\u7684\u96c6\u6210\u5bf9\u8c61\uff0c\u8bf7\u53bb\u96c6\u6210\u5bf9\u8c61\u5217\u8868\u65b0\u5efa\u5e76\u540c\u6b65\u8be5\u96c6\u6210\u5bf9\u8c61\u3002\uff08\u82e5\u8fd9\u91cc\u63d0\u793a\u7684\u6570\u636e\u6e90\u6709\u591a\u4e2a\uff0c\u53ea\u9700\u8981\u5728\u4efb\u610f\u4e00\u4e2a\u6570\u636e\u6e90\u4e0b\u65b0\u589e\u5e76\u540c\u6b65\uff09", (String)"QueryCloudData_0", (String)"isc-iscb-connector-other", (Object[])new Object[0]), dataSourceName, entityName));
        }
        return dynamicObject.getDynamicObjectCollection("prop_entryentity");
    }

    private static String getAllDataSourceName(List<DynamicObject> dataSource) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < dataSource.size(); ++i) {
            DynamicObject object = dataSource.get(i);
            if (i == dataSource.size() - 1) {
                name.append(object.getString("name"));
                continue;
            }
            name.append(object.getString("name")).append('\uff0c');
        }
        return name.toString();
    }

    private static List<DynamicObject> getDataSource(K3SkyWebApiContext ctx) {
        DynamicObject link = ctx.getConfig();
        List dataSources = DataSource.getAllByDbLink((long)link.getLong("id"));
        if (dataSources.isEmpty()) {
            String number = link.getString("number");
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801\u4e3a\uff08%s\uff09\u7684\u8fde\u63a5\u914d\u7f6e\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u6570\u636e\u6e90\u3002", (String)"QueryCloudData_1", (String)"isc-iscb-connector-other", (Object[])new Object[0]), number));
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(dataSources.size());
        for (DataSource dataSource : dataSources) {
            dynamicObjects.add(dataSource.getConfig());
        }
        return dynamicObjects;
    }

    public static DynamicObjectCollection getEntryMeta(K3SkyWebApiContext ctx, Object dataSchema) {
        List<DynamicObject> dataSource = QueryCloudData.getDataSource(ctx);
        ArrayList<Long> dataSourceIds = new ArrayList<Long>(dataSource.size());
        for (DynamicObject source : dataSource) {
            dataSourceIds.add(source.getLong("id"));
        }
        DynamicObject dynamicObject = MetaDataSchema.getOneByNumber(dataSourceIds, (String)D.s((Object)dataSchema), (String[])new String[]{"ENTITY"});
        if (dynamicObject == null) {
            String dataSourceName = QueryCloudData.getAllDataSourceName(dataSource);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5173\u8054\u6570\u636e\u6e90\uff08%1$s\uff09\u4e14\u7f16\u7801\u4e3a\uff08%2$s\uff09\u7684\u96c6\u6210\u5bf9\u8c61\uff1b", (String)"QueryCloudData_2", (String)"isc-iscb-connector-other", (Object[])new Object[0]), dataSourceName, dataSchema) + "\r\n" + String.format(ResManager.loadKDString((String)"\u95ee\u9898\u6392\u67e5\u6b65\u9aa4\uff1a", (String)"QueryCloudData_3", (String)"isc-iscb-connector-other", (Object[])new Object[0]) + "\r\n" + String.format(ResManager.loadKDString((String)"1\u3001\u8bf7\u7528\u7f16\u7801\uff08%s)\u5230\u96c6\u6210\u5bf9\u8c61\u5217\u8868\u4e2d\u67e5\u627e\u96c6\u6210\u5bf9\u8c61\uff0c\u5b58\u5728\u5219\u6253\u5f00\u96c6\u6210\u5bf9\u8c61\u70b9\u51fb\u6309\u94ae\u3010\u4fee\u6539\u3011->\u3010\u4fdd\u5b58\u3011\uff1b", (String)"QueryCloudData_4", (String)"isc-iscb-connector-other", (Object[])new Object[0]), dataSchema) + "\r\n" + String.format(ResManager.loadKDString((String)"2\u3001\u5982\u679c\u7b2c1\u6b65\u6ca1\u6709\u627e\u5230\u96c6\u6210\u5bf9\u8c61\uff0c\u8bf7\u627e\u5230\u62a5\u9519\u7684\u3010\u96c6\u6210\u65b9\u6848\u3011\u6253\u5f00\u3010\u6e90\u5bf9\u8c61\u3011\u6216\u8005\u3010\u76ee\u6807\u5bf9\u8c61\u3011\u70b9\u51fb\u6309\u94ae\u3010\u4fee\u6539\u3011->\u3010\u540c\u6b65\u3011->\u3010\u4fdd\u5b58\u3011\uff1b", (String)"QueryCloudData_5", (String)"isc-iscb-connector-other", (Object[])new Object[0]), new Object[0]), "\r\n" + String.format(ResManager.loadKDString((String)"3\u3001\u5982\u679c\u7b2c2\u6b65\u6ca1\u6709\u627e\u5230\u96c6\u6210\u5bf9\u8c61\uff0c\u8bf7\u5230\u3010\u96c6\u6210\u5143\u6570\u636e\u3011->\u3010\u96c6\u6210\u5bf9\u8c61\u3011\u9009\u62e9\u4f60\u81ea\u5df1\u521b\u5efa\u7684\u661f\u7a7a\u6570\u636e\u6e90\u70b9\u51fb\u3010\u6279\u91cf\u540c\u6b65\u5143\u6570\u636e\u3011\u6309\u94ae\uff1b", (String)"QueryCloudData_6", (String)"isc-iscb-connector-other", (Object[])new Object[0]), new Object[0])));
        }
        return dynamicObject.getDynamicObjectCollection("prop_entryentity");
    }

    public static Map<String, Object> getSrcData(K3SkyWebApiContext ctx, Map<String, Object> billInfo, DynamicObjectCollection metaData, Map<String, Object> requires) {
        if (null == billInfo || null == metaData) {
            return new HashMap<String, Object>(1);
        }
        Object result = billInfo.get(KEY_RESULT);
        if (!ObjectUtils.isEmpty((Object)result)) {
            billInfo = (Map)((Map)result).get(KEY_RESULT);
        }
        LinkedHashMap<String, Object> srcData = new LinkedHashMap<String, Object>(16);
        for (DynamicObject field : metaData) {
            String prop_name = field.getString("prop_name");
            Object requiresValue = requires.get(prop_name);
            if (null == requiresValue) continue;
            String fieldRemark = D.s((Object)field.getString("prop_remark"));
            if (fieldRemark == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u661f\u7a7a\u5b9e\u4f53\u5bf9\u8c61\u4e2d\u5c5e\u6027\u7f16\u7801\u4e3a\uff1a[%s]\u7684\u5b57\u6bb5,\u5c5e\u6027\u5907\u6ce8\u4e3a\u7a7a\u3002\u95ee\u9898\u6392\u67e5\u601d\u8def\uff1a", (String)"QueryCloudData_7", (String)"isc-iscb-connector-other", (Object[])new Object[0]), prop_name) + "\n" + String.format(ResManager.loadKDString((String)"1\u3001\u8bf7\u786e\u8ba4\u8be5\u5b57\u6bb5\u662f\u5426\u662f\u81ea\u5df1\u6dfb\u52a0\u7684\u5b57\u6bb5\uff0c\u5219\u9700\u8981\u624b\u52a8\u7ef4\u62a4\u5907\u6ce8\u5c5e\u6027\u3002", (String)"QueryCloudData_8", (String)"isc-iscb-connector-other", (Object[])new Object[0]) + "\n" + String.format(ResManager.loadKDString((String)"2\u3001\u8bf7\u91cd\u65b0\u540c\u6b65\u8be5\u96c6\u6210\u5bf9\u8c61\uff0c\u786e\u8ba4\u5c5e\u6027\u7f16\u7801[%s]\u7684\u5907\u6ce8\u5c5e\u6027\u662f\u5426\u6709\u503c\u3002", (String)"QueryCloudData_9", (String)"isc-iscb-connector-other", (Object[])new Object[0]), prop_name) + "\n" + String.format(ResManager.loadKDString((String)"3\u3001\u8bf7\u786e\u8ba4\u662f\u5426\u5b58\u5728\u591a\u4e2a\u661f\u7a7a\u6570\u636e\u6e90\u6709\u76f8\u540c\u7f16\u7801\u7684\u96c6\u6210\u5bf9\u8c61\uff0c\u5219\u90fd\u9700\u8981\u7ef4\u62a4\u8be5\u5b57\u6bb5\u5c5e\u6027\u3002", (String)"QueryCloudData_10", (String)"isc-iscb-connector-other", (Object[])new Object[0]) + "\n" + String.format(ResManager.loadKDString((String)"4\u3001\u8bf7\u786e\u5b9a\u661f\u7a7aWEBAPI\u5143\u6570\u636e\u67e5\u8be2\u63a5\u53e3\u83b7\u53d6\u7684\u5143\u6570\u636e\u4fe1\u606f\u4e2d\u8be5\u5b57\u6bb5\u5c5e\u6027\u7684PropertyName\u662f\u5426\u6709\u503c\uff0c\u6709\u503c\u8bf7\u4e0e\u96c6\u6210\u5f00\u53d1\u540c\u4e8b\u8054\u7cfb\u786e\u8ba4\uff0c\u6ca1\u6709\u503c\u5219\u9700\u8981\u661f\u7a7a\u5f00\u53d1\u540c\u4e8b\u786e\u8ba4\u3002", (String)"QueryCloudData_11", (String)"isc-iscb-connector-other", (Object[])new Object[0]), new Object[0]), new Object[0]), new Object[0]));
            }
            String fieldType = field.getString("data_type");
            String fieldSchema = field.getString("data_schema");
            Object billValue = billInfo.get(fieldRemark);
            srcData.put(D.s((Object)prop_name), QueryCloudData.format(ctx, billValue, requiresValue, fieldType, fieldSchema));
        }
        DynamicObject dynamicObject = (DynamicObject)metaData.get(0);
        Object pkId = dynamicObject.get("prop_remark");
        srcData.put("$id", billInfo.get(pkId));
        srcData.put("$pk", dynamicObject.get("prop_name"));
        return srcData;
    }

    public static Object format(K3SkyWebApiContext ctx, Object billValue, Object requiresValue, Object fieldType, Object fieldSchema) {
        if (ObjectUtils.isEmpty((Object)billValue)) {
            return billValue;
        }
        if ("ml_string_k3c".equals(fieldType)) {
            return QueryCloudData.formatMultiLang(billValue, requiresValue);
        }
        if ("ENTRIES".equals(fieldType) || "SubHeadEntity".equals(fieldType)) {
            return QueryCloudData.formatEntityAndSubHeadEntity(ctx, billValue, requiresValue, fieldSchema);
        }
        if ("REF".equals(fieldType)) {
            return QueryCloudData.getREF(ctx, billValue, requiresValue, fieldSchema);
        }
        return QueryCloudData.formatOtherType(ctx, billValue, requiresValue, fieldSchema);
    }

    private static Object formatOtherType(K3SkyWebApiContext ctx, Object billValue, Object requiresValue, Object fieldSchema) {
        if (billValue instanceof Map) {
            return QueryCloudData.getREF(ctx, billValue, requiresValue, fieldSchema);
        }
        return billValue;
    }

    private static Object formatEntityAndSubHeadEntity(K3SkyWebApiContext ctx, Object billValue, Object requiresValue, Object fieldSchema) {
        if (requiresValue instanceof Map) {
            return QueryCloudData.format(ctx, billValue, requiresValue, fieldSchema);
        }
        return QueryCloudData.getIdFromBill(billValue);
    }

    private static Object getREF(K3SkyWebApiContext ctx, Object billValue, Object requiresValue, Object fieldSchema) {
        if (requiresValue instanceof Map) {
            return QueryCloudData.formatREF(ctx, billValue, requiresValue, fieldSchema);
        }
        return QueryCloudData.getIdFromBill(billValue);
    }

    private static Object formatREF(K3SkyWebApiContext ctx, Object billValue, Object requiresValue, Object fieldSchema) {
        if (billValue instanceof Map) {
            return QueryCloudData.getSrcData(ctx, (Map)billValue, QueryCloudData.getEntryMeta(ctx, fieldSchema), (Map)requiresValue);
        }
        if (billValue instanceof List) {
            throw new IscBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6682\u4e0d\u652f\u6301\u4e00\u5bf9\u591a\u5173\u7cfb\u8d4b\u503c", (String)"QueryCloudData_12", (String)"isc-iscb-connector-other", (Object[])new Object[0]));
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u8d4b\u503c\u5bf9\u8c61\u975emap\u7ed3\u6784\uff0c\u6570\u636e\u4e3a\uff1a%s", (String)"QueryCloudData_13", (String)"isc-iscb-connector-other", (Object[])new Object[0]), billValue));
    }

    public static Object getIdFromBill(Object billValue) {
        if (billValue instanceof Map) {
            return ((Map)billValue).get("Id");
        }
        if (billValue instanceof List) {
            List billList = (List)billValue;
            Map billMap = (Map)billList.get(0);
            if (billMap.containsKey("Key")) {
                return QueryCloudData.formatMultiLang(billList);
            }
            return billMap.get("Id");
        }
        return billValue;
    }

    private static Object formatMultiLang(Object billValue, Object requiresValue) {
        Map<String, Object> multiLangMap = QueryCloudData.formatMultiLang((List)billValue);
        if (requiresValue instanceof Map) {
            return QueryCloudData.filterMultiLang((Map)requiresValue, multiLangMap);
        }
        return multiLangMap;
    }

    private static Map<String, Object> filterMultiLang(Map<String, Object> requiresValue, Map<String, Object> multiLangMap) {
        HashMap<String, Object> filterMultiLang = new HashMap<String, Object>(4);
        for (Map.Entry<String, Object> en : requiresValue.entrySet()) {
            String key = en.getKey();
            filterMultiLang.put(key, multiLangMap.get(key));
        }
        return filterMultiLang;
    }

    private static Map<String, Object> formatMultiLang(List<Map<String, Object>> billValues) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        for (Map<String, Object> m : billValues) {
            Object key = m.get("Key");
            Object value = m.get(KEY_VALUE);
            if (key.equals(2052)) {
                map.put("zh_CN", value);
                continue;
            }
            if (key.equals(1033)) {
                map.put("en_US", value);
                continue;
            }
            if (!key.equals(3076)) continue;
            map.put("zh_TW", value);
        }
        return map;
    }

    private static Object format(K3SkyWebApiContext ctx, Object billProperty, Object requiresValue, Object fieldSchema) {
        if (billProperty instanceof Map) {
            Map billPropertys = (Map)billProperty;
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(billPropertys.size());
            items.add(QueryCloudData.getSrcData(ctx, billPropertys, QueryCloudData.getEntryMeta(ctx, fieldSchema), (Map)requiresValue));
            return items;
        }
        if (billProperty instanceof List) {
            List billPropertyList = (List)billProperty;
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(billPropertyList.size());
            for (Map billInfo : billPropertyList) {
                items.add(QueryCloudData.getSrcData(ctx, billInfo, QueryCloudData.getEntryMeta(ctx, fieldSchema), (Map)requiresValue));
            }
            return items;
        }
        ArrayList<Object> items = new ArrayList<Object>(1);
        return items.add(billProperty);
    }

    public static Map<String, Object> getBillInfo(K3SkyWebApiContext ctx, Object id, String entity) {
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("Id", id);
        JSONObject billInfo = new HashMap();
        try {
            String data = Json.toString(param, (boolean)true);
            billInfo = JSON.parseObject((String)ctx.getApi().view(entity, data));
            CheckResult checkResult = new CheckResult(ctx, new Object[]{entity, data}, "View");
            return (Map)checkResult.check(billInfo);
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
    }

    private static List<Object> getBillCode(K3SkyWebApiContext ctx, List<Map<String, Object>> filter, List<Map<String, String>> orderBy, String entity) {
        Object parseFilter = QueryCloudData.parseFilter(ctx, entity, filter);
        String parseOrderBy = QueryCloudData.parseOrderBy(orderBy);
        Pair<String, String> fieldKeyInfo = K3SkyWebApiAction.getFieldKeyInfo(ctx, entity);
        String fieldKey = (String)fieldKeyInfo.getA();
        Map<String, Object> param = QueryCloudData.getParam(entity, parseFilter, parseOrderBy, fieldKey);
        ArrayList<Object> resultList = new ArrayList<Object>();
        int i = 0;
        QueryCloudData.getBillCodeList(ctx, param, resultList, i);
        return resultList;
    }

    private static void getBillCodeList(K3SkyWebApiContext ctx, Map<String, Object> param, List<Object> resultList, int i) {
        int limit = 2000;
        param.put("StartRow", i * limit);
        param.put("Limit", limit);
        List ids = new ArrayList();
        try {
            String data = Json.toString(param, (boolean)true);
            ids = ctx.getApi().executeBillQuery(data);
            CheckResult checkResult = new CheckResult(ctx, new Object[]{data}, "ExecuteBillQuery");
            ids = (List)checkResult.check(ids);
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        for (List s : ids) {
            resultList.add(s.get(0));
        }
        if (ids.size() >= limit) {
            QueryCloudData.getBillCodeList(ctx, param, resultList, ++i);
        }
    }

    private static Object parseFilter(K3SkyWebApiContext ctx, String entity, List<Map<String, Object>> filterList) {
        if (filterList == null || filterList.isEmpty()) {
            return null;
        }
        StringBuilder filterStr = new StringBuilder();
        Map<Object, List<Object>> entityMetaDate = K3SkyWebApiAction.getEntityMetaDate(ctx, entity);
        QueryCloudData.parseFilter(ctx, entityMetaDate, filterStr, filterList, entity);
        return filterStr;
    }

    public static void parseFilter(K3SkyWebApiContext ctx, Map<Object, List<Object>> entityMetaDate, StringBuilder filterStr, List<Map<String, Object>> filterList, String entity) {
        int size = filterList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> filterMap = filterList.get(i);
            Object filter_column = filterMap.get("filter_column");
            String filter_compare = filterMap.get("filter_compare").toString();
            Object filter_link = filterMap.get("filter_link");
            Object filter_left_bracket = filterMap.get("filter_left_bracket");
            Object filter_right_bracket = filterMap.get("filter_right_bracket");
            List<Object> fieldInfos = entityMetaDate.get(filter_column);
            if (fieldInfos == null || fieldInfos.isEmpty()) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%1$s\u3011\u7684\u661f\u7a7a\u8fde\u63a5\u914d\u7f6e\u5b58\u5728\u4ee5\u4e0b\u6570\u636e\u6e90\u3010%2$s\u3011,\u5728\u8fd9\u4e9b\u6570\u636e\u6e90\u4e0b\u4efb\u610f\u9009\u62e9\u7684\u5168\u540d\u4e3a\u3010%3$s\u3011\u96c6\u6210\u5bf9\u8c61\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027\uff1a\u3010%4$s\u3011\u30021\u3001\u8bf7\u786e\u5b9a\u8be5\u5c5e\u6027\u5b57\u6bb5\u662f\u5426\u5c5e\u4e8e\u8be5\u96c6\u6210\u5bf9\u8c61\u30022\u3001\u8fd9\u4e9b\u6570\u636e\u6e90\u4e0b\u53ef\u80fd\u5b58\u5728\u591a\u4e2a\u5168\u540d\u76f8\u540c\u7684\u96c6\u6210\u5bf9\u8c61\uff08\u90e8\u5206\u672a\u540c\u6b65\u6210\u529f\uff09\uff0c\u8bf7\u5728\u96c6\u6210\u5bf9\u8c61\u5217\u8868\u8fc7\u6ee4\u8be5\u5168\u540d\u7684\u96c6\u6210\u5bf9\u8c61\uff0c\u9009\u4e2d\u540e\u91cd\u65b0\u540c\u6b65", (String)"QueryCloudData_14", (String)"isc-iscb-connector-other", (Object[])new Object[0]), ctx.getConfig().get("number"), QueryCloudData.getAllDataSourceName(QueryCloudData.getDataSource(ctx)), entity, filter_column));
            }
            Object filter_type = fieldInfos.get(0);
            Object filter_value = QueryCloudData.getFilterByType(ctx, filterMap.get("filter_value"), filter_type);
            if (filter_left_bracket != null) {
                filterStr.append(filter_left_bracket);
            }
            filterStr.append(filter_column).append(' ');
            QueryCloudData.buildFilter(filterStr, filter_compare, filter_value, D.s((Object)filter_type));
            if (filter_right_bracket != null) {
                filterStr.append(filter_right_bracket);
            }
            if (i == size - 1) continue;
            filterStr.append("OR".equals(filter_link) ? " OR " : " AND ");
        }
    }

    private static void buildFilter(StringBuilder filter, String compare, Object value, String type) {
        switch (compare) {
            case "STARTS_WITH": {
                QueryCloudData.setFilterParam(filter, "like", null, value, Character.valueOf('%'), type);
                break;
            }
            case "CONTAINS": {
                QueryCloudData.setFilterParam(filter, "like", Character.valueOf('%'), value, Character.valueOf('%'), type);
                break;
            }
            case "NOT_STARTS_WITH": {
                QueryCloudData.setFilterParam(filter, "not like", null, value, Character.valueOf('%'), type);
                break;
            }
            case "NOT_ENDS_WITH": {
                QueryCloudData.setFilterParam(filter, "not like", Character.valueOf('%'), value, null, type);
                break;
            }
            case "IS_NULL": {
                filter.append("is null");
                break;
            }
            case "IS_NOT_NULL": {
                filter.append("is not null");
                break;
            }
            case "ENDS_WITH": {
                QueryCloudData.setFilterParam(filter, "like", Character.valueOf('%'), value, null, type);
                break;
            }
            case "<>": {
                QueryCloudData.setFilterParam(filter, "<>", null, value, null, type);
                break;
            }
            case "in": {
                filter.append("in").append(' ').append(value);
                break;
            }
            case "not in": {
                filter.append("not in").append(' ').append(value);
                break;
            }
            case "NOT_CONTAINS": {
                QueryCloudData.setFilterParam(filter, "not like", Character.valueOf('%'), value, Character.valueOf('%'), type);
                break;
            }
            default: {
                QueryCloudData.setFilterParam(filter, compare, null, value, null, type);
            }
        }
    }

    private static void setFilterParam(StringBuilder filter, String qcp, Character prefix, Object value, Character suffix, String type) {
        if (NO_QUOTATION_TYPE.contains(type)) {
            filter.append(qcp).append(' ').append(value);
        } else {
            QueryCloudData.setSingleQuoteByType(filter, type, qcp, prefix, value, suffix);
        }
    }

    private static void setSingleQuoteByType(StringBuilder filter, String type, String qcp, Character prefix, Object value, Character suffix) {
        if ("REF".equals(type)) {
            if (D.isLong((String)D.s((Object)value))) {
                filter.append(qcp).append(' ').append(value);
            } else {
                QueryCloudData.setSingleQuote(filter, qcp, prefix, value, suffix);
            }
        } else {
            QueryCloudData.setSingleQuote(filter, qcp, prefix, value, suffix);
        }
    }

    private static void setSingleQuote(StringBuilder filter, String qcp, Character prefix, Object value, Character suffix) {
        filter.append(qcp).append(' ').append('\'');
        if (prefix != null) {
            filter.append(prefix);
        }
        filter.append(value);
        if (suffix != null) {
            filter.append(suffix);
        }
        filter.append('\'');
    }

    public static Object getFilterByType(K3SkyWebApiContext ctx, Object filterValue, Object filterType) {
        if (filterValue == null) {
            return null;
        }
        if (filterValue instanceof List) {
            return QueryCloudData.getFilterValueFromList((List)filterValue);
        }
        return QueryCloudData.valueIsString(ctx, filterValue, filterType);
    }

    private static Object valueIsString(K3SkyWebApiContext ctx, Object filterValue, Object filterType) {
        String value = filterValue.toString();
        if (value.startsWith("(") && value.endsWith(")")) {
            return value.trim().replace('\"', '\'');
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            return QueryCloudData.getFilterValueFromList((List)JSON.parseObject((String)value, List.class));
        }
        return QueryCloudData.parseValueByType(ctx, filterType, filterValue, value);
    }

    private static Object parseValueByType(K3SkyWebApiContext ctx, Object filterType, Object filterValue, String value) {
        String type = D.s((Object)filterType);
        try {
            switch (type) {
                case "string": {
                    return value;
                }
                case "boolean": {
                    return QueryCloudData.getFilterBooleanValue(value);
                }
                case "datetime": 
                case "date": {
                    return QueryCloudData.getDataTime(value);
                }
                case "long": {
                    return D.l((Object)value);
                }
                case "integer": {
                    return D.i((Object)value);
                }
                case "decimal": {
                    return D.n((Object)value);
                }
                case "ml_string_k3c": {
                    return QueryCloudData.getMlString(filterValue, ctx);
                }
                case "REF": {
                    if (D.isLong((String)value)) {
                        return D.l((Object)value);
                    }
                    return value;
                }
            }
            return filterValue;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u503c%1$s\u8f6c\u6362\u4e3a%2$s\u7c7b\u578b", (String)"QueryCloudData_15", (String)"isc-iscb-connector-other", (Object[])new Object[0]), filterValue, filterType), e);
        }
    }

    private static Object getMlString(Object filter_value, K3SkyWebApiContext ctx) {
        Object icid = ctx.getConfig().get("icid");
        if (filter_value instanceof Map) {
            Map value = (Map)filter_value;
            return value.get(icid);
        }
        if (D.s((Object)filter_value).startsWith("{") && D.s((Object)filter_value).endsWith("}")) {
            Map value = (Map)JSON.parseObject((String)D.s((Object)filter_value), Map.class);
            return value.get(icid);
        }
        return filter_value;
    }

    private static Object getFilterValueFromList(List<Object> value) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < value.size(); ++i) {
            stringBuilder.append('\'').append(value.get(i)).append('\'');
            if (i == value.size() - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.append(')');
    }

    private static Object getFilterBooleanValue(Object b) {
        if (null == b) {
            return 0;
        }
        String s = b.toString().trim();
        if (s.length() == 0) {
            return 0;
        }
        if ("false".equalsIgnoreCase(s) || "0".equalsIgnoreCase(s)) {
            return 0;
        }
        if ("true".equalsIgnoreCase(s) || "1".equalsIgnoreCase(s)) {
            return 1;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u7684\u5e03\u5c14\u7c7b\u578b\u6570\u636e '%s'.", (String)"QueryCloudData_16", (String)"isc-iscb-connector-other", (Object[])new Object[0]), s));
    }

    private static String getDataTime(Object dateTime) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + df.format(D.t((Object)dateTime)) + "'}";
    }

    public static Map<String, Object> getParam(String entity, Object parseFilter, String parseOrderBy, String fieldKey) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("FormId", entity);
        param.put("FieldKeys", fieldKey);
        if (null != parseFilter) {
            param.put("FilterString", parseFilter);
        }
        if (null != parseOrderBy) {
            param.put("OrderString", parseOrderBy);
        }
        return param;
    }

    private static String parseOrderBy(List<Map<String, String>> orderBy) {
        StringBuilder orderByStr = new StringBuilder();
        if (null != orderBy && orderBy.size() > 0) {
            for (int i = 0; i < orderBy.size(); ++i) {
                Map<String, String> od = orderBy.get(i);
                String sort_field = od.get("sort_field");
                String sort_mode = od.get("sort_mode");
                if (i + 1 < orderBy.size()) {
                    orderByStr.append(sort_field).append(' ').append(sort_mode).append(',');
                    continue;
                }
                orderByStr.append(sort_field).append(' ').append(sort_mode);
            }
        }
        return orderByStr.toString();
    }
}

