/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk.attachment;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.IscK3CloudApi;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiContext;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.attachment.K3SkyAttachmentUtil;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.AbstractOutputStream;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.script.Script;

public class K3SkyAttachmentOutputStream
extends AbstractOutputStream {
    public static final int MAX_SIZE = 0x100000;
    private K3SkyWebApiContext ctx;
    private byte[] buffer;
    private String fileName;
    private int count;
    private int index;
    private String fileId;
    private String fileType;
    private int blockSize;
    private Timestamp attachCreateTime;
    private String attachCreator;

    public K3SkyAttachmentOutputStream() {
    }

    public K3SkyAttachmentOutputStream(K3SkyWebApiContext ctx, Map<String, Object> fileInfo, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.ctx = ctx;
        this.blockSize = Math.min(0x100000, size);
        this.buffer = new byte[this.blockSize];
        this.fileType = D.s((Object)fileInfo.get("type"));
        this.fileName = D.s((Object)fileInfo.get("name")) + "." + this.fileType;
        this.count = 0;
        this.attachCreateTime = D.t((Object)fileInfo.get("attachCreateTime"));
        this.attachCreator = D.s((Object)fileInfo.get("attachCreator"));
    }

    public String getAttachmentId() {
        return this.fileId;
    }

    public void markError() {
    }

    public void write(int b) {
        ++this.count;
        if (this.index == this.blockSize) {
            this.flushBuffer(false);
        }
        this.buffer[this.index++] = (byte)b;
    }

    private void flushBuffer(boolean last) {
        this.uploadAttachment(last);
        this.buffer = new byte[this.blockSize];
        this.index = 0;
    }

    private void uploadAttachment(boolean last) {
        Map<String, Object> params = this.getParams(last);
        HashMap<String, Object> response = new HashMap();
        try {
            IscK3CloudApi api = this.ctx.getApi();
            response = (Map)Script.parseJson((String)api.IscUploadFile(Json.toString(params, (boolean)true)));
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        this.parseResult(params, response);
    }

    public void parseResult(Map<String, Object> params, Map<String, Object> response) {
        Map result = (Map)response.get("Result");
        Map responseStatus = (Map)result.get("ResponseStatus");
        boolean isSuccess = D.x(responseStatus.get("IsSuccess"));
        if (!isSuccess) {
            HashMap<String, Object> map = new HashMap<String, Object>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if ("SendByte".equals(entry.getKey())) continue;
                map.put(entry.getKey(), entry.getValue());
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u661f\u7a7a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25\uff0c\u5165\u53c2\uff1a%1$s\uff0c\u539f\u59cb\u8fd4\u56de\u7ed3\u679c\u662f\uff1a%2$s", (String)"K3SkyAttachmentOutputStream_2", (String)"isc-iscb-connector-other", (Object[])new Object[0]), Json.toString(map), response));
        }
        this.fileId = D.s(result.get("FileId"));
    }

    private Map<String, Object> getParams(boolean last) {
        HashMap<String, Object> data = new HashMap<String, Object>(12);
        data.put("FileName", this.fileName);
        data.put("IsLast", last);
        if (this.fileId != null) {
            data.put("FileId", this.fileId);
        }
        data.put("SendByte", Base64.getEncoder().encodeToString(this.getBuffer(last)));
        return data;
    }

    private byte[] getBuffer(boolean last) {
        if (last) {
            byte[] bs = new byte[this.index];
            System.arraycopy(this.buffer, 0, bs, 0, this.index);
            return bs;
        }
        return this.buffer;
    }

    public void close() throws IOException {
        this.flushBuffer(true);
        if (this.fileId == null) {
            return;
        }
        AttachmentUtil.saveTempAttachmentDetail((long)K3SkyAttachmentUtil.getAttachTempId(this.fileId), (String)this.fileName, (String)this.fileType, null, (long)this.count, null, null, (Timestamp)this.attachCreateTime, (String)this.attachCreator);
    }
}

