/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk.setter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudBizAction;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudSetter;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyQueryBillObject;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiAction;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiContext;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.QueryCloudData;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class K3SkyEntriesSetter
implements K3CloudSetter {
    private Map<Object, List<Object>> dataTypeMap;
    private Boolean isInsert;
    private K3SkyWebApiContext ctx;
    private Map<String, List<String>> judgeFields;
    private Map<Object, List<Object>> entryMetaDate;

    public K3SkyEntriesSetter(K3SkyWebApiContext ctx, Map<Object, List<Object>> dataTypeMap, Map<String, List<String>> judgeFields, Boolean isInsert) {
        this.dataTypeMap = dataTypeMap;
        this.isInsert = isInsert;
        this.ctx = ctx;
        this.judgeFields = judgeFields;
    }

    public void setObjValue(Map<String, Object> modelDataMap, Map.Entry<String, Object> cloudDataMap) {
        String key = cloudDataMap.getKey();
        Object value = cloudDataMap.getValue();
        if (value instanceof Map) {
            this.getEntryFromMap(modelDataMap, key, (Map)value);
        } else if (value instanceof List) {
            this.getEntryFromList(modelDataMap, key, value);
        } else {
            modelDataMap.put(key, value);
        }
    }

    private void getEntryFromList(Map<String, Object> modelDataMap, String key, Object value) {
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>(((List)value).size());
        for (Map m : (List)value) {
            if (m.containsKey("Key") || m.containsKey("Value")) {
                modelDataMap.put(key, value);
                continue;
            }
            this.buildEntryData(modelDataMap, key, entryList, m);
        }
    }

    private void getEntryFromMap(Map<String, Object> modelDataMap, String key, Map<String, Object> value) {
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>(value.size());
        this.buildEntryData(modelDataMap, key, entryList, value);
    }

    private void buildEntryData(Map<String, Object> modelDataMap, String key, List<Map<String, Object>> entryList, Map<String, Object> value) {
        this.checkOperationType(modelDataMap, key, value);
        LinkedHashMap<String, Object> entryEntityCloum = new LinkedHashMap<String, Object>(16);
        modelDataMap.put(key, entryList);
        Map<Object, List<Object>> entityEntryMetaDataToMap = K3SkyWebApiAction.getEntryMetaDate(this.ctx, this.dataTypeMap.get(key).get(1));
        entryList.add(K3SkyWebApiAction.getModelData(this.ctx, entityEntryMetaDataToMap, value, this.judgeFields, entryEntityCloum, null, this.isInsert));
    }

    private void checkOperationType(Map<String, Object> modelDataMap, String entryKey, Map<String, Object> entryValue) {
        List<String> judgeField = this.judgeFields.get(entryKey);
        if (null == judgeField || judgeField.size() < 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\uff08%s\uff09\u672a\u8bbe\u7f6e\u5019\u9009\u952e!", (String)"K3SkyEntriesSetter_8", (String)"isc-iscb-connector-other", (Object[])new Object[0]), entryKey));
        }
        List<Object> entryType = this.dataTypeMap.get(entryKey);
        String schema = D.s((Object)entryType.get(1));
        this.entryMetaDate = K3SkyWebApiAction.getEntryMetaDate(this.ctx, schema);
        String entryPk = D.s((Object)entryValue.get("$pk"));
        entryPk = entryPk == null ? K3CloudBizAction.getPrimaryKey(this.entryMetaDate) : entryPk;
        String entityFullName = K3SkyWebApiAction.getFullNameBySchema(this.ctx, schema);
        if (this.isInsert.booleanValue()) {
            entryValue.remove(entryPk);
        } else {
            this.checkEntryOperationType(modelDataMap, entryKey, entryValue, judgeField, entryPk, entityFullName);
        }
    }

    private void checkEntryOperationType(Map<String, Object> modelDataMap, String key, Map<String, Object> value, List<String> judgeField, String fieldKey, String entityFullName) {
        String entityPK = K3CloudBizAction.getPrimaryKey(this.dataTypeMap);
        this.entryUpdate(key, value, judgeField, fieldKey, entityFullName, entityPK, modelDataMap.get(entityPK));
    }

    private void entryUpdate(String key, Map<String, Object> value, List<String> judgeField, String fieldKey, String entityFullName, String entityPK, Object entityId) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>(1);
        filterMap.put(entityPK, entityId);
        Object entryFilter = this.getFilter(value, judgeField, filterMap);
        StringBuilder entryFieldKeys = this.getFieldKeys(key, fieldKey);
        List<List<Object>> entryPks = new K3SkyQueryBillObject(this.ctx, entityFullName, entryFieldKeys, entryFilter).invoke();
        int entrySize = entryPks.size();
        if (entrySize < 1) {
            value.remove(fieldKey);
        } else {
            if (entrySize > 1) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u6839\u636e\u5019\u9009\u952e\u6761\u4ef6\uff1a%2$s\u67e5\u51fa\u5206\u5f55\u6570\u636e%3$s\u6761", (String)"K3SkyEntriesSetter_9", (String)"isc-iscb-connector-other", (Object[])new Object[0]), key, entryFilter, entrySize));
            }
            Object entryId = entryPks.get(0).get(0);
            value.put(fieldKey, entryId);
        }
    }

    private StringBuilder getFieldKeys(String pk, String fieldKey) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != fieldKey) {
            stringBuilder.append(pk).append('_').append(fieldKey);
        }
        return stringBuilder;
    }

    private Object getFilter(Map<String, Object> entryMap, List<String> judgeField, Map<String, Object> filterMap) {
        StringBuilder stringBuilder = new StringBuilder();
        int size = judgeField.size();
        for (int i = 0; i < size; ++i) {
            String key = judgeField.get(i);
            Object entryValue = entryMap.get(key);
            if (null == entryValue) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u5019\u9009\u952e (%s) \u672a\u8d4b\u503c", (String)"K3SkyEntriesSetter_10", (String)"isc-iscb-connector-other", (Object[])new Object[0]), key));
            }
            List<Object> objects = this.entryMetaDate.get(key);
            Object fieldType = null;
            if (objects != null) {
                fieldType = objects.get(0);
            }
            Object filterValue = QueryCloudData.getFilterByType(this.ctx, entryValue, fieldType);
            stringBuilder.append(key).append(" = ").append('\'').append(filterValue).append('\'');
            if (i >= size - 1) continue;
            stringBuilder.append(" and ");
        }
        if (filterMap != null) {
            for (Map.Entry<String, Object> m : filterMap.entrySet()) {
                stringBuilder.append(" and ").append(m.getKey()).append(" = ").append('\'').append(m.getValue()).append('\'');
            }
        }
        return stringBuilder;
    }
}

