/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.script.misc.log.Logger;
import kd.isc.iscb.util.script.misc.log.LoggerFactory;

public class IscHubConfigUtil {
    public static final String CURRENT_DATA_CENTER = "current_data_center";
    public static final String T_ISC_HUB_SERVER = "T_ISC_HUB_SERVER";
    public static final String T_ISC_HUB_PERMIT = "T_ISC_HUB_PERMIT";
    private static final ReadLockFreeMap<String, Map<String, String>> permissions = new ReadLockFreeMap();

    public static void createIscHubPermitTable(Connection cn, String typeOfClob) {
        String sql = "create table T_ISC_HUB_PERMIT(fid varchar(32) not null,fname varchar(250) not null,fpermit varchar(50) not null,ftime datetime not null,ffilter " + typeOfClob + ",CONSTRAINT PK_ISC_HUB_PERMIT primary key(fid))";
        DbUtil.executeUpdate(cn, sql);
    }

    public static void clearIscHubPermissions(Connection cn) {
        String sql = "DELETE FROM T_ISC_HUB_PERMIT";
        DbUtil.executeUpdate(cn, sql);
    }

    public static void saveIscHubPermit(Connection cn, String meta, String permit) {
        String id = Hash.md5(meta.toLowerCase().trim());
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String insert = "INSERT INTO T_ISC_HUB_PERMIT(fid,fname,fpermit,ftime) VALUES (?,?,?,?)";
        List<Object> values = Arrays.asList(id, meta, permit, time);
        List<Integer> types = Arrays.asList(12, 12, 12, 93);
        DbUtil.executeUpdate(cn, insert, values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadIscHubPermissions(Connection cn, String dataCenter) {
        try (ObjectReader<DataRow> reader = DbUtil.executeQuery(cn, "select fname,fpermit from T_ISC_HUB_PERMIT", new ArrayList<Object>(0), new ArrayList<Integer>(0));){
            HashMap<String, String> map = new HashMap<String, String>();
            DataRow row = reader.read();
            while (row != null) {
                String meta = D.s(row.get("fname"));
                String permit = D.s(row.get("fpermit"));
                map.put(meta.toLowerCase(), permit);
                row = reader.read();
            }
            permissions.put(dataCenter, map);
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasPermission(String dataCenter, String meta, ConnectorContext.Operation op, ConnectorContext ctx) {
        String name;
        String permit;
        Map<String, String> map = permissions.get(dataCenter);
        if (map == null) {
            Connection cn = ctx.getConnection();
            try {
                map = IscHubConfigUtil.loadIscHubPermissions(cn, dataCenter);
            }
            finally {
                ctx.dispose(cn);
            }
        }
        if ((permit = map.get(name = meta.toLowerCase())) == null) {
            return false;
        }
        return permit.contains(op.toString());
    }

    public static void createIscHubServerTable(Connection cn, String typeOfClob) {
        String sql = "create table T_ISC_HUB_SERVER(fid char(1) not null,fierp_server_url varchar(255) not null,fpermission_mode varchar(50) not null,fisc_access_key " + typeOfClob + " not null,CONSTRAINT PK_ISC_HUB_SERVER primary key(fid))";
        DbUtil.executeUpdate(cn, sql);
    }

    public static void saveIscHubServerInfo(Connection cn, String ierp_server_url, String isc_access_key, PermissionMode mode) {
        String sql = "delete from T_ISC_HUB_SERVER";
        DbUtil.executeUpdate(cn, sql);
        sql = "INSERT INTO T_ISC_HUB_SERVER(fid,fierp_server_url,fisc_access_key,fpermission_mode) VALUES('1',?,?,?)";
        List<Object> values = Arrays.asList(ierp_server_url, isc_access_key, mode.toString());
        List<Integer> types = Arrays.asList(12, 12, 12);
        DbUtil.executeUpdate(cn, sql, values, types);
    }

    public static Map<String, String> loadIscHubServerInfo(Connection cn, String dataCenter) {
        String sql = "select fid,fierp_server_url,fisc_access_key,fpermission_mode from T_ISC_HUB_SERVER";
        DataRow row = DbUtil.executeRow(cn, sql);
        Map<String, String> loginInfo = IscHubConfigUtil.getIscHubLoginInfo(cn, row, dataCenter);
        if (loginInfo == null) {
            return null;
        }
        String ierp_server_url = D.s(row.get("fierp_server_url"));
        String permission_mode = D.s(row.get("fpermission_mode"));
        ConnectorCallback.registerLoginInfo(dataCenter, loginInfo, ierp_server_url, permission_mode);
        EventBindingUtil.registerLoginInfo(loginInfo);
        ConnectorCallback.removeAccessToken(loginInfo);
        return loginInfo;
    }

    public static Map<String, String> getIscHubLoginInfo(Connection cn, DataRow row, String dataCenter) {
        if (row == null) {
            return null;
        }
        String isc_access_key = D.s(row.get("fisc_access_key"));
        Map loginInfo = (Map)Json.toObject(Cipher.decrypt(isc_access_key));
        String dataCenter0 = D.s(loginInfo.get(CURRENT_DATA_CENTER));
        if (dataCenter0 == null) {
            return IscHubConfigUtil.updatedIscHubServerInfo(cn, loginInfo, dataCenter, D.s(row.get("fid")));
        }
        if (dataCenter0.equalsIgnoreCase(dataCenter)) {
            return loginInfo;
        }
        return IscHubConfigUtil.processedInvalidIscHubServerInfo(dataCenter, dataCenter0);
    }

    private static Map<String, String> processedInvalidIscHubServerInfo(String dataCenter, String dataCenter0) {
        Logger log = LoggerFactory.REF.get().getLogger(IscHubConfigUtil.class);
        log.warn("\u6570\u636e\u4e2d\u5fc3\uff08" + dataCenter + "\uff09\u7684\u96c6\u6210\u4e91\u8fde\u63a5\u4fe1\u606f\u662f\u672c\u6570\u636e\u5e93\u4f5c\u4e3a\u6570\u636e\u4e2d\u5fc3\uff08" + dataCenter0 + "\uff09\u65f6\u90e8\u7f72\u7684\uff0c\u8be5\u6570\u636e\u4e2d\u5fc3\u53ef\u80fd\u662f\u901a\u8fc7\u6570\u636e\u5e93\u5907\u4efd\u6062\u590d\u7684\u4f46\u6ca1\u6709\u7ecf\u8fc7\u6570\u636e\u8131\u654f\uff0c\u4e3a\u907f\u514d\u53d1\u751f\u6d4b\u8bd5\u73af\u5883\u6570\u636e\u88ab\u540c\u6b65\u5230\u751f\u4ea7\u73af\u5883\u7684\u4e8b\u6545\uff0c\u8be5\u90e8\u7f72\u4fe1\u606f\u5df2\u5ffd\u7565\u3002\u5982\u9700\u7ee7\u7eed\u4f7f\u7528\u96c6\u6210\u4e91\uff0c\u8bf7\u5728\u96c6\u6210\u4e91\u5bf9\u5e94\u7684\u8fde\u63a5\u914d\u7f6e\u4e0a\u91cd\u65b0\u6267\u884c\u201c\u90e8\u7f72\u201d\u548c\u201c\u521d\u59cb\u5316\u201d\u64cd\u4f5c\u3002");
        return null;
    }

    private static Map<String, String> updatedIscHubServerInfo(Connection cn, Map<String, String> loginInfo, String dataCenter, String fid) {
        loginInfo.put(CURRENT_DATA_CENTER, dataCenter);
        String isc_access_key = Cipher.encrypt(Json.toString(loginInfo));
        String sql = "UPDATE T_ISC_HUB_SERVER SET fisc_access_key = ? WHERE fid=?";
        DbUtil.executeUpdate(cn, sql, D.asList(isc_access_key, fid), D.asList(12, 12));
        return loginInfo;
    }

    public static void removePermissions(String dataCenter) {
        permissions.remove(dataCenter);
    }

    public static Map<String, Object> getDeployInfo(Connection cn) {
        String sql = "select fid,fierp_server_url,fisc_access_key,fpermission_mode from T_ISC_HUB_SERVER";
        DataRow row = DbUtil.executeRow(cn, sql);
        return row;
    }
}

