/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server;

import java.util.Map;
import java.util.UUID;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.Returns;
import kd.isc.iscb.util.connector.server.SerializableResultManager;
import kd.isc.iscb.util.data.Null;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.misc.Json;

public class SerializableReturns
implements Returns {
    private String id;
    private boolean has_consumer = true;
    private Object result = null;
    private int index = 0;
    private ConnectorContext ctx;
    private boolean hasHeader = false;

    public SerializableReturns(ConnectorContext ctx) {
        this.ctx = ctx;
        this.id = UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public synchronized void setResult(Map<String, Object> result, boolean hasMore) {
        result.put("$has_more", hasMore);
        result.put("$id", this.id);
        this.setResult(result);
    }

    @Override
    public synchronized void setResult(Object result) {
        Object wrapped = Null.wrap(result);
        boolean hasMore = this.judgeHashMoreData(result);
        if (this.has_consumer) {
            if (hasMore) {
                this.saveHeaderIfNotExisted();
            }
            this.has_consumer = false;
            this.result = wrapped;
            this.notifyAll();
        } else {
            try {
                this.saveHeaderIfNotExisted();
                byte[] chunk = Json.toString(wrapped).getBytes(D.UTF_8);
                SerializableResultManager.saveChunk(this.ctx, this.id, ++this.index, chunk, hasMore);
            }
            catch (Throwable e) {
                this.ctx.logger("Returns.setResult() failed.", e);
                throw D.e(e);
            }
        }
    }

    private boolean judgeHashMoreData(Object result) {
        if (result instanceof Map) {
            return D.x(((Map)result).get("$has_more"));
        }
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ConnectorContext getContext() {
        return this.ctx;
    }

    @Override
    public synchronized Object getResult() {
        if (this.result != null) {
            return this.result;
        }
        try {
            this.wait(SerializableReturns.getTimeOut());
            if (this.result == null) {
                this.saveHeaderIfNotExisted();
            }
            Object object = this.result;
            return object;
        }
        catch (InterruptedException e) {
            throw CommonError.THREAD_INTERRUPTED.wrap(e);
        }
        finally {
            this.has_consumer = false;
        }
    }

    public static int getTimeOut() {
        int i = D.i((Object)System.getProperty("ISC_RPC_TIMEOUT"));
        return i > 0 ? Math.max(1000, i) : 15000;
    }

    private synchronized void saveHeaderIfNotExisted() {
        if (!this.hasHeader) {
            SerializableResultManager.saveTmpMainRecord(this.ctx, this.id);
            this.hasHeader = true;
        }
    }
}

