/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import java.sql.Connection;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.e.DbInfo;
import kd.isc.iscb.util.connector.server.e.GetTable;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class GetTableInfo
extends AbstractCommandExecutor {
    private static final Collator STRING_COMPARATOR = Collator.getInstance(Locale.CHINA);

    @Override
    public String getCommand() {
        return "get_table_info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> exec(ConnectorContext ctx, Map<String, Object> params) {
        Connection cn = ctx.getConnection();
        try {
            String table_name = D.s(params.get("name"));
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("full_name", table_name);
            meta.put("name", table_name);
            meta.put("type", "TABLE");
            meta.put("table_name", table_name);
            meta.put("title", table_name);
            Table table = this.getTable(cn, table_name);
            meta.put("properties", GetTableInfo.getProperties(table));
            HashMap<String, Object> hashMap = meta;
            return hashMap;
        }
        finally {
            ctx.dispose(cn);
        }
    }

    private Table getTable(Connection cn, String table_name) {
        DbInfo db = new DbInfo(cn);
        List<Map<String, Object>> fields = GetTable.getFields(db, table_name);
        if (fields.size() == 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\uff08%s\uff09\u4e0d\u5b58\u5728\uff01", (String)"GetTableInfo_2", (String)"isc-iscb-util", (Object[])new Object[0]), table_name));
        }
        List<String> pks = GetTable.getPrimaryKeys(db, table_name);
        Table table = new Table(table_name, '\"', fields, pks);
        return table;
    }

    private static Object getProperties(Table table) {
        ArrayList<Map<String, Object>> properties = new ArrayList<Map<String, Object>>(table.getFieldCount());
        for (int i = 0; i < table.getFieldCount(); ++i) {
            Column c = table.getField(i);
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("name", c.getName());
            String label = c.getRealName();
            item.put("label", label);
            item.put("data_type", c.getDataType().toString());
            item.put("is_primary_key", c.isPrimaryKey());
            item.put("is_nullable", c.isNullable());
            item.put("remark", c.getRemark());
            properties.add(item);
        }
        GetTableInfo.sortProperties(properties);
        return properties;
    }

    private static void sortProperties(List<Map<String, Object>> list) {
        Collections.sort(list, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> a, Map<String, Object> b) {
                String ta = (String)a.get("name");
                String tb = (String)b.get("name");
                return STRING_COMPARATOR.compare(ta, tb);
            }
        });
    }
}

