/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.hub;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.hub.HubInfo;
import kd.isc.iscb.util.connector.server.hub.HubServerIdUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Hash;

public class ConnectorUtil {
    private static final Map<String, Boolean> DC_TO_MULTI_HUB_SUPPORT = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, List<HubInfo>> DC_TO_HUB_LIST = new ConcurrentHashMap<String, List<HubInfo>>();
    private static final Map<String, HubInfo> HUB_INFO_MAP = new ConcurrentHashMap<String, HubInfo>();
    private static final Map<String, String> ACCESS_KEYS = new ConcurrentHashMap<String, String>();
    private static final Map<String, Map<String, String>> PERMISSIONS = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> IERP_LOGININFOS = new ConcurrentHashMap<String, Map<String, String>>();
    private static final int REFRESH_INTERVAL = 60000;
    private static final ConcurrentHashMap<String, AtomicLong> lastModifiedMap = new ConcurrentHashMap();

    public static void openMultiHubSupport(String dataCenter) {
        DC_TO_MULTI_HUB_SUPPORT.put(dataCenter, Boolean.TRUE);
    }

    public static boolean supportMultiHub(String dataCenter) {
        return D.x(DC_TO_MULTI_HUB_SUPPORT.get(dataCenter));
    }

    public static boolean hasMultiHubSupportedDataCenter() {
        return DC_TO_MULTI_HUB_SUPPORT.size() > 0;
    }

    public static boolean checkIscHubNotNull(String iscHub) {
        if (iscHub != null) {
            return true;
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u8fde\u63a5\u5668\u5df2\u5f00\u542f\u201c\u652f\u6301\u591a\u5957HUB\u90e8\u7f72\u201d\u53c2\u6570\uff0c\u5f53\u524d\u83b7\u53d6\u5230\u7684HUB\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u82cd\u7a79\u7aef\u5df2\u5347\u7ea77.0\u53ca\u4ee5\u4e0a\u7248\u672c\u5e76\u4e14\u91cd\u65b0\u90e8\u7f72\u4e86\u8fde\u63a5\u914d\u7f6e\u3002", (String)"ConnectorUtil1", (String)"isc-iscb-util", (Object[])new Object[0]));
    }

    public static boolean isValidHub(String dataCenter, String iscHub) {
        if (iscHub == null) {
            return false;
        }
        if (ConnectorUtil.supportMultiHub(dataCenter)) {
            return HUB_INFO_MAP.containsKey(iscHub);
        }
        String currentIscHub = ConnectorCallback.getIscHub(dataCenter);
        return iscHub.equals(currentIscHub);
    }

    public static String getAccessKey(String iscHub) {
        ConnectorUtil.checkIscHubNotNull(iscHub);
        String accessKey = ACCESS_KEYS.get(iscHub);
        if (accessKey != null) {
            return accessKey;
        }
        String tip = ResManager.loadKDString((String)"\u8fde\u63a5\u5668\u5df2\u5f00\u542f\u201c\u652f\u6301\u591a\u5957HUB\u90e8\u7f72\u201d\u53c2\u6570\uff0c\u4f46HUB\uff08%1$s\uff09\u672a\u90e8\u7f72\u96c6\u6210\u4e91\u8fde\u63a5\u4fe1\u606f\uff01\u8bf7\u4f7f\u7528\u201c\u8fde\u63a5\u914d\u7f6e - \u90e8\u7f72\u201d\u529f\u80fd\u5c06\u914d\u7f6e\u4fe1\u606f\u90e8\u7f72\u5230\u672cEAS\u73af\u5883\u3002", (String)"ConnectorUtil2", (String)"isc-iscb-util", (Object[])new Object[0]);
        throw new IscBizException(String.format(tip, iscHub));
    }

    public static void registerHubCache(String dataCenter, Connection cn) {
        String sql = "select fid,fierp_server_url,fisc_access_key,fpermission_mode,fisc_hub from T_ISC_HUB_SERVER";
        List<DataRow> hubRows = DbUtil.executeList(cn, sql, Collections.emptyList(), Collections.emptyList());
        ArrayList<HubInfo> list = new ArrayList<HubInfo>(hubRows.size());
        for (DataRow dataRow : hubRows) {
            Map<String, String> loginInfo = IscHubConfigUtil.getIscHubLoginInfo(cn, dataRow, dataCenter);
            if (loginInfo == null) continue;
            String fiscHub = D.s(dataRow.get("fisc_hub"));
            ConnectorUtil.checkIscHubNotNull(fiscHub);
            ConnectorUtil.registerLoginInfo(dataRow, fiscHub, loginInfo);
            EventBindingUtil.registerLoginInfo(loginInfo);
            ConnectorCallback.removeAccessToken(loginInfo);
            ACCESS_KEYS.put(fiscHub, loginInfo.get("key"));
            ConnectorUtil.loadIscHubPermissions(cn, fiscHub);
            HubInfo hubInfo = new HubInfo(loginInfo);
            HUB_INFO_MAP.put(fiscHub, hubInfo);
            list.add(hubInfo);
        }
        DC_TO_HUB_LIST.put(dataCenter, list);
    }

    public static HubInfo getHubInfo(String hub) {
        return HUB_INFO_MAP.get(hub);
    }

    public static void saveIscHubServerInfo(Connection cn, String ierp_server_url, String isc_access_key, PermissionMode mode, String iscHub) {
        ConnectorUtil.checkIscHubNotNull(iscHub);
        String sql = "delete from T_ISC_HUB_SERVER where fisc_hub = ?";
        DbUtil.executeUpdate(cn, sql, Collections.singletonList(iscHub), Collections.singletonList(12));
        sql = "select fid from T_ISC_HUB_SERVER";
        List<DataRow> existedIdList = DbUtil.executeList(cn, sql, Collections.emptyList(), Collections.emptyList());
        String fid = HubServerIdUtil.findProperId(existedIdList);
        sql = "INSERT INTO T_ISC_HUB_SERVER(fid,fierp_server_url,fisc_access_key,fpermission_mode,fisc_hub,fdeployed_time) VALUES(?,?,?,?,?,?)";
        List<Object> values = Arrays.asList(fid, ierp_server_url, isc_access_key, mode.toString(), iscHub, new Timestamp(System.currentTimeMillis()));
        List<Integer> types = Arrays.asList(12, 12, 12, 12, 12, 93);
        DbUtil.executeUpdate(cn, sql, values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadIscHubPermissions(Connection cn, String iscHub) {
        String sql = "select fname,fpermit from T_ISC_HUB_PERMIT where fisc_hub = ?";
        try (ObjectReader<DataRow> reader = DbUtil.executeQuery(cn, sql, Collections.singletonList(iscHub), Collections.singletonList(12));){
            HashMap<String, String> map = new HashMap<String, String>(2);
            DataRow row = reader.read();
            while (row != null) {
                String meta = D.s(row.get("fname"));
                String permit = D.s(row.get("fpermit"));
                map.put(meta.toLowerCase(), permit);
                row = reader.read();
            }
            PERMISSIONS.put(iscHub, map);
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    public static boolean hasPermission(String iscHub, String meta, ConnectorContext.Operation op, ConnectorContext ctx) {
        String name;
        Map<String, String> map = ConnectorUtil.getPermissions(iscHub, ctx);
        String permit = map.get(name = meta.toLowerCase());
        if (permit == null) {
            return false;
        }
        return permit.contains(op.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getPermissions(String iscHub, ConnectorContext ctx) {
        Map<String, String> map = PERMISSIONS.get(iscHub);
        if (map == null) {
            Connection cn = ctx.getConnection();
            try {
                map = ConnectorUtil.loadIscHubPermissions(cn, iscHub);
            }
            finally {
                ctx.dispose(cn);
            }
        }
        return map;
    }

    private static Map<String, String> registerLoginInfo(DataRow dataRow, String fiscHub, Map<String, String> loginInfo) {
        loginInfo.put("ierp_server_url", D.s(dataRow.get("fierp_server_url")));
        loginInfo.put("permission_mode", D.s(dataRow.get("fpermission_mode")));
        IERP_LOGININFOS.put(fiscHub, loginInfo);
        return loginInfo;
    }

    public static List<HubInfo> getHubList(String dataCenter) {
        if (dataCenter == null) {
            return Collections.emptyList();
        }
        List<HubInfo> list = DC_TO_HUB_LIST.get(dataCenter);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static String getIerpServerURL(String iscHub) {
        Map<String, String> loginInfo = ConnectorUtil.getIerpLoginInfo(iscHub);
        if (loginInfo == null) {
            return null;
        }
        String url = D.s(loginInfo.get("ierp_server_url"));
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static Map<String, String> getIerpLoginInfo(String iscHub) {
        ConnectorUtil.checkIscHubNotNull(iscHub);
        return IERP_LOGININFOS.get(iscHub);
    }

    public static Map<String, Object> getDeployInfo(Connection cn, String iscHub) {
        ConnectorUtil.checkIscHubNotNull(iscHub);
        String sql = "select fid,fierp_server_url,fisc_access_key,fpermission_mode from T_ISC_HUB_SERVER where fisc_hub = ?";
        DataRow row = DbUtil.executeRow(cn, sql, Collections.singletonList(iscHub), Collections.singletonList(12));
        return row;
    }

    public static void testCallbackIerp(String dataCenter, String iscHub, String ierpUrl) {
        try {
            ConnectorCallback.callByIscHub(dataCenter, iscHub, "test", new HashMap<String, Object>());
        }
        catch (Exception e) {
            String tip = ResManager.loadKDString((String)"\u6839\u636eISCHUB\u4fe1\u606f\u3010%1$s\u3011\u53cd\u8c03\u82cd\u7a79\u65f6\u62a5\u9519;  url:%2$s, \u9519\u8bef\u5185\u5bb9:%3$s", (String)"ConnectorUtil3", (String)"isc-iscb-util", (Object[])new Object[0]);
            String message = String.format(tip, ConnectorUtil.getHubInfo(iscHub), ierpUrl, e.getMessage());
            throw new IscBizException(message, e);
        }
    }

    public static PermissionMode getPermissionMode(String iscHub) {
        ConnectorUtil.checkIscHubNotNull(iscHub);
        Map<String, String> loginInfo = IERP_LOGININFOS.get(iscHub);
        return ConnectorCallback.getPermissionModeFromLoginInfo(loginInfo);
    }

    public static void deleteIscHub(Connection cn, String iscHub) {
        String sql = "delete from T_ISC_HUB_SERVER where fisc_hub = ?";
        DbUtil.executeUpdate(cn, sql, Collections.singletonList(iscHub), Collections.singletonList(12));
    }

    public static void clearIscHubPermissions(Connection cn, String iscHub) {
        ConnectorUtil.checkIscHubNotNull(iscHub);
        String sql = "DELETE FROM T_ISC_HUB_PERMIT where fisc_hub = ?";
        DbUtil.executeUpdate(cn, sql, Collections.singletonList(iscHub), Collections.singletonList(12));
    }

    public static void saveIscHubPermit(Connection cn, String meta, String permit, String iscHub) {
        String id = Hash.md5(iscHub + meta.toLowerCase().trim());
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String insert = "INSERT INTO T_ISC_HUB_PERMIT(fid,fname,fpermit,ftime,fisc_hub) VALUES (?,?,?,?,?)";
        List<Object> values = Arrays.asList(id, meta, permit, time, iscHub);
        List<Integer> types = Arrays.asList(12, 12, 12, 93, 12);
        DbUtil.executeUpdate(cn, insert, values, types);
    }

    public static void removeAllCacheByIscHub(String iscHub) {
        ACCESS_KEYS.remove(iscHub);
        HUB_INFO_MAP.remove(iscHub);
        IERP_LOGININFOS.remove(iscHub);
        PERMISSIONS.remove(iscHub);
    }

    public static void removeAllCacheByDataCenter(String dataCenter) {
        List<HubInfo> hubInfos = DC_TO_HUB_LIST.remove(dataCenter);
        if (hubInfos != null) {
            for (HubInfo hubInfo : hubInfos) {
                ConnectorUtil.removeAllCacheByIscHub(hubInfo.getIscHub());
            }
        }
    }

    public static void clearHubConfig(Connection cn, String iscHub) {
        ConnectorUtil.deleteIscHub(cn, iscHub);
        ConnectorUtil.clearIscHubPermissions(cn, iscHub);
        EventBindingUtil.batchDeleteEventBind(cn, iscHub);
        EventBindingUtil.batchDeleteEventQue(cn, iscHub);
    }

    public static void clearInvalidConfigs(Connection cn) {
        String where = " where fisc_hub is null or fisc_hub = ' '";
        String sql = "delete from T_ISC_HUB_SERVER" + where;
        DbUtil.executeUpdate(cn, sql);
        sql = "delete from T_ISC_HUB_PERMIT" + where;
        DbUtil.executeUpdate(cn, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshHubServer(ConnectorContext ctx, String iscHub) {
        ConnectorUtil.checkIscHubNotNull(iscHub);
        long now = System.currentTimeMillis();
        if (ConnectorUtil.canUpdate(iscHub, now)) {
            Connection cn = ctx.getConnection();
            try {
                ConnectorUtil.refreshHubServerInDb(cn, iscHub, new Timestamp(now));
            }
            finally {
                ctx.dispose(cn);
            }
        }
    }

    private static void refreshHubServerInDb(Connection cn, String iscHub, Timestamp timestamp) {
        String sql = "UPDATE T_ISC_HUB_SERVER SET fmodified_time = ? WHERE fisc_hub = ?";
        List<Object> params = Arrays.asList(timestamp, iscHub);
        List<Integer> types = Arrays.asList(93, 12);
        DbUtil.executeUpdate(cn, sql, params, types);
    }

    private static boolean canUpdate(String iscHub, long now) {
        long lastModifiedTime;
        AtomicLong lastModified = lastModifiedMap.get(iscHub);
        if (lastModified == null) {
            lastModifiedMap.putIfAbsent(iscHub, new AtomicLong(0L));
            lastModified = lastModifiedMap.get(iscHub);
        }
        if (now - (lastModifiedTime = lastModified.get()) > 60000L) {
            return lastModified.compareAndSet(lastModifiedTime, now);
        }
        return false;
    }
}

