/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.db;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.i.StringType;
import kd.isc.iscb.util.except.IscBizException;

public class Column {
    private int index;
    private int sqlType;
    private int orginalSqlType;
    private String binding;
    private DataType dataType;
    private String name;
    private boolean pk = false;
    private boolean nullable;
    private int precision;
    private int scale;
    private String alias2;
    private String remark;

    Column(ResultSetMetaData meta, int index) {
        try {
            int column = index + 1;
            String name = this.getColumnName(meta, column);
            this.binding = "\"" + name + "\"";
            this.name = name.toLowerCase();
            this.orginalSqlType = this.sqlType = meta.getColumnType(column);
            if (this.sqlType == 1111) {
                this.sqlType = 12;
            }
            this.index = index;
            this.precision = -1;
            this.scale = -1;
            this.dataType = DataTypeUtil.getDataType(this.sqlType, this.precision, this.scale);
            this.nullable = meta.isNullable(column) != 0;
        }
        catch (SQLException e) {
            throw new IscBizException(e);
        }
    }

    private String getColumnName(ResultSetMetaData meta, int column) throws SQLException {
        String name = meta.getColumnLabel(column);
        if (name == null) {
            name = "_xc_" + column;
        }
        if (name.charAt(0) == '\"') {
            name = name.replace("\"", "");
        }
        return name;
    }

    Column(ResultSet rs, int index, char quot, DatabaseMetaData meta) throws SQLException {
        String name = D.s(rs.getObject("COLUMN_NAME"));
        this.binding = (quot + name + quot).intern();
        this.name = name.toLowerCase().intern();
        this.index = index;
        this.nullable = D.x(rs.getObject("IS_NULLABLE"));
        this.precision = D.i(rs.getObject("COLUMN_SIZE"));
        this.scale = D.i(rs.getObject("DECIMAL_DIGITS"));
        this.orginalSqlType = this.sqlType = D.i(rs.getObject("DATA_TYPE"));
        this.sqlType = Column.handleSqlType(meta, this.sqlType);
        this.init(D.s(rs.getObject("TYPE_NAME")));
        this.remark = D.s(rs.getString("REMARKS"));
    }

    public static int handleSqlType(DatabaseMetaData meta, int sqlType) {
        if (sqlType == 91 && meta.getClass().getName().startsWith("com.huawei.gauss.jdbc")) {
            sqlType = 93;
        }
        return sqlType;
    }

    public Column(Map<String, Object> item, int index, char quot) {
        String name = D.s(item.get("COLUMN_NAME"));
        this.binding = (quot + name + quot).intern();
        this.name = name.toLowerCase().intern();
        this.index = index;
        this.nullable = D.x(item.get("IS_NULLABLE"));
        this.orginalSqlType = this.sqlType = D.i(item.get("DATA_TYPE"));
        this.precision = D.i(item.get("COLUMN_SIZE"));
        this.scale = D.i(item.get("DECIMAL_DIGITS"));
        this.remark = D.s(item.get("REMARKS"));
        this.init(D.s(item.get("TYPE_NAME")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(String type_name) {
        int dbType = this.sqlType;
        if (this.sqlType == 1111) {
            if ("NCLOB".equalsIgnoreCase(type_name)) {
                this.sqlType = 2005;
                dbType = 2011;
            } else if ("NVARCHAR2".equalsIgnoreCase(type_name)) {
                this.sqlType = 12;
                dbType = -9;
            } else if ("ROWID".equalsIgnoreCase(type_name)) {
                this.sqlType = -8;
                dbType = -2;
            } else {
                if (!"NCHAR".equalsIgnoreCase(type_name)) throw new UnsupportedOperationException(type_name);
                this.sqlType = 12;
                dbType = -15;
            }
        } else if (this.sqlType == 1 && "uniqueidentifier".equalsIgnoreCase(type_name)) {
            this.dataType = new StringType(36, false);
        }
        if (this.dataType == null) {
            this.dataType = DataTypeUtil.getDataType(dbType, this.precision, this.scale);
        }
        if (this.sqlType == 2005) {
            this.sqlType = 12;
            return;
        } else {
            if (this.sqlType != 2011) return;
            this.sqlType = -9;
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isPrimaryKey() {
        return this.pk;
    }

    void setPrimaryKey() {
        this.pk = true;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getOrginalSqlType() {
        return this.orginalSqlType;
    }

    public Object toSqlParam(Object value) {
        Object inner = this.dataType.narrow(value);
        return inner == null ? null : this.dataType.forSave(inner);
    }

    public String getRealName() {
        String a = this.alias2;
        if (a == null) {
            this.alias2 = a = this.binding.substring(1, this.binding.length() - 1);
        }
        return a;
    }

    public String getBinding() {
        return this.binding;
    }

    public String toString() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Object narrow(Object input) {
        return this.dataType.narrow(input);
    }

    public Object unwrap(Object value) {
        return this.dataType.forSave(value);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getRemark() {
        return this.remark;
    }
}

