/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.db;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.i.BinaryType;
import kd.isc.iscb.util.dt.i.BooleanType;
import kd.isc.iscb.util.dt.i.DateTimeType;
import kd.isc.iscb.util.dt.i.DateType;
import kd.isc.iscb.util.dt.i.DecimalType;
import kd.isc.iscb.util.dt.i.DoubleType;
import kd.isc.iscb.util.dt.i.FloatType;
import kd.isc.iscb.util.dt.i.IntegerType;
import kd.isc.iscb.util.dt.i.LongType;
import kd.isc.iscb.util.dt.i.StringType;
import kd.isc.iscb.util.dt.i.TimeType;
import kd.isc.iscb.util.dt.i.UnknownType;

public class DataTypeUtil {
    public static final BooleanType BOOLEAN_TYPE = new BooleanType();
    public static final UnknownType UNKNOWN_TYPE = new UnknownType();
    public static final LongType BIG_INT_TYPE = new LongType();
    public static final BinaryType BINARY_TYPE = new BinaryType(-1);
    public static final TimeType TIME_TYPE = new TimeType();
    public static final DateType DATE_TYPE = new DateType();
    public static final DateTimeType DATE_TIME_TYPE = new DateTimeType();
    public static final DecimalType DECIMAL_TYPE = new DecimalType(-1, -1);
    public static final IntegerType INTEGER_TYPE = new IntegerType();
    public static final DoubleType DOUBLE_TYPE = new DoubleType();
    public static final FloatType FLOAT_TYPE = new FloatType();
    public static final StringType UNICODE_STRING_TYPE = new StringType(-1, true);
    public static final StringType ANSI_STRING_TYPE = new StringType(-1, false);

    public static DataType getDataType(int type, int precision, int scale) {
        switch (type) {
            case 1: 
            case 12: {
                return new StringType(precision, false);
            }
            case -15: 
            case -9: {
                return new StringType(precision, true);
            }
            case -1: 
            case 2005: {
                return ANSI_STRING_TYPE;
            }
            case -16: 
            case 2011: {
                return UNICODE_STRING_TYPE;
            }
            case 4: {
                return INTEGER_TYPE;
            }
            case 2: 
            case 3: {
                return new DecimalType(precision, scale);
            }
            case 93: {
                return DATE_TIME_TYPE;
            }
            case 91: {
                return DATE_TYPE;
            }
            case 92: {
                return TIME_TYPE;
            }
            case -3: 
            case -2: {
                return new BinaryType(precision);
            }
            case -4: 
            case 2004: {
                return BINARY_TYPE;
            }
            case -5: {
                return BIG_INT_TYPE;
            }
            case 5: {
                return INTEGER_TYPE;
            }
            case -6: {
                return INTEGER_TYPE;
            }
            case 7: {
                return FLOAT_TYPE;
            }
            case 6: 
            case 8: {
                return DOUBLE_TYPE;
            }
            case -7: {
                return BOOLEAN_TYPE;
            }
        }
        return UNKNOWN_TYPE;
    }

    public static int getSqlType(Object value) {
        if (value instanceof Integer) {
            return 4;
        }
        if (value instanceof String) {
            return 12;
        }
        if (value instanceof Long) {
            return -5;
        }
        if (value instanceof BigDecimal) {
            return 3;
        }
        if (value instanceof Date) {
            return 93;
        }
        if (value instanceof byte[]) {
            return -3;
        }
        throw new IllegalArgumentException(value == null ? "null" : value + ":" + value.getClass().getName());
    }

    public static int getSqlType(String name) {
        if ("varchar".equals(name)) {
            return 12;
        }
        if ("char".equals(name)) {
            return 1;
        }
        if ("nvarchar".equals(name)) {
            return -9;
        }
        if ("nchar".equals(name)) {
            return -15;
        }
        if ("clob".equals(name)) {
            return 2005;
        }
        if ("nclob".equals(name)) {
            return 2011;
        }
        if ("int".equals(name)) {
            return 4;
        }
        if ("decimal".equals(name)) {
            return 3;
        }
        if ("datetime".equals(name)) {
            return 93;
        }
        if ("timestamp".equals(name)) {
            return 93;
        }
        if ("date".equals(name)) {
            return 91;
        }
        if ("time".equals(name)) {
            return 92;
        }
        if ("binary".equals(name)) {
            return -2;
        }
        if ("varbinary".equals(name)) {
            return -3;
        }
        if ("blob".equals(name)) {
            return 2004;
        }
        if ("bigint".equals(name)) {
            return -5;
        }
        if ("boolean".equals(name)) {
            return 16;
        }
        if ("bit".equals(name)) {
            return -7;
        }
        if ("float".equals(name)) {
            return 6;
        }
        if ("double".equals(name)) {
            return 8;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u6570\u636e\u7c7b\u578b\uff1a%s", (String)"DataTypeUtil_1", (String)"isc-iscb-util", (Object[])new Object[0]), name));
    }

    public static DataType getDataType(String name) {
        if ("varchar".equalsIgnoreCase(name)) {
            return ANSI_STRING_TYPE;
        }
        if ("char".equalsIgnoreCase(name)) {
            return ANSI_STRING_TYPE;
        }
        if ("nvarchar".equalsIgnoreCase(name)) {
            return UNICODE_STRING_TYPE;
        }
        if ("nchar".equalsIgnoreCase(name)) {
            return UNICODE_STRING_TYPE;
        }
        if ("string".equalsIgnoreCase(name)) {
            return UNICODE_STRING_TYPE;
        }
        if ("clob".equalsIgnoreCase(name)) {
            return ANSI_STRING_TYPE;
        }
        if ("nclob".equalsIgnoreCase(name)) {
            return UNICODE_STRING_TYPE;
        }
        if ("int".equalsIgnoreCase(name)) {
            return INTEGER_TYPE;
        }
        if ("integer".equalsIgnoreCase(name)) {
            return INTEGER_TYPE;
        }
        if ("decimal".equalsIgnoreCase(name)) {
            return DECIMAL_TYPE;
        }
        if ("datetime".equalsIgnoreCase(name)) {
            return DATE_TIME_TYPE;
        }
        if ("timestamp".equalsIgnoreCase(name)) {
            return DATE_TIME_TYPE;
        }
        if ("date".equalsIgnoreCase(name)) {
            return DATE_TYPE;
        }
        if ("time".equalsIgnoreCase(name)) {
            return TIME_TYPE;
        }
        if ("binary".equalsIgnoreCase(name)) {
            return BINARY_TYPE;
        }
        if ("varbinary".equalsIgnoreCase(name)) {
            return BINARY_TYPE;
        }
        if ("blob".equalsIgnoreCase(name)) {
            return BINARY_TYPE;
        }
        if ("bigint".equalsIgnoreCase(name)) {
            return BIG_INT_TYPE;
        }
        if ("long".equalsIgnoreCase(name)) {
            return BIG_INT_TYPE;
        }
        if ("boolean".equalsIgnoreCase(name)) {
            return BOOLEAN_TYPE;
        }
        if ("bit".equalsIgnoreCase(name)) {
            return BOOLEAN_TYPE;
        }
        if ("float".equalsIgnoreCase(name)) {
            return FLOAT_TYPE;
        }
        if ("double".equalsIgnoreCase(name)) {
            return DOUBLE_TYPE;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u6570\u636e\u7c7b\u578b\uff1a%s", (String)"DataTypeUtil_1", (String)"isc-iscb-util", (Object[])new Object[0]), name));
    }

    public static DataType getDataType(int type) {
        switch (type) {
            case 1: 
            case 12: {
                return ANSI_STRING_TYPE;
            }
            case -15: 
            case -9: {
                return UNICODE_STRING_TYPE;
            }
            case -1: 
            case 2005: {
                return ANSI_STRING_TYPE;
            }
            case -16: 
            case 2011: {
                return UNICODE_STRING_TYPE;
            }
            case 4: {
                return INTEGER_TYPE;
            }
            case 2: 
            case 3: {
                return DECIMAL_TYPE;
            }
            case 93: {
                return DATE_TIME_TYPE;
            }
            case 91: {
                return DATE_TYPE;
            }
            case 92: {
                return TIME_TYPE;
            }
            case -3: 
            case -2: {
                return BINARY_TYPE;
            }
            case -4: 
            case 2004: {
                return BINARY_TYPE;
            }
            case -5: {
                return BIG_INT_TYPE;
            }
            case 5: {
                return INTEGER_TYPE;
            }
            case -6: {
                return INTEGER_TYPE;
            }
            case 6: {
                return FLOAT_TYPE;
            }
            case 7: 
            case 8: {
                return DOUBLE_TYPE;
            }
            case -7: 
            case 16: {
                return BOOLEAN_TYPE;
            }
        }
        return UNKNOWN_TYPE;
    }
}

