/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.dt;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampUtil {
    public static Timestamp parse(String s) throws ParseException {
        String[] tokens = TimestampUtil.split(s);
        SimpleDateFormat format = new SimpleDateFormat(TimestampUtil.check(tokens, s));
        Timestamp ts = new Timestamp(format.parse(TimestampUtil.join(tokens)).getTime());
        TimestampUtil.parseNanos(ts, tokens);
        return ts;
    }

    private static void parseNanos(Timestamp ts, String[] tokens) {
        if (tokens[3] != null) {
            ts.setNanos(Integer.parseInt((tokens[3] + "000000000").substring(0, 9)));
        }
    }

    private static String join(String[] tokens) {
        StringBuilder sb = new StringBuilder();
        if (tokens[0] != null) {
            sb.append(tokens[0]);
        }
        if (tokens[1] != null) {
            sb.append(tokens[1]);
        }
        if (tokens[2] != null) {
            sb.append(tokens[2]);
        }
        if (tokens[4] != null) {
            sb.append(tokens[4]);
        }
        return sb.toString();
    }

    private static String check(String[] tokens, String s) {
        StringBuilder format = new StringBuilder();
        TimestampUtil.appendDateFormat(format, tokens, s);
        TimestampUtil.appendDateTimeSeperator(format, tokens, s);
        TimestampUtil.appendTimeFormat(format, tokens, s);
        TimestampUtil.appendTimeZoneFormat(format, tokens);
        return format.toString();
    }

    private static void appendTimeZoneFormat(StringBuilder format, String[] tokens) {
        String tz = tokens[4];
        if (tz == null) {
            return;
        }
        if ("Z".equals(tz)) {
            format.append("X");
        } else {
            char c = tz.charAt(0);
            if (c != '+' && c != '-') {
                format.append("z");
            } else if (tz.length() <= 3) {
                format.append("X");
            } else if (tz.indexOf(58) < 0) {
                format.append("Z");
            } else {
                format.append("XXX");
            }
        }
    }

    private static void appendDateTimeSeperator(StringBuilder format, String[] tokens, String s) {
        String x = tokens[1];
        if (x == null) {
            return;
        }
        char c = x.charAt(0);
        if (c == ' ') {
            format.append(" ");
        } else if (c == 'T') {
            format.append("'T'");
        } else {
            throw new IllegalArgumentException("'" + s + "'");
        }
    }

    private static void appendDateFormat(StringBuilder format, String[] tokens, String s) {
        String d = tokens[0];
        if (d == null) {
            return;
        }
        if (d.length() > 10) {
            throw new IllegalArgumentException("'" + s + "'");
        }
        if (d.indexOf(45) > 0) {
            format.append("yyyy-MM-dd");
        } else if (d.indexOf(47) > 0) {
            format.append("yyyy/MM/dd");
        } else if (d.indexOf(46) > 0) {
            format.append("yyyy.MM.dd");
        } else {
            if (!TimestampUtil.isInteger(d)) {
                throw new IllegalArgumentException("'" + s + "'");
            }
            if (d.length() == 8) {
                format.append("yyyyMMdd");
            } else if (d.length() == 6) {
                format.append("yyMMdd");
            } else if (d.length() == 4) {
                format.append("yyMM");
            } else {
                throw new IllegalArgumentException("'" + s + "'");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void appendTimeFormat(StringBuilder format, String[] tokens, String s) {
        String t = tokens[2];
        if (t == null) {
            return;
        }
        if (t.length() > 8) {
            throw new IllegalArgumentException("'" + s + "'");
        }
        int i = t.indexOf(58);
        if (i < 0) {
            if (!TimestampUtil.isInteger(t)) {
                throw new IllegalArgumentException("'" + s + "'");
            }
            if (t.length() == 6) {
                format.append("HHmmss");
                return;
            } else {
                if (t.length() != 4 || tokens[3] != null) throw new IllegalArgumentException("'" + s + "'");
                format.append("HHmm");
            }
            return;
        } else if (t.indexOf(58, i + 1) > i) {
            format.append("HH:mm:ss");
            return;
        } else {
            if (tokens[3] != null) throw new IllegalArgumentException("'" + s + "'");
            format.append("HH:mm");
        }
    }

    private static boolean isInteger(String t) {
        int j = t.length();
        for (int i = 0; i < j; ++i) {
            char c = t.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static String[] split(String s) {
        char c;
        int j;
        s = s.trim();
        String[] tokens = new String[5];
        int i = 0;
        for (j = i + 1; j < s.length(); ++j) {
            c = s.charAt(j);
            if (c == '-' || c == '/' || c == '.' || c >= '0' && c <= '9') continue;
            tokens[0] = s.substring(i, j);
            tokens[1] = s.substring(j, j + 1);
            i = j + 1;
            break;
        }
        if (tokens[0] == null) {
            tokens[0] = s;
            return tokens;
        }
        if (i == s.length()) {
            throw new IllegalArgumentException("'" + s + "'");
        }
        if (":".equals(tokens[1])) {
            tokens[0] = null;
            tokens[1] = null;
            i = 0;
        }
        for (j = i + 1; j < s.length(); ++j) {
            c = s.charAt(j);
            if (c == ':' || c >= '0' && c <= '9') continue;
            tokens[2] = s.substring(i, j);
            i = j;
            break;
        }
        if (tokens[2] == null) {
            tokens[2] = s.substring(i);
            return tokens;
        }
        if (s.charAt(i) != '.') {
            if (i < s.length()) {
                tokens[4] = s.substring(i).trim();
            }
            return tokens;
        }
        for (j = ++i; j < s.length(); ++j) {
            c = s.charAt(j);
            if (c >= '0' && c <= '9') continue;
            tokens[3] = s.substring(i, j);
            i = j;
            break;
        }
        if (tokens[3] == null) {
            if (i < s.length()) {
                tokens[3] = s.substring(i);
            }
            return tokens;
        }
        tokens[4] = s.substring(i).trim();
        return tokens;
    }

    public static String format(Date d, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        String s = df.format(d);
        if (d instanceof Timestamp) {
            Timestamp ts = (Timestamp)d;
            int i = s.indexOf(46, 15);
            if (i > 0 && ts.getNanos() % 1000000 > 0) {
                int j = TimestampUtil.findNonDigital(s, i + 1);
                StringBuilder sb = new StringBuilder();
                sb.append(s.substring(0, i));
                sb.append('.');
                String nanos = new DecimalFormat("000000000").format(ts.getNanos());
                int k = nanos.length() - 1;
                while (nanos.charAt(k) == '0') {
                    --k;
                }
                sb.append(nanos.substring(0, k + 1));
                if (j < s.length()) {
                    sb.append(s.substring(j));
                }
                return sb.toString();
            }
        }
        return s;
    }

    private static int findNonDigital(String s, int i) {
        char c;
        while (i < s.length() && (c = s.charAt(i)) >= '0' && c <= '9') {
            ++i;
        }
        return i;
    }
}

