/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.dt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.script.feature.op.compare.StrictEquals;

public final class TypedArray
implements List<Object> {
    public static final String SEPERATOR = ",";
    private DataType type;
    private ArrayList<Object> list;

    public TypedArray(DataType type) {
        this.type = type;
        this.list = new ArrayList();
    }

    public DataType getType() {
        return this.type;
    }

    public Object sum() {
        if (this.size() == 0) {
            return null;
        }
        Object first = this.findOne();
        if (first == null) {
            return null;
        }
        if (first instanceof Integer) {
            return this.sumi();
        }
        if (first instanceof Long) {
            return this.suml();
        }
        if (first instanceof BigDecimal) {
            return this.sumd();
        }
        return this.concat();
    }

    private Object findOne() {
        for (Object v : this.list) {
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public String concat() {
        return this.concat(SEPERATOR);
    }

    public String concat(String seperator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object o : this) {
            if (i++ > 0) {
                sb.append(seperator);
            }
            if (o == null) continue;
            sb.append(o);
        }
        return sb.toString();
    }

    public Object max() {
        if (this.size() == 0) {
            return null;
        }
        int i = 0;
        Comparable c = null;
        while (i < this.size() && (c = (Comparable)this.get(i++)) == null) {
        }
        while (i < this.size()) {
            Comparable o;
            if ((o = (Comparable)this.get(i++)) == null || o.compareTo(c) <= 0) continue;
            c = o;
        }
        return c;
    }

    public Object min() {
        if (this.size() == 0) {
            return null;
        }
        int i = 0;
        Comparable c = null;
        while (i < this.size() && (c = (Comparable)this.get(i++)) == null) {
        }
        while (i < this.size()) {
            Comparable o;
            if ((o = (Comparable)this.get(i++)) == null || o.compareTo(c) >= 0) continue;
            c = o;
        }
        return c;
    }

    public int count() {
        if (this.size() == 0) {
            return 0;
        }
        int i = 0;
        for (Object o : this) {
            if (o == null) continue;
            ++i;
        }
        return i;
    }

    public int count(Object o) {
        if (this.size() == 0) {
            return 0;
        }
        o = this.type.narrow(o);
        int i = 0;
        for (Object e : this) {
            if (e == null || !e.equals(o)) continue;
            ++i;
        }
        return i;
    }

    public boolean includes(Collection<?> c) {
        if (c == null) {
            return true;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean includes(Object[] c) {
        if (c == null) {
            return true;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean exists(Object o) {
        return this.contains(o);
    }

    private BigDecimal sumd() {
        BigDecimal sum = new BigDecimal(0);
        for (Object o : this) {
            if (o == null) continue;
            sum = sum.add((BigDecimal)o);
        }
        return sum;
    }

    private int sumi() {
        int sum = 0;
        for (Object o : this) {
            if (o == null) continue;
            sum += ((Integer)o).intValue();
        }
        return sum;
    }

    private long suml() {
        long sum = 0L;
        for (Object o : this) {
            if (o == null) continue;
            sum += ((Long)o).longValue();
        }
        return sum;
    }

    @Override
    public boolean add(Object o) {
        o = this.type.narrow(o);
        this.list.add(o);
        return true;
    }

    @Override
    public void add(int index, Object o) {
        o = this.type.narrow(o);
        this.list.add(index, o);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        for (Object object : c) {
            this.add(object);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        for (Object object : c) {
            this.add(index++, object);
        }
        return true;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        o = this.type.narrow(o);
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        o = this.type.narrow(o);
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        o = this.type.narrow(o);
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return Collections.unmodifiableList(this.list).listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return Collections.unmodifiableList(this.list).listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        o = this.type.narrow(o);
        return this.list.remove(o);
    }

    @Override
    public Object remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(this.type.narrow(o));
        }
        return this.list.retainAll(list);
    }

    @Override
    public Object set(int index, Object o) {
        o = this.type.narrow(o);
        return this.list.set(index, o);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<Object> subList(int from, int to) {
        return this.list.subList(from, to);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.list.toArray(array);
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != TypedArray.class) {
            return false;
        }
        TypedArray o = (TypedArray)obj;
        if (!this.type.equals(o.type)) {
            return false;
        }
        ArrayList<Object> lb = o.list;
        ArrayList<Object> la = this.list;
        if (la.size() != lb.size()) {
            return false;
        }
        for (int i = 0; i < lb.size(); ++i) {
            if (StrictEquals.equals(la.get(i), lb.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

