/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.arithmetic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.isc.iscb.util.flow.core.i.arithmetic.Edge;

class Vertex {
    private ArrayList<Edge> out = new ArrayList();
    private ArrayList<Edge> in = new ArrayList();
    private String _name;
    private int _id;
    private boolean end = true;
    private boolean start = true;
    private int distanceFromStart = Integer.MAX_VALUE;
    private int distanceToEnd = Integer.MAX_VALUE;

    public int getDistanceFromStart() {
        return this.distanceFromStart;
    }

    public int getDistanceToEnd() {
        return this.distanceToEnd;
    }

    public void setDistanceFromStart(int distanceFromStart) {
        this.distanceFromStart = distanceFromStart;
    }

    public void setDistanceToEnd(int distanceToEnd) {
        this.distanceToEnd = distanceToEnd;
    }

    boolean isEnd() {
        return this.end;
    }

    boolean isStart() {
        return this.start;
    }

    public Vertex(int id, String name) {
        this._name = name;
        this._id = id;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public String toString() {
        if (this.start) {
            return "^" + this._name + " -> " + this.out;
        }
        return this._name + " -> " + this.out;
    }

    void addInComing(Edge e) {
        this.in.add(e);
    }

    void addOutGoing(Edge e) {
        this.out.add(e);
    }

    List<Edge> inComing() {
        return Collections.unmodifiableList(this.in);
    }

    List<Edge> outGoing() {
        return Collections.unmodifiableList(this.out);
    }

    String name() {
        return this._name;
    }

    int id() {
        return this._id;
    }
}

