/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.c.trans;

import java.util.ArrayList;
import java.util.List;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.core.i.runtime.DataAreaImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;
import kd.isc.iscb.util.flow.core.i.runtime.RuntimeImpl;

public class DynamicChoice
extends Command {
    private static final String DYNAMIC_TARGETS = "DYNAMIC_TARGETS";
    public static final Command INS = new DynamicChoice();

    protected DynamicChoice() {
        super(19999999);
    }

    @Override
    public int invoke(ExecutionImpl e) {
        List<String> nodes = DynamicChoice.getDynamicTargets(e);
        if (nodes == null) {
            return 1;
        }
        DataAreaImpl mem = e.getMemory();
        ExecutionImpl parent = e.getParent();
        RuntimeImpl runtime = e.getRuntime();
        FlowImpl flow = e.getDefine().getFlow();
        for (String id : nodes) {
            NodeImpl target = flow.getNode(id);
            ExecutionImpl next = new ExecutionImpl(parent, target, mem);
            next.setPrior(e.getId(), e.getDefine().getId(), null);
            runtime.push(next);
        }
        return 20000001;
    }

    private static List<String> getDynamicTargets(ExecutionImpl e) {
        return (List)e.getProperty(DYNAMIC_TARGETS);
    }

    public static void setDynamicTargets(ExecutionImpl e, String[] nodes) {
        if (nodes == null || nodes.length == 0) {
            throw new NullPointerException("Not set nodes!");
        }
        DynamicChoice.verifyNodeIds(e, nodes);
        List<String> targets = DynamicChoice.array2list(nodes);
        List<String> original = DynamicChoice.getDynamicTargets(e);
        if (original == null) {
            e.setProperty(DYNAMIC_TARGETS, targets);
        } else {
            original.addAll(targets);
        }
    }

    private static List<String> array2list(String[] trans) {
        ArrayList<String> list = new ArrayList<String>(trans.length);
        for (String id : trans) {
            list.add(id);
        }
        return list;
    }

    private static void verifyNodeIds(ExecutionImpl e, String[] nodes) {
        FlowImpl flow = e.getDefine().getFlow();
        for (String id : nodes) {
            NodeImpl tran = flow.getNode(id);
            if (tran != null) continue;
            throw new IscBizException("Node '" + id + "' doesn't exist!");
        }
    }
}

