/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.runtime;

import java.util.Arrays;
import java.util.List;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.EnactmentService;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.c.composite.StartSubNodes4MultiInst;
import kd.isc.iscb.util.flow.core.i.c.trans.LazyChoice;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.core.i.runtime.DataAreaImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;
import kd.isc.iscb.util.flow.core.i.runtime.RuntimeImpl;

public class EnactmentServiceImpl
implements EnactmentService {
    private RuntimeImpl runtime;

    EnactmentServiceImpl(RuntimeImpl runtime) {
        this.runtime = runtime;
    }

    @Override
    public void appendChildrenInstances(String execution, Object ... values) {
        ExecutionImpl e = this.getExecution(execution);
        int index = e.getDefine().seekCommand(10000000);
        Command cmd = e.getDefine().getCommand(index);
        List<Object> array = Arrays.asList(values);
        if (!(cmd instanceof StartSubNodes4MultiInst)) {
            throw new IscBizException("(" + e + ") doesn't support multi-instance pattern!");
        }
        ((StartSubNodes4MultiInst)cmd).createChildrenAsMultiInst(e, array);
    }

    private ExecutionImpl getExecution(String execution) {
        ExecutionImpl e = this.runtime.getExecution(execution);
        if (e == null) {
            throw new IscBizException("Execution (" + execution + ") doesn't exist!");
        }
        return e;
    }

    @Override
    public void setDeferredChoice(String execution, String ... transitIds) {
        ExecutionImpl e = this.getExecution(execution);
        LazyChoice.setDeferredChoice(e, transitIds);
    }

    @Override
    public void jumpTo(String execution, String ... nodes) {
        ExecutionImpl from = this.getExecution(execution);
        NodeImpl[] targets = this.checkNodes(from, nodes);
        this.createExecutions(from, targets);
        from.terminate();
    }

    private void createExecutions(ExecutionImpl from, NodeImpl[] targets) {
        ExecutionImpl parent = from.getParent();
        DataAreaImpl mem = from.getMemory();
        for (NodeImpl tar : targets) {
            ExecutionImpl next = new ExecutionImpl(parent, tar, mem);
            next.setPrior(from.getId(), from.getDefine().getId(), null);
            this.runtime.push(next);
        }
    }

    private NodeImpl[] checkNodes(ExecutionImpl from, String ... nodes) {
        NodeImpl src = (NodeImpl)from.getDefine();
        if (src.getParent() == null) {
            throw new IscBizException("Can't jump from root node!");
        }
        if (from.getParent().getDefine() != src.getParent()) {
            throw new IscBizException("(" + from + ") wasn't started in its parent node!");
        }
        FlowImpl flow = src.getFlow();
        NodeImpl[] targets = new NodeImpl[nodes.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = flow.getNode(nodes[i]);
            if (src.getParent() == targets[i].getParent()) continue;
            throw new IscBizException("(" + src + ") and (" + targets[i] + ") don't exist in the same block!");
        }
        return targets;
    }
}

