/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class Json2 {
    public static String toString(Object obj) {
        StringBuilder json = new StringBuilder(1024);
        Json2.writeValue(json, 0, obj);
        return json.toString();
    }

    private static void writeMap(StringBuilder json, Map<String, Object> map, int level) {
        if (level > 0) {
            json.append("\r\n");
        }
        Json2.writeTab(json, level);
        json.append('{');
        json.append("\r\n");
        ++level;
        boolean first = true;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            first = Json2.writeSeperator(json, first, level);
            Json2.writeTab(json, level);
            Json.escape(D.s(e.getKey()), json);
            json.append(':');
            Json2.writeValue(json, level, e.getValue());
        }
        json.append("\r\n");
        Json2.writeTab(json, level - 1);
        json.append('}');
    }

    private static void writeValue(StringBuilder json, int level, Object value) {
        if (value instanceof List) {
            Json2.writeItems(json, value, level);
        } else if (value instanceof Map) {
            Json2.writeMap(json, (Map)value, level + 1);
        } else if (value instanceof Set) {
            Json2.writeSet(json, (Set)value, level + 1);
        } else {
            Json.toString(value, json, level);
        }
    }

    private static void writeSet(StringBuilder json, Set<?> value, int level) {
        if (level > 0) {
            json.append("\r\n");
        }
        boolean first = true;
        Json2.writeTab(json, level);
        json.append("[\r\n");
        for (Object o : value) {
            first = Json2.writeSeperator(json, first, level);
            Json2.writeTab(json, level + 1);
            Json.toString(o, json, level);
        }
        json.append("\r\n");
        Json2.writeTab(json, level);
        json.append(']');
    }

    private static void writeItems(StringBuilder json, Object value, int level) {
        boolean first = true;
        ++level;
        json.append("[\r\n");
        for (Object o : (Collection)value) {
            first = Json2.writeSeperator(json, first, level);
            if (o instanceof Map) {
                Json2.writeMap(json, (Map)o, level);
                continue;
            }
            Json2.writeTab(json, level);
            Json2.writeValue(json, level, o);
        }
        json.append("\r\n");
        Json2.writeTab(json, level - 1);
        json.append(']');
    }

    private static boolean writeSeperator(StringBuilder json, boolean first, int level) {
        if (first) {
            first = false;
        } else {
            json.append(",\r\n");
        }
        return first;
    }

    private static void writeTab(StringBuilder json, int level) {
        for (int i = 0; i < level; ++i) {
            json.append('\t');
        }
    }
}

