/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.misc.Pair;

public class Rsa {
    public static String encrypt(String data, String privateKey) {
        byte[] bytes = Rsa.encrypt(data.getBytes(D.UTF_8), privateKey);
        byte[] base64 = Base64.encode(bytes);
        return new String(base64, D.UTF_8);
    }

    public static String decrypt(String base64, String publicKey) {
        byte[] bytes = Base64.decode(base64.getBytes(D.UTF_8));
        return new String(Rsa.decrypt(bytes, publicKey), D.UTF_8);
    }

    public static byte[] encrypt(byte[] data, String privateKey) {
        String[] tmp = privateKey.split(",");
        BigInteger n = new BigInteger(tmp[0]);
        BigInteger e = new BigInteger(tmp[1]);
        BigInteger x = new BigInteger(data);
        return x.modPow(e, n).toByteArray();
    }

    public static byte[] decrypt(byte[] data, String publicKey) {
        return Rsa.encrypt(data, publicKey);
    }

    public static Pair<String, String> generateKey(int bitCount) {
        KeyPair kp = Rsa.generateKeyPair(bitCount);
        RSAPublicKey puk = (RSAPublicKey)kp.getPublic();
        RSAPrivateCrtKey prk = (RSAPrivateCrtKey)kp.getPrivate();
        BigInteger e = puk.getPublicExponent();
        BigInteger n = puk.getModulus();
        BigInteger d = prk.getPrivateExponent();
        String pe = n + "," + d;
        String pd = n + "," + e;
        return new Pair<String, String>(pe, pd);
    }

    private static KeyPair generateKeyPair(int bitCount) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(bitCount);
            KeyPair kp = kpg.generateKeyPair();
            return kp;
        }
        catch (NoSuchAlgorithmException e) {
            throw D.e(e);
        }
    }
}

