/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.analyzer.expr;

import java.util.Map;
import javax.script.ScriptException;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.analyzer.expr.MapConstructor;
import kd.isc.iscb.util.script.core.Operator;
import kd.isc.iscb.util.script.core.Statement;

public class ColonOperator {
    public static int process(LifeScriptEngine engine, Map<String, Object> context, Statement statement, Object[] elements, int len) throws ScriptException {
        if (!ColonOperator.hasColon(statement, elements, len)) {
            return len;
        }
        int p = 0;
        for (int i = 0; i < len; ++i) {
            Object el = elements[i];
            if (el != Operator.COLON) continue;
            Object key = ColonOperator.getElement(elements, i - 1);
            Object value = ColonOperator.getElement(elements, i + 1);
            elements[p++] = new Object[]{key, value};
        }
        Object[][] entries = new Object[p][];
        for (int i = 0; i < p; ++i) {
            entries[i] = (Object[])elements[i];
        }
        elements[0] = new MapConstructor(entries, statement.line());
        return 1;
    }

    public static Object getElement(Object[] elements, int i) throws ScriptException {
        Object el = elements[i];
        if (el == Operator.COMMA) {
            el = null;
        } else if (el == Operator.COLON) {
            throw new ScriptException("Colons duplicated!");
        }
        return el;
    }

    private static boolean hasColon(Statement statement, Object[] elements, int len) {
        for (int i = 0; i < len; ++i) {
            if (elements[i] != Operator.COLON) continue;
            return true;
        }
        return false;
    }
}

