/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.analyzer.expr;

import java.util.Map;
import javax.script.ScriptException;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.analyzer.ConstructorAnalyzer;
import kd.isc.iscb.util.script.analyzer.expr.ConstructorProxy;
import kd.isc.iscb.util.script.analyzer.expr.ListConstructor;
import kd.isc.iscb.util.script.analyzer.expr.MapConstructor;
import kd.isc.iscb.util.script.analyzer.expr.Util;
import kd.isc.iscb.util.script.core.AccessorByFilter;
import kd.isc.iscb.util.script.core.AccessorByIndex;
import kd.isc.iscb.util.script.core.AccessorByName;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.ToolKit;
import kd.isc.iscb.util.script.feature.control.stream.Filter;
import kd.isc.iscb.util.script.statement.Arguments;
import kd.isc.iscb.util.script.statement.Block;
import kd.isc.iscb.util.script.statement.Invocation;

public class MemberAccess {
    static int process(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int length, Statement smt) throws ScriptException {
        if (length < 2) {
            return length;
        }
        int p = 0;
        int i = 1;
        while (i < length) {
            Object current = elements[i];
            Object prior = Util.getPriorElement(elements, p);
            if (current instanceof AccessorByName) {
                i = MemberAccess.processMemberAccessor(engine, context, elements, p, i, (AccessorByName)current, prior, smt);
                continue;
            }
            if (current instanceof ListConstructor) {
                p = MemberAccess.processIndexAccessor(engine, context, elements, p, current, prior, smt);
                ++i;
                continue;
            }
            if (MemberAccess.isFilter(current, prior)) {
                p = MemberAccess.processFilterAccessor(engine, context, elements, p, current, prior, smt);
                ++i;
                continue;
            }
            if (current instanceof Arguments) {
                Arguments s = (Arguments)current;
                p = MemberAccess.processInvocationWithArgs(engine, context, elements, p, s, prior, smt);
                ++i;
                continue;
            }
            if (Util.isOperand(current)) {
                p = MemberAccess.processInvocationWithOneArg(engine, context, elements, p, current, prior, smt);
                ++i;
                continue;
            }
            elements[++p] = current;
            ++i;
        }
        return p + 1;
    }

    private static int processFilterAccessor(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int p, Object current, Object container, Statement smt) throws ScriptException {
        if (container instanceof Constructor) {
            Object[] args = new Object[]{container, current};
            elements[p] = ConstructorAnalyzer.INS.analyze(new Invocation(engine, context, args, smt.line()));
        } else {
            AccessorByFilter accessor = (AccessorByFilter)engine.get("{}");
            elements[p] = accessor.create(container, current, smt);
        }
        return p;
    }

    private static boolean isFilter(Object current, Object prior) {
        if (!Util.isOperand(prior)) {
            return false;
        }
        return current instanceof MapConstructor || current instanceof Block;
    }

    private static int processInvocationWithArgs(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int p, Arguments params, Object prior, Statement smt) throws ScriptException {
        if (Util.isOperand(prior)) {
            Object[] args = new Object[params.length() + 1];
            args[0] = prior;
            int i = 0;
            for (int j = 1; j < args.length; ++j) {
                args[j] = params.get(i);
                ++i;
            }
            elements[p] = prior instanceof Constructor ? ConstructorAnalyzer.INS.analyze(new Invocation(engine, context, args, smt.line())) : new Invocation(engine, context, args, smt.line());
        } else {
            elements[++p] = params;
        }
        return p;
    }

    private static int processInvocationWithOneArg(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int p, Object current, Object prior, Statement smt) throws ScriptException {
        if (Util.isOperand(prior)) {
            elements[p] = prior instanceof Constructor ? ConstructorAnalyzer.INS.analyze(new Invocation(engine, context, new Object[]{prior, current}, smt.line())) : new Invocation(engine, context, new Object[]{prior, current}, smt.line());
        } else {
            elements[++p] = current;
        }
        return p;
    }

    private static int processIndexAccessor(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int p, Object index, Object stub, Statement smt) throws ScriptException {
        if (Util.isOperand(stub)) {
            AccessorByIndex accessor = (AccessorByIndex)engine.get("[]");
            ListConstructor lc = (ListConstructor)index;
            elements[p] = lc.isPredicate() ? Filter.createFilter(stub, lc.get(0)) : accessor.create(stub, lc, smt);
        } else {
            elements[++p] = index;
        }
        return p;
    }

    private static int processMemberAccessor(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int p, int i, AccessorByName accessor, Object stub, Statement smt) throws ScriptException {
        Object id = elements[i + 1];
        if (id instanceof Constructor && !(stub instanceof ToolKit)) {
            elements[p] = new ConstructorProxy(stub, (Constructor)id, accessor, smt);
        } else {
            String name = id instanceof Identifier ? ((Identifier)id).name() : id.toString();
            elements[p] = accessor.create(stub, name, smt);
        }
        return i += 2;
    }
}

