/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.decision;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.script.ScriptContext;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.feature.control.advanced.DebugTrap;
import kd.isc.iscb.util.script.feature.control.advanced.Debuggable;

abstract class DebuggableSwitch
implements Debuggable {
    private final List<Pair<Object, Object>> items;
    private final DebugTrap trap;

    protected DebuggableSwitch(List<Pair<Object, Object>> items, int line) {
        this.trap = new DebugTrap(this.getClass().getSimpleName(), line);
        this.items = Collections.unmodifiableList(items);
    }

    protected final List<Pair<Object, Object>> getItems(ScriptContext ctx) {
        this.trap.get(ctx);
        return this.items;
    }

    @Override
    public final boolean attachBreakpoint(int line) {
        if (this.trap.attachBreakpoint(line)) {
            return true;
        }
        for (Pair<Object, Object> item : this.items) {
            Object k = item.getKey();
            if (k instanceof Debuggable && ((Debuggable)k).attachBreakpoint(line)) {
                return true;
            }
            Object v = item.getValue();
            if (!(v instanceof Debuggable) || !((Debuggable)v).attachBreakpoint(line)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void detachBreakpoint(int line) {
        this.trap.detachBreakpoint(line);
        for (Pair<Object, Object> item : this.items) {
            Object v;
            Object k = item.getKey();
            if (k instanceof Debuggable) {
                ((Debuggable)k).detachBreakpoint(line);
            }
            if (!((v = item.getValue()) instanceof Debuggable)) continue;
            ((Debuggable)v).detachBreakpoint(line);
        }
    }

    @Override
    public final void collectBreakpoints(Set<Integer> breakpoints) {
        this.trap.collectBreakpoints(breakpoints);
        for (Pair<Object, Object> item : this.items) {
            Object v;
            Object k = item.getKey();
            if (k instanceof Debuggable) {
                ((Debuggable)k).collectBreakpoints(breakpoints);
            }
            if (!((v = item.getValue()) instanceof Debuggable)) continue;
            ((Debuggable)v).collectBreakpoints(breakpoints);
        }
    }

    @Override
    public int line() {
        return this.trap.line();
    }
}

