/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.decision;

import javax.script.ScriptException;
import kd.isc.iscb.util.script.core.Analyzer;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.feature.control.decision.Decision;
import kd.isc.iscb.util.script.feature.control.decision.Else;

public class IfElseAnalyzer
implements Analyzer {
    public static final Analyzer INS = new IfElseAnalyzer();

    private IfElseAnalyzer() {
    }

    @Override
    public Object analyze(Statement statement) throws ScriptException {
        if (this.hasElse(statement)) {
            return this.processElse(statement);
        }
        return statement;
    }

    private Object processElse(Statement statement) throws ScriptException {
        Object[] wa = new Object[statement.length()];
        int p = this.joinElse(statement, wa);
        Object[] buffer = new Object[wa.length - p];
        System.arraycopy(wa, p, buffer, 0, buffer.length);
        return statement.reconstruct(buffer);
    }

    private int joinElse(Statement statement, Object[] wa) throws ScriptException {
        int p = wa.length;
        int i = wa.length - 1;
        while (i >= 0) {
            Object el = statement.get(i);
            if (this.isElseStatement(el)) {
                Object falseBody = ((Statement)el).get(1);
                Decision decision = this.getDecision(statement, i);
                decision.set(falseBody);
                el = decision;
                i -= 2;
                --p;
            } else if (el == Else.KEYWORD) {
                Decision decision = this.getDecision(statement, i);
                decision.set(wa[p]);
                el = decision;
                i -= 2;
            } else {
                --p;
                --i;
            }
            wa[p] = el;
        }
        return p;
    }

    private Decision getDecision(Statement statement, int i) throws ScriptException {
        Object tmp = statement.get(i - 1);
        if (tmp instanceof Statement) {
            tmp = ((Statement)tmp).analyze();
        }
        if (tmp instanceof Decision) {
            return (Decision)tmp;
        }
        throw new ScriptException(tmp + " is not if statement!");
    }

    private boolean hasElse(Statement statement) {
        for (int i = 1; i < statement.length(); ++i) {
            Object el = statement.get(i);
            if (!this.isElseStatement(el) && el != Else.KEYWORD) continue;
            return true;
        }
        return false;
    }

    private boolean isElseStatement(Object el) {
        if (!(el instanceof Statement)) {
            return false;
        }
        Statement s = (Statement)el;
        if (s.length() == 0) {
            return false;
        }
        return s.get(0) == Else.KEYWORD;
    }

    @Override
    public int priority() {
        return -1;
    }
}

