/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.loop;

import javax.script.ScriptException;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.analyzer.expr.ListConstructor;
import kd.isc.iscb.util.script.analyzer.expr.MapConstructor;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.LiteralBuilder;
import kd.isc.iscb.util.script.core.NotExpression;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.StatementBuilder;
import kd.isc.iscb.util.script.core.StatementEnd;
import kd.isc.iscb.util.script.core.StatementStart;
import kd.isc.iscb.util.script.feature.control.loop.For;
import kd.isc.iscb.util.script.feature.control.loop.Visit;
import kd.isc.iscb.util.script.feature.control.loop.it.ForEachImpl;

public class ForEach
implements Constructor,
StatementStart,
StatementEnd,
NotExpression {
    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "foreach";
    }

    @Override
    public StatementBuilder getStatementBuilder() {
        return null;
    }

    @Override
    public LiteralBuilder getLiteralBuilder() {
        return null;
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        return ForEach.parse(statement, pos);
    }

    static Object parse(Statement statement, Constructor.Position pos) throws ScriptException {
        Object body;
        MapConstructor map = (MapConstructor)Util.getElement(statement, pos, 0);
        if (map.getKey(0) instanceof ListConstructor) {
            return Visit.analyze(statement, pos);
        }
        String[] params = ForEach.getParams(map);
        Object iterateable = map.getValue(0);
        Object next = null;
        if (statement.length() > 2) {
            Object tmp = pos.getOperand(statement, 1);
            body = For.createBody(statement, pos, tmp);
            next = For.handleNextStatement(statement, pos, tmp);
        } else {
            body = null;
        }
        Evaluator eva = ForEach.createEvaluator(params, iterateable, body, statement.line());
        return For.handleReturns(statement, next, eva);
    }

    private static String[] getParams(MapConstructor map) {
        Object key = Util.unwrap(map.getKey(0));
        if (!(key instanceof Statement)) {
            return new String[]{((Identifier)key).name()};
        }
        Statement args = (Statement)key;
        String[] params = new String[args.length()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = ((Identifier)args.get(i)).name();
        }
        return params;
    }

    private static Evaluator createEvaluator(String[] params, Object iterateable, Object body, int line) {
        return new ForEachImpl(body, line, iterateable, params);
    }
}

