/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.loop.it;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.LifeScriptContext;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.feature.control.advanced.DebuggableContainer;
import kd.isc.iscb.util.script.feature.control.loop.it.ArrayIterator;
import kd.isc.iscb.util.script.feature.control.loop.it.CharSequenceIterator;
import kd.isc.iscb.util.script.feature.control.loop.it.IteratorIterator;
import kd.isc.iscb.util.script.feature.control.loop.it.MapIterator;

public final class ForEachImpl
extends DebuggableContainer
implements Evaluator {
    private final Object iterateable;
    private final String[] params;

    public ForEachImpl(Object body, int line, Object iterateable, String[] params) {
        super(body, line);
        this.iterateable = iterateable;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(ScriptContext ctx) {
        Iterator<Object[]> it = this.getIterator(ctx, this.iterateable);
        if (it == null || !it.hasNext()) {
            return null;
        }
        Object[] bak = Util.backup(ctx, this.params);
        try {
            Object object = this.executeLoop(this.params, (LifeScriptContext)ctx, it);
            return object;
        }
        finally {
            Util.restore(ctx, this.params, bak);
        }
    }

    private Object executeLoop(String[] params, LifeScriptContext ctx, Iterator<Object[]> it) {
        Object value = null;
        while (it.hasNext()) {
            ctx.checkTimeout();
            Object[] args = it.next();
            Util.restore(ctx, params, args);
            value = Util.eval(ctx, this.getBody(ctx));
            if (!Util.takeBreak(ctx)) continue;
            break;
        }
        return value;
    }

    private Iterator<Object[]> getIterator(ScriptContext ctx, Object iterateable) {
        Object c = Util.eval(ctx, iterateable);
        if (c == null) {
            return null;
        }
        if (c instanceof Collection) {
            Collection c0 = (Collection)c;
            return new IteratorIterator(c0.iterator(), c0.size());
        }
        if (c instanceof Map) {
            return new MapIterator((Map)c);
        }
        if (c instanceof Iterator) {
            return new IteratorIterator((Iterator)c, null);
        }
        if (c.getClass().isArray()) {
            return new ArrayIterator(c);
        }
        if (c instanceof CharSequence) {
            return new CharSequenceIterator((CharSequence)c);
        }
        if (c instanceof Iterable) {
            return new IteratorIterator(((Iterable)c).iterator(), null);
        }
        throw new UnsupportedOperationException(c.getClass().getName() + ":" + c);
    }

    public String toString() {
        return "foreach";
    }
}

