/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.stream;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.script.LifeScriptContext;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.accessor.PathAccessor;
import kd.isc.iscb.util.script.analyzer.expr.ConstructorProxy;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Statement;

public class Filter
implements Constructor {
    @Override
    public String name() {
        return "filter";
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        Object expr;
        Object stub;
        if (statement.get(0) instanceof ConstructorProxy) {
            stub = pos.getOperand(statement, 1);
            expr = pos.getOperand(statement, 0);
        } else {
            stub = pos.getOperand(statement, 0);
            expr = pos.getOperand(statement, 1);
        }
        return Filter.createFilter(stub, expr);
    }

    public static Object createFilter(final Object stub, final Object expr) {
        return new Evaluator(){

            @Override
            public Object eval(ScriptContext ctx) {
                Object c = Util.eval(ctx, stub);
                if (c == null) {
                    return null;
                }
                if (c instanceof Map) {
                    return this.filterMap(ctx, (Map)c, expr);
                }
                if (c instanceof Set) {
                    return this.filterSet(ctx, (Set)c, expr);
                }
                if (c instanceof Iterable) {
                    return this.filterIterable(ctx, (Iterable)c, expr);
                }
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"%1$s \u7684\u5b9e\u9645\u7c7b\u578b\u662f\uff1a%2$s", (String)"Filter_1", (String)"isc-iscb-util", (Object[])new Object[0]), stub, c.getClass().getName()));
            }

            private Object filterIterable(ScriptContext ctx, Iterable<?> c, Object expr2) {
                ArrayList result = new ArrayList();
                int index = -1;
                for (Object e : c) {
                    if (!this.isMatched(ctx, e, expr2, ++index)) continue;
                    result.add(e);
                }
                return result;
            }

            private Object filterSet(ScriptContext ctx, Set<?> c, Object expr2) {
                LinkedHashSet result = new LinkedHashSet();
                for (Object e : c) {
                    if (!this.isMatched(ctx, e, expr2)) continue;
                    result.add(e);
                }
                return result;
            }

            private boolean isMatched(ScriptContext ctx, Object e, Object expr2, int index) {
                LifeScriptContext current = PathAccessor.createScriptContext(ctx, e, ctx, "$index", index);
                Object value = Util.eval(current, expr2);
                return Util.objectToBoolean(value);
            }

            private boolean isMatched(ScriptContext ctx, Object e, Object expr2) {
                LifeScriptContext current = PathAccessor.createScriptContext(ctx, e, ctx, new Object[0]);
                Object value = Util.eval(current, expr2);
                return Util.objectToBoolean(value);
            }

            private Object filterMap(ScriptContext ctx, Map<?, ?> c, Object expr2) {
                LinkedHashMap result = new LinkedHashMap();
                for (Map.Entry<?, ?> e : c.entrySet()) {
                    if (!this.isMatched(ctx, e, expr2)) continue;
                    result.put(e.getKey(), e.getValue());
                }
                return result;
            }
        };
    }
}

