/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.data;

import java.util.BitSet;
import javax.script.ScriptContext;
import kd.isc.iscb.util.io.ObjectWriter;
import kd.isc.iscb.util.script.core.Filter;
import kd.isc.iscb.util.script.core.NativeFunction;

public class BloomBuilder
implements NativeFunction {
    private static final Hash[] fn = new Hash[]{new HashA1(1), new HashA1(2), new HashB1(3), new HashA2(3, 1), new HashA2(3, 2), new HashA1(4), new HashA2(4, 1), new HashB2(4, 3), new HashB1(5), new HashA2(5, 2), new HashA2(5, 3), new HashB2(5, 4)};
    private static final String NULL = "2039A35F-5D1B-413E-8FE6-E924A6D06BB8";

    @Override
    public String name() {
        return "bloom";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object v = args[0];
        if (v instanceof Number) {
            int maxSize = ((Number)v).intValue();
            return new BloomFilter(maxSize);
        }
        throw new IllegalArgumentException(v.toString());
    }

    private static class HashB2
    extends AbstractHash {
        private int shift1;
        private int shift2;

        private HashB2(int shift1, int shift2) {
            this.shift1 = shift2;
            this.shift1 = shift2;
        }

        @Override
        public int calc(String s) {
            int result = 1;
            int shift1 = this.shift1;
            int shift2 = this.shift2;
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                result = (result << shift1) + (result << shift2) - result + s.charAt(i);
            }
            return result;
        }
    }

    private static class HashB1
    extends AbstractHash {
        private int shift;

        private HashB1(int shift) {
            this.shift = shift;
        }

        @Override
        public int calc(String s) {
            int result = 1;
            int shift = this.shift;
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                result = (result << shift) - result + s.charAt(i);
            }
            return result;
        }
    }

    private static class HashA2
    extends AbstractHash {
        private int shift1;
        private int shift2;

        private HashA2(int shift1, int shift2) {
            this.shift1 = shift2;
            this.shift1 = shift2;
        }

        @Override
        public int calc(String s) {
            int result = 1;
            int shift1 = this.shift1;
            int shift2 = this.shift2;
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                result = (result << shift1) + (result << shift2) + result + s.charAt(i);
            }
            return result;
        }
    }

    private static class HashA1
    extends AbstractHash {
        private int shift;

        private HashA1(int shift) {
            this.shift = shift;
        }

        @Override
        public int calc(String s) {
            int result = 1;
            int shift = this.shift;
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                result = (result << shift) + result + s.charAt(i);
            }
            return result;
        }
    }

    private static abstract class AbstractHash
    implements Hash {
        private AbstractHash() {
        }

        @Override
        public int calc(Object value, int cap) {
            int result = 0;
            result = value == null ? this.calc(BloomBuilder.NULL) : this.calc(value.toString());
            return result & cap;
        }

        abstract int calc(String var1);
    }

    private static interface Hash {
        public int calc(Object var1, int var2);
    }

    public static class BloomFilter
    implements ObjectWriter<Object>,
    Filter {
        private BitSet bits;
        private int cap;

        public BloomFilter(int maxSize) {
            this.cap = 1;
            while (this.cap < maxSize) {
                this.cap <<= 1;
            }
            this.cap *= 32;
            this.bits = new BitSet(this.cap);
            --this.cap;
        }

        public BloomFilter(BitSet bits, int cap) {
            this.bits = bits;
            this.cap = cap;
        }

        public BitSet getBits() {
            return (BitSet)this.bits.clone();
        }

        public int getCap() {
            return this.cap;
        }

        @Override
        public boolean contains(Object value) {
            boolean b = true;
            for (Hash f : fn) {
                b = b && this.bits.get(f.calc(value, this.cap));
            }
            return b;
        }

        public String toString() {
            return this.bits.toString();
        }

        @Override
        public void write(Object o) {
            for (Hash f : fn) {
                this.bits.set(f.calc(o, this.cap), true);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void commit() {
        }

        @Override
        public boolean rollback(Throwable cause) {
            return false;
        }
    }
}

