/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.date;

import javax.script.ScriptContext;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.core.Negatable;

public final class TimeSpan
implements NativeFunction,
Negatable,
Comparable<TimeSpan> {
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;

    public TimeSpan(int years, int months, int days) {
        this.years = years;
        this.months = months;
        this.days = days;
    }

    public TimeSpan(int hours, int minutes, int seconds, int milliseconds) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
    }

    public TimeSpan(int years, int months, int days, int hours, int minutes, int seconds, int milliseconds) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    @Override
    public String name() {
        return "<anonymous>";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        for (Object span : args) {
            this.addBy((TimeSpan)span);
        }
        return this;
    }

    private void addBy(TimeSpan span) {
        this.days += span.days;
        this.hours += span.hours;
        this.milliseconds += span.milliseconds;
        this.minutes += span.minutes;
        this.months += span.months;
        this.seconds += span.seconds;
        this.years += span.years;
    }

    @Override
    public TimeSpan negate() {
        return new TimeSpan(-this.years, -this.months, -this.days, -this.hours, -this.minutes, -this.seconds, -this.milliseconds);
    }

    public String toString() {
        return this.years + "-" + this.months + "-" + this.days + " " + this.hours + ":" + this.minutes + ":" + this.seconds + "." + this.milliseconds;
    }

    public static TimeSpan add(TimeSpan a, TimeSpan b) {
        TimeSpan v = new TimeSpan(a.years + b.years, a.months + b.months, a.days + b.days, a.hours + b.hours, a.minutes + b.minutes, a.seconds + b.seconds, a.milliseconds + b.milliseconds);
        return v;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.days;
        result = 31 * result + this.hours;
        result = 31 * result + this.milliseconds;
        result = 31 * result + this.minutes;
        result = 31 * result + this.months;
        result = 31 * result + this.seconds;
        result = 31 * result + this.years;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSpan other = (TimeSpan)obj;
        if (this.days != other.days) {
            return false;
        }
        if (this.hours != other.hours) {
            return false;
        }
        if (this.milliseconds != other.milliseconds) {
            return false;
        }
        if (this.minutes != other.minutes) {
            return false;
        }
        if (this.months != other.months) {
            return false;
        }
        if (this.seconds != other.seconds) {
            return false;
        }
        return this.years == other.years;
    }

    @Override
    public int compareTo(TimeSpan o) {
        if (o == null) {
            return 1;
        }
        long a = this.years;
        a = a * 365L + (long)this.months;
        a = a * 30L + (long)this.days;
        a = a * 24L + (long)this.hours;
        a = a * 60L + (long)this.minutes;
        a = a * 60L + (long)this.seconds;
        a = a * 60L + (long)this.milliseconds;
        long b = o.years;
        b = b * 365L + (long)o.months;
        b = b * 30L + (long)o.days;
        b = b * 24L + (long)o.hours;
        b = b * 60L + (long)o.minutes;
        b = b * 60L + (long)o.seconds;
        if (a < (b = b * 60L + (long)o.milliseconds)) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }
}

