/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.hash;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.script.core.NativeFunction;

public class HMAC_SHA1
implements NativeFunction {
    private static final String ALGO_HMAC_SHA1 = "HmacSHA1";
    private static final char[] DIGITAL = "0123456789ABCDEF".toCharArray();

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object value = args[0];
        Object key = args[1];
        if (value == null || key == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3anull\u503c", (String)"HMAC_SHA1_0", (String)"isc-iscb-util", (Object[])new Object[0]));
        }
        Mac mac = this.getMacInstance();
        this.initMac(key, mac);
        this.update(value, mac);
        return this.toHexString(mac.doFinal());
    }

    private void initMac(Object key, Mac mac) {
        SecretKeySpec signingKey = new SecretKeySpec(key.toString().getBytes(D.UTF_8), ALGO_HMAC_SHA1);
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw CommonError.INVALID_HASH_INIT_KEY.wrap(e);
        }
    }

    private Mac getMacInstance() {
        try {
            return Mac.getInstance(ALGO_HMAC_SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            throw CommonError.NO_SUCH_HASH_ALGO.create(e, ALGO_HMAC_SHA1);
        }
    }

    private void update(Object value, Mac mac) {
        if (value instanceof Object[]) {
            for (Object s : (Object[])value) {
                mac.update(s.toString().getBytes(D.UTF_8));
            }
        } else if (value instanceof List) {
            for (Object s : (List)value) {
                mac.update(s.toString().getBytes(D.UTF_8));
            }
        } else {
            mac.update(value.toString().getBytes(D.UTF_8));
        }
    }

    private String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] result = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            result[i * 2] = DIGITAL[(bytes[i] & 0xF0) >> 4];
            result[i * 2 + 1] = DIGITAL[bytes[i] & 0xF];
        }
        return new String(result);
    }

    @Override
    public String name() {
        return "HMAC_SHA1";
    }
}

