/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.hash;

import java.security.KeyFactory;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.script.core.NativeFunction;

public class RSA_SHA256
implements NativeFunction {
    public static final String UTF_8 = "UTF-8";
    public static final String SHA_256_WITH_RSA = "SHA256withRSA";
    public static final String RSA = "RSA";

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        String str = D.s(args[0]);
        String secretKey = D.s(args[1]);
        if (str == null || secretKey == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3anull\u503c", (String)"RSA_SHA256_0", (String)"isc-iscb-util", (Object[])new Object[0]));
        }
        try {
            return RSA_SHA256.signSHA256RSA(str, secretKey);
        }
        catch (Exception e) {
            throw CommonError.INVALID_HASH_INIT_KEY.wrap(e);
        }
    }

    private static String signSHA256RSA(String input, String secretKey) throws Exception {
        String realPK = secretKey.replaceAll("-----END PRIVATE KEY-----", "").replaceAll("-----BEGIN PRIVATE KEY-----", "").replaceAll("-----END RSA PRIVATE KEY-----", "").replaceAll("-----BEGIN RSA PRIVATE KEY-----", "").replaceAll("\n", "");
        byte[] b1 = Base64.decode(realPK.getBytes(UTF_8));
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(b1);
        KeyFactory kf = KeyFactory.getInstance(RSA);
        Signature privateSignature = Signature.getInstance(SHA_256_WITH_RSA);
        privateSignature.initSign(kf.generatePrivate(spec));
        privateSignature.update(input.getBytes(UTF_8));
        byte[] s = privateSignature.sign();
        return new String(Base64.encode(s), UTF_8);
    }

    @Override
    public String name() {
        return "RSA_SHA256";
    }
}

