/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.number;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.core.NativeFunction;

public class FormatMoney
implements NativeFunction {
    @Override
    public String name() {
        return "$";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Number n = (Number)args[0];
        if (args.length == 1) {
            return FormatMoney.calc(n);
        }
        int scale = ((Number)args[1]).intValue();
        return FormatMoney.calc(n, scale);
    }

    public static String calc(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof BigDecimal) {
            int scale = ((BigDecimal)n).scale();
            DecimalFormat fm = new DecimalFormat(FormatMoney.getFormat(scale));
            return fm.format(n);
        }
        DecimalFormat fm = new DecimalFormat("#,##0.00");
        return fm.format(n);
    }

    public static String calc(Number n, int scale) {
        if (n == null) {
            return null;
        }
        if (n instanceof BigDecimal) {
            DecimalFormat fm = new DecimalFormat(FormatMoney.getFormat(scale));
            return fm.format(n);
        }
        DecimalFormat fm = new DecimalFormat("#,##0.00");
        return fm.format(n);
    }

    public static String getFormat(BigDecimal n) {
        return FormatMoney.getFormat(n.scale());
    }

    public static String getFormat(int scale) {
        switch (scale) {
            case 0: {
                return "#,##0";
            }
            case 1: {
                return "#,##0.0";
            }
            case 2: {
                return "#,##0.00";
            }
            case 3: {
                return "#,##0.000";
            }
            case 4: {
                return "#,##0.0000";
            }
            case 5: {
                return "#,##0.00000";
            }
            case 6: {
                return "#,##0.000000";
            }
            case 7: {
                return "#,##0.0000000";
            }
            case 8: {
                return "#,##0.00000000";
            }
            case 9: {
                return "#,##0.000000000";
            }
        }
        return "#,##0.00";
    }
}

