/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.number;

import java.math.BigDecimal;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.core.NativeFunction;

public class Split
implements NativeFunction {
    @Override
    public String name() {
        return "split";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Number value = (Number)args[0];
        int count = ((Number)args[1]).intValue();
        if (count <= 1) {
            return new Object[]{value};
        }
        if (value == null) {
            return new Object[count];
        }
        if (value instanceof Integer) {
            return this.split(((Integer)value).intValue(), count);
        }
        if (value instanceof Long) {
            return this.split((Long)value, count);
        }
        if (value instanceof BigDecimal) {
            return this.split((BigDecimal)value, count);
        }
        throw new UnsupportedOperationException("Can't split " + value.getClass() + " value.");
    }

    private Object split(BigDecimal value, int count) {
        BigDecimal scale = new BigDecimal((int)Math.pow(10.0, value.scale()));
        Object[] tmp = this.split(value.multiply(scale).longValue(), count);
        for (int i = 0; i < count; ++i) {
            tmp[i] = new BigDecimal((Long)tmp[i]).divide(scale);
        }
        return tmp;
    }

    private Object[] split(long value, int count) {
        int i;
        boolean isNegative;
        boolean bl = isNegative = value < 0L;
        if (isNegative) {
            value = -value;
        }
        long avg = value / (long)count;
        int rem = (int)(value % (long)count);
        Object[] array = new Object[count];
        for (i = 0; i < rem; ++i) {
            array[i] = avg + 1L;
        }
        for (i = rem; i < count; ++i) {
            array[i] = avg;
        }
        if (isNegative) {
            for (i = 0; i < array.length; ++i) {
                array[i] = -((Long)array[i]).longValue();
            }
        }
        return array;
    }
}

