/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.string;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.script.ScriptContext;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.script.core.NativeFunction;

public class URLDecode
implements NativeFunction {
    private static final String UTF_8 = "UTF-8";

    @Override
    public String name() {
        return "URLDecode";
    }

    @Override
    public final String call(ScriptContext ctx, Object[] args) {
        if (args.length == 1) {
            Object o = args[0];
            if (o == null) {
                return null;
            }
            String s = o.toString();
            try {
                return URLDecoder.decode(s, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw CommonError.INVALID_CHARSET.create(e, UTF_8);
            }
        }
        if (args.length == 2) {
            Object o = args[0];
            if (o == null) {
                return null;
            }
            String s = o.toString();
            String charset = (String)args[1];
            try {
                return URLDecoder.decode(s, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw CommonError.INVALID_CHARSET.create(e, charset);
            }
        }
        throw new IllegalArgumentException("args.length is " + args.length);
    }
}

