/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.HttpConnectionDecorator;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.misc.CookieUtil;
import kd.isc.iscb.util.script.misc.HttpHeaderUtil;
import kd.isc.iscb.util.script.misc.HttpUtil;

public class HttpDownloadFile
implements NativeFunction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        String url = D.s(args[0]);
        String method = D.s(args[1]);
        String data = HttpUtil.xFormEncode(args[2]);
        String charset = args[3] == null ? Charset.defaultCharset().name() : (String)args[3];
        Map<String, Object> cookies = CookieUtil.copyCookies(args, 4);
        Map<String, Object> headers = HttpHeaderUtil.copyHeaders(args, 5);
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(cookies, headers);
        byte[] bs = this.getData(data, charset);
        String contentType = D.s(headers.get("Content-Type"));
        InputStream in = NetUtil.httpAccess(url, method, bs, contentType, decorator, NetUtil.TIMEOUT);
        try {
            Object object = this.readFileContent(in, url, decorator);
            return object;
        }
        finally {
            DbUtil.close(in);
        }
    }

    private Object readFileContent(InputStream in, String url, HttpConnectionDecorator decorator) {
        long MAX_FILE_SIZE = D.l((Object)System.getProperty("ISC_MAX_FILE_SIZE"));
        if (MAX_FILE_SIZE <= 0L) {
            MAX_FILE_SIZE = 0x1400000L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String fileName = this.parseFileName(decorator.getHeader(), url);
            HttpDownloadFile.copyStream(in, baos, MAX_FILE_SIZE);
            Map<String, Object> re = this.compositeResult(baos.toByteArray(), fileName);
            Object object = HttpUtil.compositeReturns(decorator.getResponseCode(), decorator.getCookies(), decorator.getHeader(), re);
            return object;
        }
        catch (IOException e) {
            throw D.e(e);
        }
        finally {
            DbUtil.close(baos);
        }
    }

    private byte[] getData(String data, String charset) {
        try {
            byte[] bs = data == null ? null : data.getBytes(charset);
            return bs;
        }
        catch (IOException e) {
            throw D.e(e);
        }
    }

    public static void copyStream(InputStream in, ByteArrayOutputStream out) throws IOException {
        long MAX_FILE_SIZE;
        String size = System.getProperty("ISC_MAX_FILE_SIZE");
        if (size == null) {
            size = System.getenv("ISC_MAX_FILE_SIZE");
        }
        if ((MAX_FILE_SIZE = D.l((Object)size)) <= 0L) {
            MAX_FILE_SIZE = 0x500000L;
        }
        HttpDownloadFile.copyStream(in, out, MAX_FILE_SIZE);
    }

    public static void copyStream(InputStream in, ByteArrayOutputStream out, long maxFileSize) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        int count = 0;
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
            if ((long)(count += len) <= maxFileSize) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff0c\u6700\u5927\u53ef\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\u4e3a%s\u5b57\u8282\uff0c\u53ef\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u4fee\u6539JVM\u7cfb\u7edf\u53c2\u6570ISC_MAX_FILE_SIZE\u7684\u503c\uff08\u5355\u4f4d\uff1a\u5b57\u8282\uff09\uff0c\u4ee5\u8c03\u6574\u6700\u5927\u9650\u5236\u3002", (String)"HttpDownloadFile_3", (String)"isc-iscb-util", (Object[])new Object[0]), maxFileSize));
        }
    }

    private Map<String, Object> compositeResult(byte[] data, String fileName) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("data", data);
        result.put("filename", fileName);
        return result;
    }

    @Override
    public String name() {
        return "HttpDownloadFile";
    }

    private String parseFileName(Map<String, Object> header, String url) throws UnsupportedEncodingException {
        String disposition;
        int pos;
        Object obj = header.get("Content-Disposition");
        if (obj == null) {
            int i = url.indexOf(63);
            if (i > -1) {
                int j = url.lastIndexOf(47, i);
                if (j > -1) {
                    return url.substring(j + 1, i);
                }
                return null;
            }
            int j = url.lastIndexOf(47);
            if (j > -1) {
                return url.substring(j + 1);
            }
            return null;
        }
        if (obj instanceof List) {
            obj = ((List)obj).get(0);
        }
        if ((pos = (disposition = D.s(obj)).indexOf("filename*")) > -1) {
            String filename_ = disposition.substring(pos + 10);
            int sp = filename_.indexOf("''");
            String charset = filename_.substring(0, sp);
            String name = filename_.substring(sp + 2);
            return URLDecoder.decode(name, charset);
        }
        return disposition.substring(pos + 9);
    }
}

