/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.core.BlockEnd;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.feature.op.arith.Add;
import kd.isc.iscb.util.script.feature.op.arith.Subtract;
import kd.isc.iscb.util.script.parser.Null;
import kd.isc.iscb.util.script.statement.Invocation;
import kd.isc.iscb.util.script.util.Numeric;

class JsonParser {
    JsonParser() {
    }

    static Object eval(Object el) {
        if (el == Null.KEYWORD) {
            return null;
        }
        if (el instanceof String) {
            return el;
        }
        if (el instanceof Number) {
            return el;
        }
        if (el instanceof Boolean) {
            return el;
        }
        if (el instanceof Identifier) {
            return ((Identifier)el).name();
        }
        if (el instanceof Statement) {
            Statement b = (Statement)el;
            Identifier terminator = b.terminator();
            if (terminator == BlockEnd.LIST) {
                return JsonParser.evalList(b);
            }
            if (terminator == BlockEnd.PROGRAM) {
                return JsonParser.evalSingle(b);
            }
            if (terminator == BlockEnd.BLOCK) {
                return JsonParser.evalMap(b);
            }
            return JsonParser.evalAny(b);
        }
        throw new UnsupportedOperationException(el.getClass().getName());
    }

    private static Object evalAny(Statement s) {
        int length = s.length();
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return JsonParser.eval(s.get(0));
        }
        if (length == 2) {
            if (s.get(0) == Subtract.INS) {
                return Numeric.negate((Number)s.get(1));
            }
            if (s.get(0) == Add.INS) {
                return (Number)s.get(1);
            }
        }
        throw new IllegalArgumentException(s.toString());
    }

    private static Object evalSingle(Statement s) {
        int length = s.length();
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return JsonParser.eval(s.get(0));
        }
        throw new IllegalArgumentException(s.toString());
    }

    private static Object evalMap(Statement b) {
        if (b.length() == 0) {
            return new HashMap(1);
        }
        if (b.length() > 1) {
            throw new IscBizException(ResManager.loadKDString((String)"JSON\u8bed\u6cd5\u5206\u6790\u5668\u9519\u8bef", (String)"JsonParser_0", (String)"isc-iscb-util", (Object[])new Object[0]));
        }
        b = (Invocation)b.get(0);
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(b.length() >> 1);
        for (int i = 0; i < b.length(); i += 4) {
            Object value;
            Object key = JsonParser.eval(b.get(i));
            Object el = b.get(i + 2);
            if (el != Subtract.INS) {
                value = JsonParser.eval(el);
            } else {
                Number n = (Number)JsonParser.eval(b.get(i + 3));
                value = Numeric.negate(n);
                ++i;
            }
            map.put(key, value);
        }
        return map;
    }

    private static Object evalList(Statement b) {
        if (b.length() == 0) {
            return new ArrayList(0);
        }
        if (b.length() > 1) {
            throw new IscBizException(ResManager.loadKDString((String)"JSON\u8bed\u6cd5\u5206\u6790\u5668\u9519\u8bef", (String)"JsonParser_0", (String)"isc-iscb-util", (Object[])new Object[0]));
        }
        Object e = b.get(0);
        if (e instanceof Invocation) {
            b = (Statement)e;
            ArrayList<Object> list = new ArrayList<Object>(b.length() >> 1);
            for (int i = 0; i < b.length(); i += 2) {
                Object value;
                Object o = b.get(i);
                if (o instanceof Subtract) {
                    value = Subtract.negate(JsonParser.eval(b.get(++i)));
                    list.add(value);
                    continue;
                }
                value = JsonParser.eval(o);
                list.add(value);
            }
            return list;
        }
        ArrayList<Object> a = new ArrayList<Object>();
        a.add(JsonParser.eval(e));
        return a;
    }
}

