/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.statement;

import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.Locator;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.core.Storer;
import kd.isc.iscb.util.script.misc.Consts;
import kd.isc.iscb.util.script.statement.AbstractStatement;

public final class Invocation
extends AbstractStatement
implements Evaluator,
Storer {
    public Invocation(LifeScriptEngine engine, Map<String, Object> ctx, int line, int column, Identifier terminator, List<Object> elements, boolean isBlock) {
        super(engine, ctx, line, column, terminator, elements, isBlock);
    }

    public Invocation(LifeScriptEngine engine, Map<String, Object> ctx, Object[] elements, int line) {
        super(engine, ctx, elements, line);
    }

    @Override
    public AbstractStatement clone(Object[] analyzed) {
        return new Invocation(this.engine, this.ctx, analyzed, this.line());
    }

    @Override
    public Object eval(ScriptContext ctx) {
        super.checkBreakpoint(ctx);
        if (this.length() == 0) {
            return null;
        }
        Object fn = Util.eval(ctx, super.get(0));
        if (fn instanceof NativeFunction) {
            return Invocation.call(ctx, (NativeFunction)fn, this);
        }
        throw Invocation.createError(fn, super.get(0), this.line());
    }

    public static UnsupportedOperationException createError(Object fn, Object el, int line) {
        if (fn == null) {
            String message = String.format(ResManager.loadKDString((String)"\u51fd\u6570 '%1$s' \u5728\u5f53\u524d\u73af\u5883\u4e2d\u4e0d\u5b58\u5728, \u884c\u53f7: %2$s", (String)"Invocation_3", (String)"isc-iscb-util", (Object[])new Object[0]), el, line);
            return new UnsupportedOperationException(message);
        }
        String message = String.format(ResManager.loadKDString((String)"'%1$s' \u4e0d\u662f\u51fd\u6570, \u884c\u53f7: %2$s", (String)"Invocation_4", (String)"isc-iscb-util", (Object[])new Object[0]), el, line);
        return new UnsupportedOperationException(message);
    }

    public static Object call(ScriptContext ctx, NativeFunction fn, Invocation iv) {
        Object[] args = Invocation.prepare(ctx, iv);
        return fn.call(ctx, args);
    }

    private static Object[] prepare(ScriptContext ctx, Invocation iv) {
        int len = iv.length();
        if (len == 1) {
            return Consts.EMPTY_OBJ_ARRAY;
        }
        Object[] args = new Object[len - 1];
        Object result = null;
        for (int i = 1; i < len; ++i) {
            Object el = iv.get(i);
            args[i - 1] = result = Util.eval(ctx, el);
        }
        return args;
    }

    @Override
    public String toString() {
        if (this.elements.length == 0) {
            return "()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Invocation.toString(this.elements[0]));
        sb.append('(');
        int j = this.elements.length;
        for (int i = 1; i < j; ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(Invocation.toString(this.elements[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Object set(ScriptContext ctx, Object value) {
        super.checkBreakpoint(ctx);
        Object loc = Util.eval(ctx, super.get(0));
        if (!(loc instanceof Locator)) {
            throw new UnsupportedOperationException("the first element '" + super.get(0) + "' is not a Locator.");
        }
        Object[] args = Invocation.prepare(ctx, this);
        Storer ref = ((Locator)loc).loc(ctx, args);
        return ref.set(ctx, value);
    }
}

