/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.ApiInfo;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.dt.D;

public class ApiEventTriggerUtil {
    private static final String API_TRIGGER_META = "isc_call_api_by_evt";

    public static void attachEvents(DynamicObject apiEventTrigger) {
        String s = D.s((Object)apiEventTrigger.get("events"));
        String[] events = s == null ? new String[]{} : s.split(",");
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)apiEventTrigger.getLong("metaschema_id"), (String)"isc_metadata_schema");
        String entity = meta.getString("full_name");
        long apiEventTriggerId = apiEventTrigger.getLong("id");
        long dataSourceId = meta.getLong("group_id");
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
        Map<String, Object> requires = ApiEventTriggerUtil.initRequiresMap(apiEventTrigger);
        try (ConnectionWrapper cn = ConnectionManager.getConnection((Long)dataSource.get("dblink_id"));){
            String iscHub = ConnectorUtil.getIscHub(cn.getConfig());
            cn.getFactory().attachEvents(cn, iscHub, EventBindingUtil.TriggerType.APITrigger, apiEventTriggerId, entity, events, requires);
        }
    }

    public static Map<String, Object> initRequiresMap(DynamicObject apiEventTrigger) {
        DynamicObjectCollection selectorEntry = apiEventTrigger.getDynamicObjectCollection("selectors");
        LinkedHashMap<String, Object> requires = new LinkedHashMap<String, Object>(selectorEntry.size());
        for (DynamicObject selector : selectorEntry) {
            String field = D.s((Object)selector.get("field"));
            if (field == null) continue;
            if (field.indexOf(46) < 0) {
                requires.put(field, 1);
                continue;
            }
            String[] path = field.split("\\.");
            SQLUtil.addEntryProperty(requires, path);
        }
        return requires;
    }

    public static void detachEvents(DynamicObject apiEventTrigger) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)apiEventTrigger.getLong("metaschema_id"), (String)"isc_metadata_schema");
        String entity = meta.getString("full_name");
        long dataSourceId = meta.getLong("group_id");
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
        long apiEventTriggerId = apiEventTrigger.getLong("id");
        try (ConnectionWrapper cn = ConnectionManager.getConnection((Long)dataSource.get("dblink_id"));){
            String iscHub = ConnectorUtil.getIscHub(cn.getConfig());
            cn.getFactory().detachEvents(cn, iscHub, EventBindingUtil.TriggerType.APITrigger, apiEventTriggerId, entity);
        }
    }

    public static Object invoke(long apiTriggerId, Object data) {
        DynamicObject apiByEvt = BusinessDataServiceHelper.loadSingle((Object)apiTriggerId, (String)API_TRIGGER_META);
        ApiInfo apiInfo = ApiEventTriggerUtil.getApiInfo(apiByEvt);
        return apiInfo.invoke(data);
    }

    private static ApiInfo getApiInfo(DynamicObject apiByEvt) {
        String apiType = apiByEvt.getString("api_type");
        long apiId = apiByEvt.getLong("api_id");
        long callerId = apiByEvt.getLong("caller_id");
        String scriptStr = D.s((Object)apiByEvt.get("format_script_tag"));
        if (scriptStr == null) {
            scriptStr = D.s((Object)apiByEvt.get("format_script"));
        }
        return new ApiInfo(apiType, apiId, callerId, scriptStr);
    }

    private static List<Map<String, Object>> dataAsList(Object data) {
        ArrayList<Map<String, Object>> dataList;
        if (data instanceof Map) {
            dataList = new ArrayList<Map>(1);
            dataList.add((Map)data);
        } else if (data instanceof List) {
            dataList = (List)data;
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\u3002data = %s", (String)"ApiEventTriggerUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), data));
        }
        return dataList;
    }
}

