/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import com.alibaba.fastjson.JSON;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.api.TimerParam;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.startjob.CronJobUtil;
import kd.isc.iscb.platform.core.task.ApiTimerTask;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.platform.core.util.TimerJobUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import org.quartz.CronExpression;

public class ApiTimerTriggerUtil {
    private static final String ENTITY_SCH_TASKDEFINE = "sch_taskdefine";
    private static final String PARAM_API_TRIGGER_ID = "apiTriggerId";
    private static final String ENTITY_SCH_JOB = "sch_job";
    private static final String ENTITY_SCH_SCHEDULE = "sch_schedule";
    private static final String FIELD_NUMBER = "number";
    private static final String NUMPREFIX = "iscb-api-";

    public static void checkCron(String cron) {
        if (cron == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u89e6\u53d1\u95f4\u9694\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"ApiTimerTriggerUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try {
            ApiTimerTriggerUtil.getParser().parse(cron);
            new CronExpression(cron);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u8ba1\u5212(cron\u8868\u8fbe\u5f0f:%s)\u4e0d\u5408\u6cd5,\u8bf7\u68c0\u67e5\u662f\u5426\u7f16\u5199\u6b63\u786e\u3002", (String)"ApiTimerTriggerUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cron), (Throwable)e);
        }
    }

    private static ScheduleManager getScheduleManager() {
        return (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
    }

    private static CronParser getParser() {
        return new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    }

    public static void enableTrigger(String apiTrigger, String name, String exeJobUser, TimerParam timerParam) {
        ApiTimerTriggerUtil.checkCron(timerParam.getCron());
        ApiTimerTriggerUtil.disableTrigger(apiTrigger);
        if (CronJobUtil.isIscScheduleEnable()) {
            ApiTimerTriggerUtil.createScheduleJobByIsc(apiTrigger, name, exeJobUser, timerParam);
        } else {
            DynamicObject job = ApiTimerTriggerUtil.createJob(apiTrigger, name, exeJobUser);
            DynamicObject schedule = ApiTimerTriggerUtil.createSchedule(apiTrigger, (String)job.getPkValue(), name, timerParam);
            ApiTimerTriggerUtil.getScheduleManager().enableJob((String)job.getPkValue());
            ApiTimerTriggerUtil.getScheduleManager().enableSchedule((String)schedule.getPkValue());
        }
    }

    private static void createScheduleJobByIsc(String apiTrigger, String name, String exeJobUser, TimerParam timerParam) {
        long id = D.l((Object)TimerJobUtil.getUserIdByNumber(exeJobUser));
        if (id > 0L) {
            CronJobUtil.enable("isc_call_api_by_timer", timerParam.getCron(), timerParam.getStart(), timerParam.getEnd(), D.l((Object)apiTrigger), name, id);
        } else {
            CronJobUtil.enable("isc_call_api_by_timer", timerParam.getCron(), timerParam.getStart(), timerParam.getEnd(), D.l((Object)apiTrigger), name, D.l((Object)RequestContext.get().getUserId()));
        }
    }

    public static void disableTrigger(String apiTrigger) {
        CronJobUtil.disable(D.l((Object)apiTrigger));
        ApiTimerTriggerUtil.disableSchedule(apiTrigger);
    }

    private static void disableSchedule(String apiTrigger) {
        DynamicObject job;
        String number = ApiTimerTriggerUtil.getNumber(ApiTimerTriggerUtil.getMd5Id(apiTrigger));
        QFilter[] qfs = QFilterUtil.builder().put(FIELD_NUMBER, "=", number).build();
        DynamicObject schedule = BusinessDataServiceHelper.loadSingle((String)ENTITY_SCH_SCHEDULE, (String)"id", (QFilter[])qfs);
        if (schedule != null) {
            schedule.set("name", (Object)ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u7531\u96c6\u6210\u4e91\u540e\u53f0\u521b\u5efa\uff0c\u6b64\u4efb\u52a1\u5df2\u5e9f\u5f03\uff0c\u4e25\u7981\u542f\u7528\uff0c\u8bf7\u4eba\u5de5\u5220\u9664\u3002", (String)"ApiTimerTriggerUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            ExecutionData.execute(schedule, "save", CommonUtil.getSkipPermissionOption());
            ApiTimerTriggerUtil.getScheduleManager().disableSchedule((String)schedule.getPkValue());
        }
        if ((job = BusinessDataServiceHelper.loadSingle((String)ENTITY_SCH_JOB, (String)"id", (QFilter[])qfs)) != null) {
            ApiTimerTriggerUtil.getScheduleManager().disableJob((String)job.getPkValue());
        }
    }

    public static DynamicObject createSchedule(String apiTriggerId, String jobId, String name, TimerParam timerParam) {
        String id = ApiTimerTriggerUtil.getMd5Id(apiTriggerId);
        DynamicObject obj = DataCopyTaskUtil.getExistedObject(ENTITY_SCH_SCHEDULE, id);
        obj.set(FIELD_NUMBER, (Object)ApiTimerTriggerUtil.getNumber(id));
        obj.set("job", (Object)jobId);
        obj.set("starttime", (Object)timerParam.getStart());
        obj.set("endtime", (Object)timerParam.getEnd());
        obj.set("plan", (Object)timerParam.getCron());
        obj.set("txtdesc", (Object)ResManager.loadKDString((String)"\u6b64\u8c03\u5ea6\u8ba1\u5212\u7531\u96c6\u6210\u4e91API\u8c03\u5ea6\u65b9\u6848\u81ea\u52a8\u751f\u6210", (String)"ApiTimerTriggerUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        obj.set("status", (Object)"1");
        obj.set("repeatmode", (Object)"def");
        obj.set("combdorw", (Object)"d");
        obj.set("name", (Object)name);
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        return obj;
    }

    public static DynamicObject createJob(String apiTriggerId, String name, String exeJobUser) {
        String id = ApiTimerTriggerUtil.getMd5Id(apiTriggerId);
        DynamicObject obj = DataCopyTaskUtil.getExistedObject(ENTITY_SCH_JOB, id);
        ApiTimerTriggerUtil.addBaseInfo(apiTriggerId, ApiTimerTriggerUtil.getNumber(id), name, obj, exeJobUser);
        ApiTimerTriggerUtil.addParamEntry(apiTriggerId, obj);
        ExecutionData.execute(obj, "save", CommonUtil.getSkipPermissionOption());
        return obj;
    }

    private static String getNumber(String id) {
        return NUMPREFIX + id;
    }

    private static String getMd5Id(String apiTriggerId) {
        return String.valueOf(Hash.md5i64((byte[])apiTriggerId.getBytes(StandardCharsets.UTF_8)));
    }

    private static void addBaseInfo(String apiTriggerId, String number, String name, DynamicObject obj, String exeJobUser) {
        obj.set(FIELD_NUMBER, (Object)number);
        obj.set("name", (Object)name);
        obj.set("jobtype", (Object)"BIZ");
        obj.set("taskclassname", (Object)ApiTimerTriggerUtil.createDefine("ISC_API_TIMER_TASK"));
        obj.set("classname", (Object)ApiTimerTask.class.getName());
        TimerJobUtil.setRunJobUser(exeJobUser, obj);
        obj.set("status", (Object)1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_API_TRIGGER_ID, apiTriggerId);
        obj.set("params", (Object)JSON.toJSONString(params));
    }

    private static String createDefine(String number) {
        QFilter filter = new QFilter(FIELD_NUMBER, "=", (Object)number);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)ENTITY_SCH_TASKDEFINE, (String)"id", (QFilter[])new QFilter[]{filter});
        if (task != null) {
            return (String)task.getPkValue();
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_SCH_TASKDEFINE);
        obj.set("id", (Object)Hash.mur2base64((Object[])new Object[]{UUID.randomUUID()}));
        obj.set(FIELD_NUMBER, (Object)number);
        obj.set("name", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u670d\u52a1\u7f16\u6392\u5b9a\u65f6\u542f\u52a8\u4efb\u52a1", (String)"ApiTimerTriggerUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        obj.set("classname", (Object)ApiTimerTask.class.getName());
        obj.set("appid", (Object)"iscb");
        DynamicObjectCollection params = obj.getDynamicObjectCollection("paramentry");
        DynamicObject param = new DynamicObject(params.getDynamicObjectType());
        param.set("paramname", (Object)PARAM_API_TRIGGER_ID);
        param.set("paramtype", (Object)"1");
        params.add((Object)param);
        CommonUtil.check(OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_SCH_TASKDEFINE, (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create()));
        return (String)obj.getPkValue();
    }

    private static void addParamEntry(String apiTriggerId, DynamicObject obj) {
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
        entries.clear();
        DynamicObject param = new DynamicObject(entries.getDynamicObjectType());
        param.set("paramname", (Object)PARAM_API_TRIGGER_ID);
        param.set("paramvalue", (Object)apiTriggerId);
        entries.add((Object)param);
    }
}

