/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.orm.util.Assert;
import kd.isc.iscb.platform.core.api.ApiClassify;
import kd.isc.iscb.platform.core.api.IscApiResult;
import kd.isc.iscb.platform.core.apic.ScriptApiMeta;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.trace.TraceTask;

public class CommonApiDispatcher
implements IBillWebApiPlugin {
    private static final String CALLER = "caller";

    public ApiResult doCustomService(final WebApiContext ctx) {
        return (ApiResult)TraceStack.trace(Caller.OpenAPI, new TraceTask(){

            public Object invoke() {
                return CommonApiDispatcher.this.callIscApi(ctx);
            }
        });
    }

    public ApiResult doMicroService(final WebApiContext ctx) {
        return (ApiResult)TraceStack.trace(Caller.MicroSVC, new TraceTask(){

            public Object invoke() {
                return CommonApiDispatcher.this.callIscApi(ctx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResult callIscApi(WebApiContext ctx) {
        ApiResult apiResult;
        String prefixNumber = ctx.getRequestURL().substring(ctx.getRequestURL().lastIndexOf(47) + 1);
        Assert.isTrue((boolean)prefixNumber.contains("_"), (String)String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u8bf7\u6c42URL: %s", (String)"CommonApiDispatcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ctx.getRequestURL()));
        String prefix = prefixNumber.substring(0, prefixNumber.indexOf(95));
        String apiNumber = prefixNumber.substring(prefixNumber.indexOf(95) + 1);
        Map query = ctx.getQueryString();
        String caller = D.s(query.get(CALLER));
        HashMap<String, Object> data = ctx.getData();
        if (data == null) {
            data = new HashMap<String, Object>(16);
        }
        ScriptApiMeta.setWebContext(ctx);
        try {
            apiResult = ApiClassify.valueOf(prefix.toUpperCase()).handle(apiNumber, caller, data);
        }
        catch (Throwable throwable) {
            try {
                ScriptApiMeta.removeWebContext();
                throw throwable;
            }
            catch (Exception e) {
                return IscApiResult.ex(e);
            }
        }
        ScriptApiMeta.removeWebContext();
        return apiResult;
    }

    public String getVersion() {
        return "1.1";
    }
}

