/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.CheckApiParamUtil;
import kd.isc.iscb.platform.core.api.IscApiResult;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.dc.DataCopyOpenApi;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.trace.TraceUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.trace.TraceTask;

public class DcTriggerApiDispatcher
implements IBillWebApiPlugin {
    private static final Log LOG = LogFactory.getLog(DcTriggerApiDispatcher.class);
    private static final String API_NUMBER = "apiNumber";
    private static final String EXECUTION_TYPE = "execution_type";
    private static final String CALLER = "caller";
    public static final String DC_TRIGGER_API_DISPATCHER = "/app/iscb/DcTriggerApiDispatcher";

    public ApiResult doCustomService(WebApiContext ctx) {
        HashMap<String, Object> data = ctx.getData();
        HashMap query = ctx.getQueryString();
        if (data == null) {
            data = new HashMap<String, Object>(1);
        }
        if (query == null) {
            query = new HashMap(1);
        }
        String caller = D.s(query.get(CALLER));
        String apiNumber = D.s(query.get(API_NUMBER));
        return DcTriggerApiDispatcher.handle(apiNumber, caller, data);
    }

    public static ApiResult handle(String apiNumber, final String caller, final Map<String, Object> data) {
        ApiResult permResult = UserPermissionUtil.checkAPIPermByParam("isc_apic_by_dc_trigger", "4TAR7QONT/3J");
        if (!permResult.getSuccess()) {
            return permResult;
        }
        Assert.notNull((Object)apiNumber, (String)String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"DcTriggerApiDispatcher_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), API_NUMBER));
        final DynamicObject apiId = BusinessDataServiceHelper.loadSingle((String)"isc_apic_by_dc_trigger", (String)"id, auth_required", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)apiNumber)});
        Assert.notNull((Object)apiId, (String)String.format(ResManager.loadKDString((String)"%s \u542f\u52a8\u65b9\u6848API\u4e0d\u5b58\u5728", (String)"DcTriggerApiDispatcher_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), apiNumber));
        final DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)apiId.get("id"), (String)"isc_apic_by_dc_trigger");
        Assert.isTrue((boolean)"1".equals(api.get("enable")), (String)String.format(ResManager.loadKDString((String)"%s \u542f\u52a8\u65b9\u6848API\u5df2\u7981\u7528\uff0c\u7981\u6b62\u8bbf\u95ee", (String)"DcTriggerApiDispatcher_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), apiNumber));
        DynamicObject log = null;
        try {
            log = IscApicUtil.invokeBegin(api, "isc_apic_by_dc_trigger", caller, data);
            Object returnData = log == null ? TraceStack.run(TraceType.EXE_APIF, "isc_apic_by_dc_trigger/" + apiNumber, api.getLong("id"), new TraceTask(){

                public Object invoke() {
                    return DcTriggerApiDispatcher.invokeApi(caller, data, apiId, api);
                }
            }) : TraceStack.run(TraceType.EXE_APIL, log, new TraceTask(){

                public Object invoke() {
                    return DcTriggerApiDispatcher.invokeApi(caller, data, apiId, api);
                }
            });
            IscApicUtil.invokeEnd(log, returnData, api);
            return ApiResult.success((Object)returnData);
        }
        catch (Exception e) {
            IscApicUtil.invokeEnd(log, e, api);
            return IscApiResult.ex(e);
        }
    }

    private static Object invokeApi(String caller, Map<String, Object> data, DynamicObject apiId, DynamicObject api) {
        Object returnData;
        TraceUtil.checkDisableTrace(api);
        IscApicUtil.checkCaller(apiId, "isc_apic_by_dc_trigger", caller);
        CheckApiParamUtil.checkTriggerInput(api, data);
        String type = api.getString(EXECUTION_TYPE);
        boolean syn = api.getBoolean("syn");
        if ("EXECUTE".equals(type)) {
            returnData = syn ? DataCopyOpenApi.syncExecute(api.getString("trigger.number"), data) : Long.valueOf(DataCopyOpenApi.doCopyByTriggerId(api.get("trigger_id"), data, null, null));
        } else if ("PUSH".equals(type)) {
            List dataList = CollectionUtils.toList(data.get("data"));
            returnData = syn ? DataCopyOpenApi.syncExecuteByPushData(api.getString("trigger.number"), dataList) : DataCopyOpenApi.start(api.getLong("trigger_id"), dataList);
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"%s \u4e0d\u652f\u6301\u7684\u6267\u884c\u65b9\u5f0f", (String)"DcTriggerApiDispatcher_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
        }
        return returnData;
    }

    public static void registerApiService() {
        QFilter filter = new QFilter("number", "=", (Object)"DcTriggerApiDispatcher");
        DynamicObject svc = BusinessDataServiceHelper.loadSingle((String)"open_apiservice", (String)"id", (QFilter[])new QFilter[]{filter});
        if (svc != null) {
            return;
        }
        svc = BusinessDataServiceHelper.newDynamicObject((String)"open_apiservice");
        svc.set("number", (Object)"DcTriggerApiDispatcher");
        svc.set("name", (Object)ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848API\u8f6c\u53d1", (String)"DcTriggerApiDispatcher_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        svc.set("appid", (Object)"TV3/VDJ86RC");
        svc.set("apiservicetype", (Object)2);
        svc.set("enable", (Object)1);
        svc.set("status", (Object)"C");
        svc.set("urlformat", (Object)DC_TRIGGER_API_DISPATCHER);
        svc.set("reqtype", (Object)0);
        svc.set("httpmethod", (Object)1);
        svc.set("contenttype", (Object)0);
        svc.set("creator", (Object)1);
        svc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        String plugin = "[{\"Type\":0,\"_Type_\":\"Plugin\",\"ClassName\":\"kd.isc.iscb.platform.core.api.DcTriggerApiDispatcher\",\"Enabled\":true,\"rowKey\":null}]";
        svc.set("plugin", (Object)plugin);
        ExecutionData.execute(svc, "save");
    }

    public String getVersion() {
        return "1.1";
    }

    static {
        try {
            DcTriggerApiDispatcher.registerApiService();
        }
        catch (Exception e) {
            LOG.warn("init integrate object api dispatcher failed.");
        }
    }
}

