/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.CheckApiParamUtil;
import kd.isc.iscb.platform.core.api.IscApiResult;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.DcType;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.dc.DataCopyOpenApi;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.trace.TraceUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.trace.TraceTask;

public class IntegrateSchemaApiDispatcher
implements IBillWebApiPlugin {
    public static final String ISC_SCHEMA_API_SERVICE_URL = "/app/iscb/IntegrateSchemaApiDispatcher";
    private static final String NUMBER = "number";
    private static final String CALLER = "caller";
    private static final Log logger = LogFactory.getLog(IntegrateSchemaApiDispatcher.class);

    public ApiResult doCustomService(WebApiContext ctx) {
        Map objectMap = ctx.getQueryString();
        if (objectMap == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"URL\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u9700\u8981\u5305\u542bAPI\u7f16\u7801!", (String)"IntegrateSchemaApiDispatcher_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String apiNumber = D.s(objectMap.get("api_number"));
        String caller = D.s(objectMap.get(CALLER));
        return IntegrateSchemaApiDispatcher.handle(apiNumber, caller, ctx.getData());
    }

    public static ApiResult handle(String apiNumber, final String caller, final Map<String, Object> data) {
        ApiResult permResult = UserPermissionUtil.checkAPIPermByParam("isc_apic_by_dc_schema", "4TAR7QONT/3J");
        if (!permResult.getSuccess()) {
            return permResult;
        }
        Assert.notNull((Object)apiNumber, (String)ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848API\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String)"IntegrateSchemaApiDispatcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        final DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_apic_by_dc_schema", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)apiNumber).and(new QFilter("enable", "=", (Object)"1"))});
        if (object == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684API\uff0c\u8bf7\u786e\u4fddAPI\u5df2\u7ecf\u542f\u7528!", (String)"IntegrateSchemaApiDispatcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObject log = IscApicUtil.invokeBegin(object, "isc_apic_by_dc_schema", caller, data);
        try {
            List result = log == null ? (List)TraceStack.run(TraceType.EXE_APIF, "isc_apic_by_dc_schema/" + apiNumber, object.getLong("id"), new TraceTask(){

                public Object invoke() {
                    return IntegrateSchemaApiDispatcher.invokeApi(caller, data, object);
                }
            }) : (List)TraceStack.run(TraceType.EXE_APIL, log, new TraceTask(){

                public Object invoke() {
                    return IntegrateSchemaApiDispatcher.invokeApi(caller, data, object);
                }
            });
            ApiResult apiResult = ApiResult.success((Object)result);
            IscApicUtil.invokeEnd(log, result, object);
            return apiResult;
        }
        catch (Exception e) {
            IscApicUtil.invokeEnd(log, e, object);
            return IscApiResult.ex(e);
        }
    }

    private static List<Map<String, Object>> invokeApi(String caller, Map<String, Object> data, DynamicObject object) {
        TraceUtil.checkDisableTrace(object);
        IscApicUtil.checkCaller(object, "isc_apic_by_dc_schema", caller);
        CheckApiParamUtil.checkDcInput(object, data);
        List<Map<String, Object>> result = IntegrateSchemaApiDispatcher.dispatchService(data, object);
        return result;
    }

    private static List<Map<String, Object>> dispatchService(Map<String, Object> params, DynamicObject object) {
        String schema = object.getString("schema.number");
        String type = object.getString("type");
        boolean ignoreError = D.x((Object)object.get("ignore_error"));
        int maxCount = D.i((Object)object.get("max_count"));
        if (0 == maxCount) {
            maxCount = 1000;
        }
        if (DcType.PULL == DcType.valueOf(type)) {
            return DataCopyOpenApi.pullBySchema(schema, params, (long)maxCount, ignoreError);
        }
        if (DcType.TRANSFER == DcType.valueOf(type)) {
            List data = CollectionUtils.toList(params.get("data"));
            return DataCopyOpenApi.transferBySchema(schema, (List<Map<String, Object>>)data);
        }
        if (DcType.PUSH == DcType.valueOf(type)) {
            List data = CollectionUtils.toList(params.get("data"));
            return DataCopyOpenApi.pushBySchema(schema, (List<Map<String, Object>>)data, ignoreError);
        }
        if (DcType.EXECUTE == DcType.valueOf(type)) {
            return DataCopyOpenApi.executeBySchema(schema, params, maxCount, ignoreError);
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u672a\u8bc6\u522bapi\u63a5\u53e3\uff1a%s", (String)"IntegrateSchemaApiDispatcher_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
    }

    public String getVersion() {
        return "1.1";
    }

    public static void registerApiService() {
        QFilter filter = new QFilter(NUMBER, "=", (Object)"IntegrateSchemaApiDispatcher");
        DynamicObject svc = BusinessDataServiceHelper.loadSingle((String)"open_apiservice", (String)"id", (QFilter[])new QFilter[]{filter});
        if (svc != null) {
            return;
        }
        svc = BusinessDataServiceHelper.newDynamicObject((String)"open_apiservice");
        svc.set(NUMBER, (Object)"IntegrateSchemaApiDispatcher");
        svc.set("name", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848API\u8f6c\u53d1", (String)"IntegrateSchemaApiDispatcher_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        svc.set("appid", (Object)"TV3/VDJ86RC");
        svc.set("apiservicetype", (Object)2);
        svc.set("enable", (Object)1);
        svc.set("status", (Object)"C");
        svc.set("urlformat", (Object)ISC_SCHEMA_API_SERVICE_URL);
        svc.set("reqtype", (Object)0);
        svc.set("httpmethod", (Object)1);
        svc.set("contenttype", (Object)0);
        svc.set("creator", (Object)1);
        svc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        String plugin = "[{\"Type\":0,\"_Type_\":\"Plugin\",\"ClassName\":\"kd.isc.iscb.platform.core.api.IntegrateSchemaApiDispatcher\",\"Enabled\":true,\"rowKey\":null}]";
        svc.set("plugin", (Object)plugin);
        ExecutionData.execute(svc, "save");
    }

    static {
        try {
            IntegrateSchemaApiDispatcher.registerApiService();
        }
        catch (Exception e) {
            logger.warn("init integrate schema api dispatcher failed.");
        }
    }
}

