/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.api.IscApiResult;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.sf.ServiceFlowHelper;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;

public class ServiceFlowApiOutputDispatcher
implements IBillWebApiPlugin {
    public static ApiResult handle(Map<String, Object> data) {
        ApiResult permResult = UserPermissionUtil.checkAPIPermByParam("isc_apic_by_sf", "4TAR7QONT/3J");
        if (!permResult.getSuccess()) {
            return permResult;
        }
        try {
            long procInstId = D.l((Object)data.get("id"));
            int limit = D.i((Object)data.get("limit"));
            Map<String, Object> hashMap = ServiceFlowHelper.getState(procInstId);
            hashMap.put("log", ServiceFlowApiOutputDispatcher.queryServiceFlowLogs(procInstId, limit).get("log"));
            return ApiResult.success(hashMap);
        }
        catch (Exception e) {
            return IscApiResult.ex(e);
        }
    }

    public static Map<String, Object> queryServiceFlowLogs(long procInstId, int limit) {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        List<Map<String, Object>> list = ServiceFlowApiOutputDispatcher.getLogList(procInstId, limit);
        result.put("log", list);
        return result;
    }

    private static List<Map<String, Object>> getLogList(long procInstId, int limit) {
        QFilter filter = new QFilter("proc_inst", "=", (Object)procInstId);
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"isc_sf_proc_log", (QFilter[])new QFilter[]{filter}, (String)"created_time desc", (int)(limit <= 0 ? 1 : Math.min(limit, 100)));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (!pks.isEmpty()) {
            DynamicObject[] logs;
            for (DynamicObject log : logs = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_sf_proc_log"))) {
                list.add(DynamicObjectUtil.object2Map(log));
            }
        }
        return list;
    }

    public String getVersion() {
        return "1.1";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        Map data = ctx.getData();
        this.checkDataEmpty(data);
        this.checkIdExisted(data);
        return ServiceFlowApiOutputDispatcher.handle(data);
    }

    public void checkDataEmpty(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ServiceFlowApiOutputDispatcher_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private void checkIdExisted(Map<String, Object> data) {
        if (data.get("id") == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u4e0d\u6b63\u786e\u7684\u53c2\u6570\u540d\uff0c\u53c2\u6570\u540d\u5fc5\u987b\u5305\u542bid\u3002", (String)"ServiceFlowApiOutputDispatcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }
}

