/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.openapi;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.api.ApiClassify;
import kd.isc.iscb.platform.core.api.ApiUtil;
import kd.isc.iscb.platform.core.api.openapi.OpenApiBuilder;
import kd.isc.iscb.platform.core.api.openapi.OpenApiConstFields;
import kd.isc.iscb.platform.core.api.openapi.v1.OpenApiVersion1Builder;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiVersion2BuilderFactory;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.QFilterUtil;

public class OpenApi
implements OpenApiConstFields {
    private DynamicObject iscApi;
    private OpenApiBuilder builder;

    public OpenApi(DynamicObject iscApi) {
        this.iscApi = iscApi;
        this.builder = ApiUtil.isVersion2Api(iscApi) ? OpenApiVersion2BuilderFactory.getBuilder(iscApi) : new OpenApiVersion1Builder();
    }

    public DynamicObject buildOpenApiAndSave() {
        if (!ApiUtil.isVersion2Api(this.iscApi)) {
            this.delete();
        }
        return this.builder.buildApiServiceAndSave(this.iscApi);
    }

    public void disable() {
        if (ApiUtil.isVersion2Api(this.iscApi)) {
            String number = this.getApiNumber();
            DynamicObject obj = OpenApi.getOpenApi(number, "openapi_customapi");
            if (obj != null) {
                obj.set("status", (Object)"D");
                obj.set("enable", (Object)"0");
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"openapi_customapi", (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)CommonUtil.getSkipPermissionOption());
                CommonUtil.check(result);
            }
        } else {
            this.delete();
        }
    }

    public void delete() {
        String number = this.getApiNumber();
        DynamicObject obj = OpenApi.getOpenApi(number, "openapi_apilist");
        if (obj != null) {
            obj.set("status", (Object)"D");
            obj.set("enable", (Object)"0");
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"openapi_apilist", (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)CommonUtil.getSkipPermissionOption());
            CommonUtil.check(result);
        }
    }

    private String getApiNumber() {
        return ApiClassify.getPrefix(this.iscApi.getDataEntityType().getName()) + this.iscApi.get("number");
    }

    public static DynamicObject getOpenApi(String number, String entity) {
        QFilter[] filters = QFilterUtil.builder().put("number", "=", number).put("appid.number", "=", "iscb").put("apiservicetype", "=", "2").build();
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"openapi_apilist", (QFilter[])filters, null, (int)1);
        if (pks.size() == 1) {
            return BusinessDataServiceHelper.loadSingle(pks.get(0), (String)entity);
        }
        return null;
    }
}

